/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionsMenu
extends ContributionItem
implements IWorkbenchContribution {
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private Range range;

    public void initialize(IServiceLocator serviceLocator) {
        ITextEditor editor = LSPEclipseUtils.getActiveTextEditor();
        if (editor != null) {
            ITextEditor textEditor = editor;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document == null) {
                return;
            }
            this.infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, LSPCodeActionMarkerResolution::providesCodeActions);
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            try {
                this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), document), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), document));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        if (this.infos.isEmpty()) {
            item.setText(Messages.notImplemented);
            return;
        }
        item.setText(Messages.computing);
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(this.infos.get(0).getFileUri().toString()));
        params.setRange(this.range);
        params.setContext(context);
        HashSet<CompletionStage> runningFutures = new HashSet<CompletionStage>();
        for (LanguageServiceAccessor.LSPDocumentInfo info : this.infos) {
            CompletionStage codeActions = info.getInitializedLanguageClient().thenComposeAsync(languageServer -> languageServer.getTextDocumentService().codeAction(params));
            runningFutures.add(codeActions);
            ((CompletableFuture)codeActions).whenComplete((arg_0, arg_1) -> this.lambda$2(runningFutures, (CompletableFuture)codeActions, menu, index, info, item, arg_0, arg_1));
        }
        super.fill(menu, index);
    }

    private void executeCommand(LanguageServiceAccessor.LSPDocumentInfo info, Command command) {
        ExecuteCommandOptions provider;
        ServerCapabilities capabilities = info.getCapabilites();
        if (capabilities != null && (provider = capabilities.getExecuteCommandProvider()) != null && provider.getCommands().contains(command.getCommand())) {
            ExecuteCommandParams params = new ExecuteCommandParams();
            params.setCommand(command.getCommand());
            params.setArguments(command.getArguments());
            info.getInitializedLanguageClient().thenAcceptAsync(ls -> {
                CompletableFuture completableFuture = ls.getWorkspaceService().executeCommand(params);
            });
        }
    }

    private /* synthetic */ void lambda$2(Set set, CompletableFuture completableFuture, final Menu menu, final int n, final LanguageServiceAccessor.LSPDocumentInfo lSPDocumentInfo, final MenuItem menuItem, final List t, final Throwable u) {
        set.remove(completableFuture);
        UIJob job = new UIJob(menu.getDisplay(), Messages.updateCodeActions_menu){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (u != null) {
                    MenuItem item = new MenuItem(menu, 0, n);
                    item.setText(u.getMessage());
                    item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"));
                    item.setEnabled(false);
                } else if (t != null) {
                    for (final Either command : t) {
                        if (command == null) continue;
                        if (command.isLeft()) {
                            MenuItem item = new MenuItem(menu, 0, n);
                            item.setText(((Command)command.getLeft()).getTitle());
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    LSPCodeActionsMenu.this.executeCommand(lSPDocumentInfo, (Command)command.getLeft());
                                }
                            });
                            continue;
                        }
                        if (!command.isRight()) continue;
                        CodeAction codeAction = (CodeAction)command.getRight();
                        if (codeAction.getEdit() != null) {
                            LSPEclipseUtils.applyWorkspaceEdit(codeAction.getEdit());
                        }
                        if (codeAction.getCommand() == null) continue;
                        LSPCodeActionsMenu.this.executeCommand(lSPDocumentInfo, codeAction.getCommand());
                    }
                }
                if (menu.getItemCount() == 1) {
                    menuItem.setText(Messages.codeActions_emptyMenu);
                } else {
                    menuItem.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

