/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public final class SystemConfPaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("SystemConfPaletteFactory.Location", "SystemConfPaletteFactory.Size", "SystemConfPaletteFactory.State");

    public static PaletteRoot createPalette(AutomationSystem system) {
        PaletteRoot palette = new PaletteRoot();
        SystemConfPaletteFactory.fillPalette(palette, system.getTypeLibrary());
        return palette;
    }

    private static void fillPalette(PaletteRoot palette, TypeLibrary typelib) {
        SystemConfPaletteFactory.createDevGroup(palette, typelib);
        SystemConfPaletteFactory.createRESGroup(palette, typelib);
        SystemConfPaletteFactory.createSEGGroup(palette, typelib);
    }

    private static PaletteDrawer createDevGroup(PaletteRoot palette, TypeLibrary typelib) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Devices");
        typelib.getDeviceTypes().forEachOrdered(entry -> {
            PaletteEntry typeEntry = SystemConfPaletteFactory.createCreationEntry((TypeEntry)entry, FordiacImage.ICON_DEVICE.getImageDescriptor());
            if (typeEntry != null) {
                paletteContainer.add(typeEntry);
            }
        });
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createRESGroup(PaletteRoot palette, TypeLibrary typelib) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Resources");
        typelib.getResourceTypes().forEachOrdered(entry -> {
            PaletteEntry paletteEntry = SystemConfPaletteFactory.createCreationEntry((TypeEntry)entry, FordiacImage.ICON_RESOURCE.getImageDescriptor());
            if (paletteEntry != null) {
                paletteContainer.add(paletteEntry);
            }
        });
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createSEGGroup(PaletteRoot palette, TypeLibrary typelib) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Segments");
        typelib.getSegmentTypes().forEachOrdered(entry -> {
            PaletteEntry paletteEntry = SystemConfPaletteFactory.createCreationEntry((TypeEntry)entry, FordiacImage.ICON_SEGMENT.getImageDescriptor());
            if (paletteEntry != null) {
                paletteContainer.add(paletteEntry);
            }
        });
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteEntry createCreationEntry(TypeEntry entry, ImageDescriptor desc) {
        LibraryElement type = entry.getType();
        if (type == null) {
            return null;
        }
        return new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new TemplateCreationFactory((Object)entry), desc, desc);
    }

    private SystemConfPaletteFactory() {
        throw new UnsupportedOperationException("Class SystemconfPaletteFactory should not be insantiated!");
    }
}

