/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.editors.ISubEditorInput;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementDependencyUpdater;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementStateListener;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractLibraryElementProvider<T extends LibraryElementInfo>
implements LibraryElementProvider {
    private final Map<IEditorInput, T> infos = new ConcurrentHashMap<IEditorInput, T>();
    private final Set<LibraryElementStateListener> listeners = ConcurrentHashMap.newKeySet();

    protected AbstractLibraryElementProvider() {
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)new LibraryElementUndoManager());
    }

    @Override
    public void connect(IEditorInput input) throws CoreException {
        AbstractLibraryElementProvider.checkAccess();
        Object info = this.getLibraryElementInfo(input);
        if (info == null) {
            info = (LibraryElementInfo)Objects.requireNonNull(this.createLibraryElementInfo(input));
            this.infos.put(((LibraryElementInfo)info).getEditorInput(), info);
            this.fireLibraryElementStateChange(listener -> listener.elementConnected(input));
        }
        ((LibraryElementInfo)info).connect();
    }

    @Override
    public void disconnect(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        if (info != null && ((LibraryElementInfo)info).disconnect()) {
            this.infos.remove(((LibraryElementInfo)info).getEditorInput(), info);
            this.fireLibraryElementStateChange(listener -> listener.elementDisconnected(input));
            ((LibraryElementInfo)info).dispose();
        }
    }

    public <U> U getElement(IEditorInput input, Class<? extends U> elementClass) throws ClassCastException {
        if (input instanceof ISubEditorInput) {
            ISubEditorInput subEditorInput = (ISubEditorInput)input;
            return elementClass.cast(this.getSubElement(subEditorInput));
        }
        return elementClass.cast(this.getLibraryElement(input));
    }

    protected Object getSubElement(ISubEditorInput input) {
        LibraryElement libraryElement = this.getLibraryElement(input);
        if (libraryElement == null) {
            return null;
        }
        if (input.getFragment().startsWith("/") && libraryElement.eResource() != null) {
            return libraryElement.eResource().getEObject(input.getFragment());
        }
        return libraryElement.findByQualifiedName(input.getFragment()).filter(arg_0 -> ((EClass)input.getElementClass()).isInstance(arg_0)).findFirst().orElse(null);
    }

    @Override
    public LibraryElement getLibraryElement(IEditorInput input) {
        T info = this.getLibraryElementInfo(input);
        return info != null ? ((LibraryElementInfo)info).getLibraryElement() : null;
    }

    @Override
    public void resetLibraryElement(IEditorInput input, IProgressMonitor monitor) throws CoreException {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        if (info != null) {
            AbstractLibraryElementProvider.executeOperation((IRunnableWithProgress)this.wrapOperation(info, this::doResetLibraryElement), monitor);
        }
    }

    protected abstract void doResetLibraryElement(T var1, IProgressMonitor var2) throws CoreException;

    @Override
    public void saveLibraryElement(IEditorInput input, IProgressMonitor monitor) throws CoreException {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        if (info != null) {
            AbstractLibraryElementProvider.executeOperation((IRunnableWithProgress)this.wrapOperation(info, this::doSaveLibraryElement), monitor);
        }
    }

    protected abstract void doSaveLibraryElement(T var1, IProgressMonitor var2) throws CoreException;

    @Override
    public void synchronize(IEditorInput input, IProgressMonitor monitor) throws CoreException {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        if (info != null) {
            AbstractLibraryElementProvider.executeOperation((IRunnableWithProgress)this.wrapOperation(info, this::doSynchronize), monitor);
        }
    }

    protected abstract void doSynchronize(T var1, IProgressMonitor var2) throws CoreException;

    @Override
    public boolean isSynchronized(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        if (info != null) {
            return this.doIsSynchronized(info);
        }
        return true;
    }

    protected abstract boolean doIsSynchronized(T var1);

    @Override
    public long getModificationStamp(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null ? this.doGetModificationStamp(info) : 0L;
    }

    protected abstract long doGetModificationStamp(T var1);

    @Override
    public long getSynchronizationStamp(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null ? ((LibraryElementInfo)info).getSynchronizationStamp() : 0L;
    }

    @Override
    public boolean mustSaveLibraryElement(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null && ((LibraryElementInfo)info).isDirty() && ((LibraryElementInfo)info).getReferenceCount() == 1;
    }

    @Override
    public boolean canSaveLibraryElement(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null && ((LibraryElementInfo)info).isDirty();
    }

    @Override
    public GraphicalAnnotationModel getAnnotationModel(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null ? ((LibraryElementInfo)info).getAnnotationModel() : null;
    }

    @Override
    public IUndoContext getUndoContext(IEditorInput input) {
        AbstractLibraryElementProvider.checkAccess();
        T info = this.getLibraryElementInfo(input);
        return info != null ? ((LibraryElementInfo)info).getUndoContext() : null;
    }

    @Override
    public void addLibraryElementStateListener(LibraryElementStateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLibraryElementStateListener(LibraryElementStateListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireLibraryElementStateChange(Consumer<LibraryElementStateListener> consumer) {
        this.listeners.forEach(listener -> SafeRunner.run(() -> consumer.accept((LibraryElementStateListener)listener)));
    }

    protected T createLibraryElementInfo(IEditorInput input) throws CoreException {
        if (input instanceof ISubEditorInput) {
            ISubEditorInput subEditorInput = (ISubEditorInput)input;
            return this.createLibraryElementInfo(subEditorInput.getParent());
        }
        throw new CoreException(Status.error((String)MessageFormat.format(Messages.AbstractLibraryElementProvider_CannotHandleInput, input.getToolTipText())));
    }

    protected final T getLibraryElementInfo(IEditorInput input) {
        if (input instanceof ISubEditorInput) {
            ISubEditorInput subEditorInput = (ISubEditorInput)input;
            return (T)((LibraryElementInfo)this.infos.get(subEditorInput.getParent()));
        }
        return (T)(input != null ? (LibraryElementInfo)this.infos.get(input) : null);
    }

    protected abstract WorkspaceModifyOperation wrapOperation(T var1, LibraryElementProviderOperation<T> var2);

    protected static void checkAccess() throws IllegalStateException {
        if (Display.getCurrent() == null) {
            throw new IllegalStateException("Must be in the Display thread");
        }
    }

    protected static void executeOperation(IRunnableWithProgress runnable, IProgressMonitor monitor) throws CoreException {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof CoreException) {
                CoreException coreException = (CoreException)throwable;
                throw coreException;
            }
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    protected abstract class LibraryElementInfo {
        private final IEditorInput input;
        private LibraryElement libraryElement;
        private long synchronizationStamp = -1L;
        private int referenceCount;
        private boolean dirty;
        private IUndoContext undoContext;
        private IUndoableOperation saveLocation;
        private final LibraryElementDependencyUpdater updater = new LibraryElementDependencyUpdater();

        protected LibraryElementInfo(IEditorInput input, LibraryElement libraryElement) {
            this.input = input;
            this.setLibraryElement(libraryElement);
        }

        protected IEditorInput getEditorInput() {
            return this.input;
        }

        protected LibraryElement getLibraryElement() {
            return this.libraryElement;
        }

        protected void setLibraryElement(LibraryElement libraryElement) {
            if (this.libraryElement != libraryElement) {
                this.libraryElement = libraryElement;
                this.undoContext = new ObjectUndoContext((Object)libraryElement);
                this.updater.setLibraryElement(libraryElement);
            }
        }

        protected long getSynchronizationStamp() {
            return this.synchronizationStamp;
        }

        protected void setSynchronizationStamp(long synchronizationStamp) {
            this.synchronizationStamp = synchronizationStamp;
        }

        protected abstract GraphicalAnnotationModel getAnnotationModel();

        protected int getReferenceCount() {
            return this.referenceCount;
        }

        protected void connect() {
            ++this.referenceCount;
        }

        protected boolean disconnect() {
            return --this.referenceCount == 0;
        }

        protected void dispose() {
            this.libraryElement = null;
            this.undoContext = new UndoContext();
        }

        protected boolean isDirty() {
            return this.dirty;
        }

        protected void setDirty(boolean dirty) {
            if (this.dirty != dirty) {
                this.dirty = dirty;
                AbstractLibraryElementProvider.this.fireLibraryElementStateChange(listener -> listener.elementDirtyStateChanged(this.input, dirty));
            }
        }

        protected void markDirty() {
            this.setDirty(true);
        }

        protected void updateDirty() {
            this.setDirty(this.getLastOperation() != this.getSaveLocation());
        }

        protected IUndoableOperation getSaveLocation() {
            return this.saveLocation;
        }

        protected void markSaveLocation() {
            this.saveLocation = this.getLastOperation();
        }

        protected IUndoContext getUndoContext() {
            return this.undoContext;
        }

        protected IUndoableOperation getLastOperation() {
            return Arrays.asList(OperationHistoryFactory.getOperationHistory().getUndoHistory(this.undoContext)).reversed().stream().filter(this::hasContextStrict).findFirst().orElse(null);
        }

        private boolean hasContextStrict(IUndoableOperation operation) {
            return Arrays.stream(operation.getContexts()).anyMatch(this.undoContext::equals);
        }
    }

    @FunctionalInterface
    protected static interface LibraryElementProviderOperation<T extends LibraryElementInfo> {
        public void run(T var1, IProgressMonitor var2) throws CoreException;
    }

    protected class LibraryElementUndoManager
    implements IOperationHistoryListener {
        protected LibraryElementUndoManager() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            switch (event.getEventType()) {
                case 4: {
                    this.findInfos(event).forEach(LibraryElementInfo::markDirty);
                    break;
                }
                case 9: 
                case 10: {
                    this.findInfos(event).forEach(LibraryElementInfo::updateDirty);
                    break;
                }
            }
        }

        protected Stream<T> findInfos(OperationHistoryEvent event) {
            return this.findInfos(event.getOperation().getContexts());
        }

        protected Stream<T> findInfos(IUndoContext[] contexts) {
            return Arrays.stream(contexts).map(this::findInfo).flatMap(Optional::stream);
        }

        protected Optional<T> findInfo(IUndoContext context) {
            return AbstractLibraryElementProvider.this.infos.values().stream().filter(info -> info.getUndoContext().matches(context)).findFirst();
        }
    }
}

