/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval.fb;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Watches;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorSharedState;
import org.eclipse.fordiac.ide.deployment.eval.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.function.StandardFunctions;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class DeploymentFBNetworkElementEvaluator<T extends FBType, I extends BlockFBNetworkElement>
extends FBEvaluator<T> {
    private static final String FAKE_TIME_DEV_PARAM_NAME = "FakeTime";
    private final I instance;
    private final Map<Event, AtomicInteger> eventCounters;
    private DeploymentEvaluatorSharedState sharedState;
    private boolean outputEvent;

    protected DeploymentFBNetworkElementEvaluator(T type, I instance, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
        instance.setName(this.getName() + "_" + UUID.randomUUID().toString());
        instance.setTypeEntry(this.getType().getTypeEntry());
        instance.setInterface(this.getType().getInterfaceList().instanceCopy());
        this.instance = instance;
        this.eventCounters = instance.getInterface().getEventOutputs().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), unused -> new AtomicInteger()));
    }

    public void prepare() {
        if (this.sharedState != null) {
            return;
        }
        try {
            this.sharedState = DeploymentEvaluatorSharedState.fromContext(this.getType().getTypeLibrary());
            this.sharedState.getResource().getFBNetwork().getNetworkElements().add(this.instance);
            this.sharedState.prepare();
            this.deployInstance();
            this.writeVariables();
            this.addWatches();
            this.updateWatches(this.sharedState.readWatches().getWatches());
            this.outputEvent = false;
        }
        catch (DeploymentException e) {
            throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
        }
    }

    public void cleanup() {
        if (this.sharedState == null) {
            return;
        }
        try {
            try {
                this.removeWatches();
                this.deleteInstance();
                this.sharedState.getResource().getFBNetwork().getNetworkElements().remove(this.instance);
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
            }
        }
        finally {
            this.sharedState = null;
            this.outputEvent = false;
        }
    }

    public void evaluate(Event event) throws EvaluatorException, InterruptedException {
        Event instanceEvent = this.getInstanceEvent(event);
        this.prepare();
        try {
            this.writeVariables();
            this.sharedState.writeDeviceParameter(FAKE_TIME_DEV_PARAM_NAME, StandardFunctions.NOW_MONOTONIC().toString());
            if (this.triggerEvent(instanceEvent)) {
                this.pollWatches();
            }
            this.update(this.getVariables().values());
        }
        catch (DeploymentException e) {
            throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
        }
    }

    protected void pollWatches() throws DeploymentException, InterruptedException {
        do {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.updateWatches(this.sharedState.readWatches().getWatches());
        } while (!this.outputEvent);
        this.outputEvent = false;
    }

    protected void addWatches() throws EvaluatorException {
        this.instance.getInterface().getEventOutputs().forEach(this::addWatch);
        this.instance.getInterface().getOutputVars().forEach(this::addWatch);
        this.instance.getInterface().getOutMappedInOutVars().forEach(this::addWatch);
    }

    protected void removeWatches() throws EvaluatorException {
        this.instance.getInterface().getEventOutputs().forEach(this::removeWatch);
        this.instance.getInterface().getOutputVars().forEach(this::removeWatch);
        this.instance.getInterface().getOutMappedInOutVars().forEach(this::removeWatch);
    }

    protected void updateWatches(Watches watches) throws EvaluatorException {
        if (watches == null) {
            return;
        }
        this.instance.getInterface().getEventOutputs().forEach(e -> this.updateWatch((Event)e, watches));
        this.instance.getInterface().getOutputVars().forEach(v -> this.updateWatch((VarDeclaration)v, watches));
        this.instance.getInterface().getOutMappedInOutVars().forEach(v -> this.updateWatch((VarDeclaration)v, watches));
    }

    protected void writeVariables() {
        this.instance.getInterface().getInputVars().forEach(this::writeVariable);
        this.instance.getInterface().getInOutVars().forEach(this::writeVariable);
    }

    protected abstract void deployInstance() throws DeploymentException;

    protected abstract void deleteInstance() throws DeploymentException;

    protected abstract void addWatch(IInterfaceElement var1) throws EvaluatorException;

    protected abstract void removeWatch(IInterfaceElement var1) throws EvaluatorException;

    protected abstract void updateWatch(Event var1, Watches var2) throws EvaluatorException;

    protected abstract void updateWatch(VarDeclaration var1, Watches var2) throws EvaluatorException;

    protected abstract boolean triggerEvent(Event var1) throws EvaluatorException;

    protected abstract void writeVariable(VarDeclaration var1) throws EvaluatorException;

    protected void updateWatch(Event event, int eventCount) throws EvaluatorException {
        Event typeEvent = this.getTypeEvent(event);
        if (eventCount == this.eventCounters.get(event).getAndSet(eventCount)) {
            return;
        }
        FBEvaluatorEventQueue fBEvaluatorEventQueue = this.getEventQueue();
        if (fBEvaluatorEventQueue instanceof FBEvaluatorCountingEventQueue) {
            FBEvaluatorCountingEventQueue countingEventQueue = (FBEvaluatorCountingEventQueue)fBEvaluatorEventQueue;
            countingEventQueue.getCount(typeEvent).set(eventCount);
        }
        if (!event.isIsInput()) {
            this.outputEvent = true;
        }
    }

    protected void updateWatch(VarDeclaration varDeclaration, Value newValue) throws EvaluatorException {
        Variable variable = (Variable)this.getVariables().get(varDeclaration.getName());
        if (variable != null) {
            variable.setValue(newValue);
        }
    }

    protected int parseWatchValue(Event event, String value) throws EvaluatorException {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new EvaluatorException(MessageFormat.format(Messages.DeploymentFBNetworkElementEvaluator_InvalidWatchValue, event.getQualifiedName()), (Throwable)e, (Evaluator)this);
        }
    }

    protected Value parseWatchValue(VarDeclaration varDeclaration, String value) throws EvaluatorException {
        try {
            return VariableOperations.newVariable((VarDeclaration)varDeclaration, (String)value).getValue();
        }
        catch (Exception e) {
            throw new EvaluatorException(MessageFormat.format(Messages.DeploymentFBNetworkElementEvaluator_InvalidWatchValue, varDeclaration.getQualifiedName()), (Throwable)e, (Evaluator)this);
        }
    }

    protected String getWatchValue(Watches watches, IInterfaceElement element) throws EvaluatorException {
        return this.findWatchValue(watches, element).orElseThrow(() -> new EvaluatorException(MessageFormat.format(Messages.DeploymentFBNetworkElementEvaluator_NoWatchValue, element.getQualifiedName()), (Evaluator)this));
    }

    protected Optional<String> findWatchValue(Watches watches, IInterfaceElement element) {
        return this.findPort(watches, element).map(Port::getDataValues).stream().flatMap(Collection::stream).map(Data::getValue).findFirst();
    }

    protected Optional<Port> findPort(Watches watches, IInterfaceElement element) {
        return this.findFB(watches, (FBNetworkElement)element.getBlockFBNetworkElement()).map(FB::getPorts).stream().flatMap(Collection::stream).filter(port -> element.getName().equals(port.getName())).findAny();
    }

    protected Optional<FB> findFB(Watches watches, FBNetworkElement element) {
        return this.findResource(watches).map(org.eclipse.fordiac.ide.deployment.devResponse.Resource::getFbs).stream().flatMap(Collection::stream).filter(fb -> this.getResourceRelativeName((INamedElement)element).equals(fb.getName())).findAny();
    }

    protected Optional<org.eclipse.fordiac.ide.deployment.devResponse.Resource> findResource(Watches watches) {
        return watches.getResources().stream().filter(resource -> this.sharedState.getResource().getName().equals(resource.getName())).findAny();
    }

    protected Event getTypeEvent(Event instanceEvent) {
        Event typeEvent = this.getType().getInterfaceList().getEvent(instanceEvent.getName());
        if (typeEvent == null) {
            throw new EvaluatorException(MessageFormat.format(Messages.DeploymentFBNetworkElementEvaluator_NoSuchTypeEvent, instanceEvent.getQualifiedName()), (Evaluator)this);
        }
        return typeEvent;
    }

    protected Event getInstanceEvent(Event typeEvent) {
        Event instanceEvent = this.instance.getInterface().getEvent(typeEvent.getName());
        if (instanceEvent == null) {
            throw new EvaluatorException(MessageFormat.format(Messages.DeploymentFBNetworkElementEvaluator_NoSuchInstanceEvent, typeEvent.getQualifiedName()), (Evaluator)this);
        }
        return instanceEvent;
    }

    protected String getResourceRelativeName(INamedElement element) {
        return DeploymentDebugWatchUtils.getResourceRelativeName((INamedElement)element, (Resource)this.sharedState.getResource());
    }

    protected DeploymentEvaluatorSharedState getSharedState() {
        return this.sharedState;
    }

    public Map<ICallable, Evaluator> getChildren() {
        return Collections.emptyMap();
    }

    public I getInstance() {
        return this.instance;
    }
}

