/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.simulator.forte;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.Utils;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.IDeviceSimulator;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class DeviceSimulator
implements IDeviceSimulator {
    private final Device device;
    private final String path;
    private final IDeviceManagementExecutorService executorService;
    private Map<String, Set<String>> allPortsByResource = new HashMap<String, Set<String>>();
    private final Map<Resource, ReplayNavigator.DatapointsState> currentStates = new HashMap<Resource, ReplayNavigator.DatapointsState>();

    public DeviceSimulator(IDeviceManagementExecutorService executorService, Device device, String path) {
        this.device = device;
        this.path = path;
        this.executorService = executorService;
    }

    @Override
    public Optional<String> replayNextEvent(Resource resource) {
        try {
            Optional lastEvent = this.executorService.replayNextEvent(resource);
            DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(this.executorService.readWatches());
            this.currentStates.put(resource, DeviceSimulator.getWatchData(watchData, resource, this.allPortsByResource.get(resource.getName())));
            return lastEvent;
        }
        catch (DeploymentException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public ReplayNavigator.DatapointsState getCurrentState(Resource resource) {
        return this.currentStates.get(resource);
    }

    @Override
    public boolean start() {
        try {
            this.executorService.connect();
            this.executorService.readTraces(this.device, this.path);
            this.allPortsByResource = Utils.collectAllValueHolders(this.device);
            for (Resource resource : this.device.getResource()) {
                for (String portName : this.allPortsByResource.get(resource.getName())) {
                    this.executorService.addWatch(resource, portName);
                }
                DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(this.executorService.readWatches());
                this.currentStates.put(resource, DeviceSimulator.getWatchData(watchData, resource, this.allPortsByResource.get(resource.getName())));
            }
        }
        catch (DeploymentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        try {
            this.executorService.disconnect();
        }
        catch (DeploymentException e) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.DeploymentDebugDevice_ConnectError, this.device.getName()));
            return false;
        }
        return true;
    }

    private static ReplayNavigator.DatapointsState getWatchData(DeploymentDebugWatchData data, Resource resource, Set<String> portNames) {
        ReplayNavigator.DatapointsState result = new ReplayNavigator.DatapointsState();
        for (String portName : portNames) {
            Data portData = data.getLastData(resource, portName);
            if (portData == null) continue;
            result.put(portName, portData.getValue());
        }
        return result;
    }
}

