/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayDebuggingResource;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.DataPointChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.EventChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.IDeviceSimulator;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.interpreter.DeviceSimulator;
import org.eclipse.fordiac.ide.debug.replaydebugging.watch.WatchFactoryReplay;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ReplayDebuggingDevice
extends DeploymentDebugDevice
implements ReplayDebuggingResource.UpdateListener {
    private final String tracesPath;
    private final List<ReplayDebuggingResource> replayDebuggingResources = new ArrayList<ReplayDebuggingResource>();
    private final Map<String, String> allCurentChanges = new HashMap<String, String>();
    private final Response response = DevResponseFactory.eINSTANCE.createResponse();
    private final Map<String, IWatch> watches = new ConcurrentSkipListMap<String, IWatch>();
    private final boolean remote;

    public ReplayDebuggingDevice(Device device, DeploymentDebugTarget debugTarget, String tracesPath, boolean remote) {
        super(device, debugTarget, true, Duration.ZERO, List.of());
        this.tracesPath = tracesPath;
        this.remote = remote;
    }

    public void connect() throws DebugException {
        IDeviceSimulator simulator = this.createSimulator();
        simulator.start();
        this.response.setWatches(DevResponseFactory.eINSTANCE.createWatches());
        Device device = this.getDevice();
        for (Resource resource : device.getResource()) {
            ReplayDebuggingResource replayDebuggingResource = new ReplayDebuggingResource(resource, new ReplayNavigator.Identifier(device.getAutomationSystem().getName(), device.getName(), resource.getName()), simulator, this);
            replayDebuggingResource.load();
            this.replayDebuggingResources.add(replayDebuggingResource);
            this.response.getWatches().getResources().add((Object)replayDebuggingResource.getResourceResponse());
        }
        simulator.stop();
    }

    private IDeviceSimulator createSimulator() {
        if (this.remote) {
            return new org.eclipse.fordiac.ide.debug.replaydebugging.simulator.forte.DeviceSimulator(this.getDeviceManagementExecutorService(), this.getDevice(), this.tracesPath);
        }
        return new DeviceSimulator(this.getDevice(), this.tracesPath);
    }

    private void setError(IWatch watch) {
        if (watch instanceof WatchFactoryReplay.IWatchWithPublicError) {
            WatchFactoryReplay.IWatchWithPublicError watchWithError = (WatchFactoryReplay.IWatchWithPublicError)watch;
            if (watch instanceof WatchFactoryReplay.FBNetworkElementWatchReplay) {
                WatchFactoryReplay.FBNetworkElementWatchReplay fbWatch = (WatchFactoryReplay.FBNetworkElementWatchReplay)watch;
                for (IWatch subWatch : fbWatch.getSubWatches()) {
                    this.setError(subWatch);
                }
            } else if (this.allCurentChanges.containsKey(watch.getQualifiedName())) {
                watchWithError.setError(this.allCurentChanges.get(watch.getQualifiedName()));
            } else {
                watchWithError.clearError();
            }
        }
    }

    public void disconnect() throws DebugException {
        super.disconnect();
        this.unloadAllReplayDebuggingResources();
    }

    public void terminate() throws DebugException {
        super.terminate();
        this.unloadAllReplayDebuggingResources();
    }

    private void unloadAllReplayDebuggingResources() {
        for (ReplayDebuggingResource replayDebuggingResource : this.replayDebuggingResources) {
            replayDebuggingResource.unload();
        }
        this.replayDebuggingResources.clear();
    }

    @Override
    public void onUpdate(ReplayDebuggingResource notUsed) {
        this.allCurentChanges.clear();
        for (ReplayDebuggingResource replayDebuggingResource : this.replayDebuggingResources) {
            EventChange eventChange = replayDebuggingResource.getCurrentEventChange();
            if (eventChange == null) continue;
            for (DataPointChange dataPointChange : eventChange.newValues()) {
                String datapoint = dataPointChange.datapoint();
                String newValue = dataPointChange.newValue();
                this.allCurentChanges.put(datapoint, newValue);
            }
        }
        this.updateWatches();
    }

    protected void updateWatches() {
        this.incrementVariableUpdateCount();
        DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(this.response);
        this.watches.values().forEach(watch -> {
            watch.updateValue(watchData);
            this.setError((IWatch)watch);
        });
        this.getPrimaryDebugTarget().updateWatches(false);
    }

    protected void terminated() {
        this.watches.values().forEach(IWatch::disconnected);
        this.getPrimaryDebugTarget().updateWatches(false);
        this.fireTerminateEvent();
    }

    public Map<String, IWatch> getWatches() {
        return Collections.unmodifiableMap(this.watches);
    }

    protected void removeWatch(DeploymentWatchpoint watchpoint) {
        IWatch watch = this.watches.remove(watchpoint.getLocation());
        if (watch != null) {
            try {
                this.getPrimaryDebugTarget().updateWatches(true);
                watch.removeWatch();
            }
            catch (DebugException e) {
                FordiacLogHelper.logWarning((String)("Cannot remove watch for watchpoint: " + String.valueOf(watchpoint)), (Exception)((Object)e));
            }
        }
    }

    protected void updatePinned(DeploymentWatchpoint watchpoint) {
        IWatch watch = this.watches.get(watchpoint.getLocation());
        if (watch != null) {
            watch.setPinned(watchpoint.isPinned());
            this.getPrimaryDebugTarget().updateWatches(true);
        }
    }

    protected void addWatch(DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint watchpoint) {
        Optional element = watchpoint.getTarget(this.getDevice());
        if (element.isPresent()) {
            try {
                IWatch watch = this.watches.computeIfAbsent(((INamedElement)element.get()).getQualifiedName(), name -> WatchFactoryReplay.watchFor(name, (INamedElement)element.get(), this));
                watch.setSource(IWatch.Source.LAUNCH);
                this.getPrimaryDebugTarget().updateWatches(true);
                watch.addWatch();
                this.updateWatches();
            }
            catch (CoreException e) {
                FordiacLogHelper.logWarning((String)("Cannot create watch for watchpoint: " + String.valueOf(watchpoint)), (Exception)((Object)e));
            }
        }
    }

    protected void addWatch(DeploymentWatchpoint watchpoint) {
        Optional element = watchpoint.getTarget(this.getDevice());
        if (element.isPresent()) {
            try {
                IWatch watch = this.watches.computeIfAbsent(((INamedElement)element.get()).getQualifiedName(), name -> WatchFactoryReplay.watchFor(name, (INamedElement)element.get(), this));
                watch.setSource(IWatch.Source.BREAKPOINT);
                watch.setPinned(watchpoint.isPinned());
                this.getPrimaryDebugTarget().updateWatches(true);
                watch.addWatch();
                watchpoint.setInstalled(true);
                this.updateWatches();
            }
            catch (CoreException e) {
                FordiacLogHelper.logWarning((String)("Cannot create watch for watchpoint: " + String.valueOf(watchpoint)), (Exception)((Object)e));
            }
        }
    }
}

