/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.comparator.primitive.FloatComparator;
import org.eclipse.collections.api.block.function.primitive.FloatIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.tuple.primitive.FloatFloatPair;
import org.eclipse.collections.api.tuple.primitive.FloatObjectPair;

public interface MutableFloatList
extends MutableFloatCollection,
FloatList {
    public void addAtIndex(int var1, float var2);

    public boolean addAllAtIndex(int var1, float ... var2);

    public boolean addAllAtIndex(int var1, FloatIterable var2);

    public float removeAtIndex(int var1);

    public float set(int var1, float var2);

    public MutableList<Float> boxed();

    default public void swap(int index1, int index2) {
        float value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableFloatList select(FloatPredicate var1);

    @Override
    public MutableFloatList reject(FloatPredicate var1);

    @Override
    public MutableFloatList with(float var1);

    @Override
    public MutableFloatList without(float var1);

    @Override
    public MutableFloatList withAll(FloatIterable var1);

    @Override
    public MutableFloatList withoutAll(FloatIterable var1);

    @Override
    default public MutableFloatList tap(FloatProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    default public MutableFloatList selectWithIndex(FloatIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableFloatList rejectWithIndex(FloatIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> MutableList<V> collect(FloatToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(FloatIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((float each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableFloatList reverseThis();

    @Override
    public MutableFloatList toReversed();

    @Override
    public MutableFloatList distinct();

    public MutableFloatList sortThis();

    default public MutableFloatList sortThis(FloatComparator comparator) {
        throw new UnsupportedOperationException("sortThis(FloatComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableFloatList sortThisBy(FloatToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableFloatList sortThisBy(FloatToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableFloatList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableFloatList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            float selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableFloatList asUnmodifiable();

    @Override
    public MutableFloatList asSynchronized();

    @Override
    public ImmutableFloatList toImmutable();

    @Override
    public MutableFloatList subList(int var1, int var2);

    default public MutableList<FloatFloatPair> zipFloat(FloatIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<FloatObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableFloatList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

