/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class GetEndpointsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=426");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=428");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=427");
    private final RequestHeader requestHeader;
    private final String endpointUrl;
    private final String[] localeIds;
    private final String[] profileUris;

    public GetEndpointsRequest(RequestHeader requestHeader, String endpointUrl, String[] localeIds, String[] profileUris) {
        this.requestHeader = requestHeader;
        this.endpointUrl = endpointUrl;
        this.localeIds = localeIds;
        this.profileUris = profileUris;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public String[] getProfileUris() {
        return this.profileUris;
    }

    protected GetEndpointsRequest(GetEndpointsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((GetEndpointsRequestBuilder)b).requestHeader;
        this.endpointUrl = ((GetEndpointsRequestBuilder)b).endpointUrl;
        this.localeIds = ((GetEndpointsRequestBuilder)b).localeIds;
        this.profileUris = ((GetEndpointsRequestBuilder)b).profileUris;
    }

    public static GetEndpointsRequestBuilder<?, ?> builder() {
        return new GetEndpointsRequestBuilderImpl();
    }

    public GetEndpointsRequestBuilder<?, ?> toBuilder() {
        return new GetEndpointsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEndpointsRequest)) {
            return false;
        }
        GetEndpointsRequest other = (GetEndpointsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLocaleIds(), other.getLocaleIds())) {
            return false;
        }
        return Arrays.deepEquals(this.getProfileUris(), other.getProfileUris());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetEndpointsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLocaleIds());
        result = result * 59 + Arrays.deepHashCode(this.getProfileUris());
        return result;
    }

    @Override
    public String toString() {
        return "GetEndpointsRequest(requestHeader=" + this.getRequestHeader() + ", endpointUrl=" + this.getEndpointUrl() + ", localeIds=" + Arrays.deepToString(this.getLocaleIds()) + ", profileUris=" + Arrays.deepToString(this.getProfileUris()) + ")";
    }

    private static final class GetEndpointsRequestBuilderImpl
    extends GetEndpointsRequestBuilder<GetEndpointsRequest, GetEndpointsRequestBuilderImpl> {
        private GetEndpointsRequestBuilderImpl() {
        }

        @Override
        protected GetEndpointsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public GetEndpointsRequest build() {
            return new GetEndpointsRequest(this);
        }
    }

    public static abstract class GetEndpointsRequestBuilder<C extends GetEndpointsRequest, B extends GetEndpointsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private String endpointUrl;
        private String[] localeIds;
        private String[] profileUris;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GetEndpointsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(GetEndpointsRequest instance, GetEndpointsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.endpointUrl(instance.endpointUrl);
            b.localeIds(instance.localeIds);
            b.profileUris(instance.profileUris);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return (B)this.self();
        }

        public B localeIds(String[] localeIds) {
            this.localeIds = localeIds;
            return (B)this.self();
        }

        public B profileUris(String[] profileUris) {
            this.profileUris = profileUris;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "GetEndpointsRequest.GetEndpointsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", endpointUrl=" + this.endpointUrl + ", localeIds=" + Arrays.deepToString(this.localeIds) + ", profileUris=" + Arrays.deepToString(this.profileUris) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<GetEndpointsRequest> {
        @Override
        public Class<GetEndpointsRequest> getType() {
            return GetEndpointsRequest.class;
        }

        @Override
        public GetEndpointsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            String endpointUrl = decoder.readString("EndpointUrl");
            String[] localeIds = decoder.readStringArray("LocaleIds");
            String[] profileUris = decoder.readStringArray("ProfileUris");
            return new GetEndpointsRequest(requestHeader, endpointUrl, localeIds, profileUris);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, GetEndpointsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeString("EndpointUrl", value.getEndpointUrl());
            encoder.writeStringArray("LocaleIds", value.getLocaleIds());
            encoder.writeStringArray("ProfileUris", value.getProfileUris());
        }
    }
}

