/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.CenterEdgeLabelPlacementStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public final class LabelDummySwitcher
implements ILayoutProcessor<LGraph> {
    public static final IProperty<Boolean> INCLUDE_LABEL = new Property("edgelabelcenterednessanalysis.includelabel", (Object)Boolean.FALSE);
    private double[] layerWidths = null;

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        CenterEdgeLabelPlacementStrategy strategy;
        monitor.begin("Label dummy switching", 1.0f);
        CenterEdgeLabelPlacementStrategy defaultPlacementStrategy = (CenterEdgeLabelPlacementStrategy)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY));
        this.assignIdsToLayers(layeredGraph);
        Map<CenterEdgeLabelPlacementStrategy, List<LabelDummyInfo>> labelDummyInfos = this.gatherLabelDummyInfos(layeredGraph, defaultPlacementStrategy);
        this.layerWidths = new double[layeredGraph.getLayers().size()];
        CenterEdgeLabelPlacementStrategy[] centerEdgeLabelPlacementStrategyArray = CenterEdgeLabelPlacementStrategy.values();
        int n = centerEdgeLabelPlacementStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            strategy = centerEdgeLabelPlacementStrategyArray[n2];
            if (strategy.usesLabelSizeInformation() && !labelDummyInfos.get((Object)strategy).isEmpty()) {
                this.calculateLayerWidths(layeredGraph);
                break;
            }
            ++n2;
        }
        centerEdgeLabelPlacementStrategyArray = CenterEdgeLabelPlacementStrategy.values();
        n = centerEdgeLabelPlacementStrategyArray.length;
        n2 = 0;
        while (n2 < n) {
            strategy = centerEdgeLabelPlacementStrategyArray[n2];
            if (!strategy.usesLabelSizeInformation()) {
                this.processStrategy(labelDummyInfos.get((Object)strategy));
            }
            ++n2;
        }
        centerEdgeLabelPlacementStrategyArray = CenterEdgeLabelPlacementStrategy.values();
        n = centerEdgeLabelPlacementStrategyArray.length;
        n2 = 0;
        while (n2 < n) {
            strategy = centerEdgeLabelPlacementStrategyArray[n2];
            if (strategy.usesLabelSizeInformation()) {
                this.processStrategy(labelDummyInfos.get((Object)strategy));
            }
            ++n2;
        }
        this.layerWidths = null;
        monitor.done();
    }

    private void assignIdsToLayers(LGraph layeredGraph) {
        int layerIndex = 0;
        for (Layer layer : layeredGraph) {
            layer.id = layerIndex++;
        }
    }

    private Map<CenterEdgeLabelPlacementStrategy, List<LabelDummyInfo>> gatherLabelDummyInfos(LGraph layeredGraph, CenterEdgeLabelPlacementStrategy defaultPlacementStrategy) {
        EnumMap<CenterEdgeLabelPlacementStrategy, List<LabelDummyInfo>> infos = new EnumMap<CenterEdgeLabelPlacementStrategy, List<LabelDummyInfo>>(CenterEdgeLabelPlacementStrategy.class);
        CenterEdgeLabelPlacementStrategy[] centerEdgeLabelPlacementStrategyArray = CenterEdgeLabelPlacementStrategy.values();
        int n = centerEdgeLabelPlacementStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            CenterEdgeLabelPlacementStrategy strategy = centerEdgeLabelPlacementStrategyArray[n2];
            infos.put(strategy, new ArrayList());
            ++n2;
        }
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> node.getType() == LNode.NodeType.LABEL).map(labelDummy -> new LabelDummyInfo((LNode)((Object)labelDummy), defaultPlacementStrategy)).forEach(dummyInfo -> {
            boolean bl = ((List)infos.get((Object)dummyInfo.placementStrategy)).add(dummyInfo);
        });
        return infos;
    }

    private void calculateLayerWidths(LGraph layeredGraph) {
        assert (this.layerWidths.length == layeredGraph.getLayers().size());
        for (Layer layer : layeredGraph.getLayers()) {
            this.layerWidths[layer.id] = LGraphUtil.findMaxNonDummyNodeWidth(layer, false);
        }
    }

    private void processStrategy(List<LabelDummyInfo> labelDummyInfos) {
        if (labelDummyInfos.isEmpty()) {
            return;
        }
        if (labelDummyInfos.get((int)0).placementStrategy == CenterEdgeLabelPlacementStrategy.SPACE_EFFICIENT_LAYER) {
            this.computeSpaceEfficientAssignment(labelDummyInfos);
        } else {
            for (LabelDummyInfo labelDummyInfo : labelDummyInfos) {
                switch (labelDummyInfo.placementStrategy) {
                    case CENTER_LAYER: {
                        this.assignLayer(labelDummyInfo, this.findCenterLayerTargetId(labelDummyInfo));
                        break;
                    }
                    case MEDIAN_LAYER: {
                        this.assignLayer(labelDummyInfo, this.findMedianLayerTargetId(labelDummyInfo));
                        break;
                    }
                    case WIDEST_LAYER: {
                        this.assignLayer(labelDummyInfo, this.findWidestLayerTargetId(labelDummyInfo));
                        break;
                    }
                    case HEAD_LAYER: {
                        this.setEndLayerNodeAlignment(labelDummyInfo);
                        this.assignLayer(labelDummyInfo, this.findEndLayerTargetId(labelDummyInfo, true));
                        break;
                    }
                    case TAIL_LAYER: {
                        this.setEndLayerNodeAlignment(labelDummyInfo);
                        this.assignLayer(labelDummyInfo, this.findEndLayerTargetId(labelDummyInfo, false));
                    }
                }
                this.updateLongEdgeSourceLabelDummyInfo(labelDummyInfo);
            }
        }
    }

    private int findWidestLayerTargetId(LabelDummyInfo labelDummyInfo) {
        int widestLayerIndex = labelDummyInfo.leftmostLayerId;
        int index = widestLayerIndex + 1;
        while (index <= labelDummyInfo.rightmostLayerId) {
            if (this.layerWidths[index] > this.layerWidths[widestLayerIndex]) {
                widestLayerIndex = index;
            }
            ++index;
        }
        return widestLayerIndex;
    }

    private int findCenterLayerTargetId(LabelDummyInfo labelDummyInfo) {
        double[] layerWidthSums = this.computeLayerWidthSums(labelDummyInfo);
        double threshold = layerWidthSums[layerWidthSums.length - 1] / 2.0;
        int i = 0;
        while (i < layerWidthSums.length) {
            if (layerWidthSums[i] >= threshold) {
                return labelDummyInfo.leftmostLayerId + i;
            }
            ++i;
        }
        assert (false);
        return labelDummyInfo.leftmostLayerId + labelDummyInfo.leftLongEdgeDummies.size();
    }

    private double[] computeLayerWidthSums(LabelDummyInfo labelDummyInfo) {
        LGraph lgraph = labelDummyInfo.labelDummy.getGraph();
        double edgeNodeSpacing = (Double)lgraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS) * 2.0;
        double nodeNodeSpacing = (Double)lgraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double minSpaceBetweenLayers = Math.max(edgeNodeSpacing, nodeNodeSpacing);
        double[] layerWidthSums = new double[labelDummyInfo.totalDummyCount()];
        double currentWidthSum = -minSpaceBetweenLayers;
        int currentIndex = 0;
        for (LNode leftDummy : labelDummyInfo.leftLongEdgeDummies) {
            layerWidthSums[currentIndex++] = currentWidthSum += this.layerWidths[leftDummy.getLayer().id] + minSpaceBetweenLayers;
        }
        layerWidthSums[currentIndex++] = currentWidthSum += this.layerWidths[labelDummyInfo.labelDummy.getLayer().id] + minSpaceBetweenLayers;
        for (LNode rightDummy : labelDummyInfo.rightLongEdgeDummies) {
            layerWidthSums[currentIndex++] = currentWidthSum += this.layerWidths[rightDummy.getLayer().id] + minSpaceBetweenLayers;
        }
        return layerWidthSums;
    }

    private int findMedianLayerTargetId(LabelDummyInfo labelDummyInfo) {
        int layers = labelDummyInfo.totalDummyCount();
        int lowerMedian = (layers - 1) / 2;
        return labelDummyInfo.leftmostLayerId + lowerMedian;
    }

    private int findEndLayerTargetId(LabelDummyInfo labelDummyInfo, boolean headLayer) {
        boolean reversed = this.isPartOfReversedEdge(labelDummyInfo);
        if (headLayer && !reversed || !headLayer && reversed) {
            return labelDummyInfo.rightmostLayerId;
        }
        return labelDummyInfo.leftmostLayerId;
    }

    private void setEndLayerNodeAlignment(LabelDummyInfo labelDummyInfo) {
        assert (labelDummyInfo.placementStrategy == CenterEdgeLabelPlacementStrategy.HEAD_LAYER || labelDummyInfo.placementStrategy == CenterEdgeLabelPlacementStrategy.TAIL_LAYER);
        boolean isHeadLabel = labelDummyInfo.placementStrategy == CenterEdgeLabelPlacementStrategy.HEAD_LAYER;
        boolean isPartOfReversedEdge = this.isPartOfReversedEdge(labelDummyInfo);
        if (isHeadLabel && !isPartOfReversedEdge || !isHeadLabel && isPartOfReversedEdge) {
            labelDummyInfo.labelDummy.setProperty(LayeredOptions.ALIGNMENT, Alignment.RIGHT);
        } else {
            labelDummyInfo.labelDummy.setProperty(LayeredOptions.ALIGNMENT, Alignment.LEFT);
        }
    }

    private boolean isPartOfReversedEdge(LabelDummyInfo labelDummyInfo) {
        assert (labelDummyInfo.labelDummy.getType() == LNode.NodeType.LABEL);
        assert (labelDummyInfo.labelDummy.getIncomingEdges().iterator().hasNext());
        assert (labelDummyInfo.labelDummy.getOutgoingEdges().iterator().hasNext());
        LEdge incoming = labelDummyInfo.labelDummy.getIncomingEdges().iterator().next();
        LEdge outgoing = labelDummyInfo.labelDummy.getOutgoingEdges().iterator().next();
        return (Boolean)incoming.getProperty(InternalProperties.REVERSED) != false || (Boolean)outgoing.getProperty(InternalProperties.REVERSED) != false;
    }

    private void computeSpaceEfficientAssignment(List<LabelDummyInfo> labelDummyInfos) {
        List<LabelDummyInfo> nonTrivialLabels = this.performTrivialAssignments(labelDummyInfos);
        if (nonTrivialLabels.isEmpty()) {
            return;
        }
        nonTrivialLabels.sort((info1, info2) -> Double.compare(info2.labelDummy.getSize().x, info1.labelDummy.getSize().x));
        int labelCount = nonTrivialLabels.size();
        int labelIndex = 0;
        while (labelIndex < labelCount) {
            this.assignLayer(nonTrivialLabels.get(labelIndex), this.findPotentiallyWidestLayer(nonTrivialLabels, labelIndex));
            ++labelIndex;
        }
    }

    private List<LabelDummyInfo> performTrivialAssignments(List<LabelDummyInfo> labelDummyInfos) {
        ArrayList<LabelDummyInfo> remainingLabels = new ArrayList<LabelDummyInfo>(labelDummyInfos.size());
        for (LabelDummyInfo labelDummyInfo : labelDummyInfos) {
            if (labelDummyInfo.leftmostLayerId == labelDummyInfo.rightmostLayerId) {
                this.assignLayer(labelDummyInfo, labelDummyInfo.leftmostLayerId);
                continue;
            }
            if (this.assignToWiderLayer(labelDummyInfo)) continue;
            remainingLabels.add(labelDummyInfo);
        }
        return remainingLabels;
    }

    private boolean assignToWiderLayer(LabelDummyInfo labelDummyInfo) {
        double dummyWidth = labelDummyInfo.labelDummy.getSize().x;
        List<Layer> validLayers = labelDummyInfo.labelDummy.getGraph().getLayers().subList(labelDummyInfo.leftmostLayerId, labelDummyInfo.rightmostLayerId + 1);
        for (Layer layer : validLayers) {
            if (!(layer.getSize().x >= dummyWidth)) continue;
            this.assignLayer(labelDummyInfo, layer.id);
            return true;
        }
        return false;
    }

    private int findPotentiallyWidestLayer(List<LabelDummyInfo> labelDummyInfos, int labelIndex) {
        assert (labelIndex >= 0 && labelIndex < labelDummyInfos.size());
        int labelCount = labelDummyInfos.size();
        LabelDummyInfo labelDummyInfo = labelDummyInfos.get(labelIndex);
        double labelDummyWidth = labelDummyInfo.labelDummy.getSize().x;
        int widestLayerIndex = labelDummyInfo.leftmostLayerId;
        double widestLayerWidth = 0.0;
        int layer = labelDummyInfo.leftmostLayerId;
        while (layer <= labelDummyInfo.rightmostLayerId) {
            if (labelDummyWidth <= this.layerWidths[layer]) {
                return layer;
            }
            double potentialWidth = this.layerWidths[layer];
            LabelDummyInfo largestUnassignedLabel = null;
            int label = labelIndex + 1;
            while (label < labelCount) {
                LabelDummyInfo currLabelInfo = labelDummyInfos.get(label);
                if (currLabelInfo.leftmostLayerId <= layer && currLabelInfo.rightmostLayerId >= layer) {
                    largestUnassignedLabel = currLabelInfo;
                }
                ++label;
            }
            if (largestUnassignedLabel != null) {
                potentialWidth = Math.max(potentialWidth, largestUnassignedLabel.labelDummy.getSize().x);
            }
            if (potentialWidth > widestLayerWidth) {
                widestLayerIndex = layer;
                widestLayerWidth = potentialWidth;
            }
            ++layer;
        }
        return widestLayerIndex;
    }

    private void assignLayer(LabelDummyInfo labelDummyInfo, int targetLayerIndex) {
        assert (targetLayerIndex < labelDummyInfo.labelDummy.getGraph().getLayers().size());
        if (targetLayerIndex != labelDummyInfo.leftmostLayerId + labelDummyInfo.leftLongEdgeDummies.size()) {
            this.swapNodes(labelDummyInfo.labelDummy, labelDummyInfo.ithDummyNode(targetLayerIndex - labelDummyInfo.leftmostLayerId));
        }
        int newLayerId = labelDummyInfo.labelDummy.getLayer().id;
        this.layerWidths[newLayerId] = Math.max(this.layerWidths[newLayerId], labelDummyInfo.labelDummy.getSize().x);
        for (LLabel label : (List)labelDummyInfo.labelDummy.getProperty(InternalProperties.REPRESENTED_LABELS)) {
            label.setProperty(INCLUDE_LABEL, true);
        }
    }

    private void swapNodes(LNode labelDummy, LNode longEdgeDummy) {
        LEdge edge;
        Layer layer1 = labelDummy.getLayer();
        Layer layer2 = longEdgeDummy.getLayer();
        int dummy1LayerPosition = layer1.getNodes().indexOf((Object)labelDummy);
        int dummy2LayerPosition = layer2.getNodes().indexOf((Object)longEdgeDummy);
        LPort inputPort1 = labelDummy.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort1 = labelDummy.getPorts(PortType.OUTPUT).iterator().next();
        LPort inputPort2 = longEdgeDummy.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort2 = longEdgeDummy.getPorts(PortType.OUTPUT).iterator().next();
        LEdge[] incomingEdges1 = LGraphUtil.toEdgeArray(inputPort1.getIncomingEdges());
        LEdge[] outgoingEdges1 = LGraphUtil.toEdgeArray(outputPort1.getOutgoingEdges());
        LEdge[] incomingEdges2 = LGraphUtil.toEdgeArray(inputPort2.getIncomingEdges());
        LEdge[] outgoingEdges2 = LGraphUtil.toEdgeArray(outputPort2.getOutgoingEdges());
        labelDummy.setLayer(dummy2LayerPosition, layer2);
        LEdge[] lEdgeArray = incomingEdges2;
        int n = incomingEdges2.length;
        int n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort1);
            ++n2;
        }
        lEdgeArray = outgoingEdges2;
        n = outgoingEdges2.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort1);
            ++n2;
        }
        longEdgeDummy.setLayer(dummy1LayerPosition, layer1);
        lEdgeArray = incomingEdges1;
        n = incomingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort2);
            ++n2;
        }
        lEdgeArray = outgoingEdges1;
        n = outgoingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort2);
            ++n2;
        }
    }

    private void updateLongEdgeSourceLabelDummyInfo(LabelDummyInfo labelDummyInfo) {
        this.doUpdateLongEdgeLabelDummyInfo(labelDummyInfo.labelDummy, node -> node.getIncomingEdges().iterator().next().getSource().getNode(), true);
    }

    private void doUpdateLongEdgeLabelDummyInfo(LNode labelDummy, Function<LNode, LNode> nextElement, boolean value) {
        LNode longEdgeDummy = nextElement.apply(labelDummy);
        while (longEdgeDummy.getType() == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY, value);
            longEdgeDummy = nextElement.apply(longEdgeDummy);
        }
    }

    private static final class LabelDummyInfo {
        private LNode labelDummy;
        private CenterEdgeLabelPlacementStrategy placementStrategy = null;
        private List<LNode> leftLongEdgeDummies = new ArrayList<LNode>();
        private List<LNode> rightLongEdgeDummies = new ArrayList<LNode>();
        private int leftmostLayerId;
        private int rightmostLayerId;

        private LabelDummyInfo(LNode labelDummy, CenterEdgeLabelPlacementStrategy defaultPlacementStrategy) {
            this.labelDummy = labelDummy;
            this.placementStrategy = defaultPlacementStrategy;
            this.gatherLeftLongEdgeDummies();
            this.gatherRightLongEdgeDummies();
            this.leftmostLayerId = this.leftLongEdgeDummies.isEmpty() ? labelDummy.getLayer().id : this.leftLongEdgeDummies.get((int)0).getLayer().id;
            this.rightmostLayerId = this.rightLongEdgeDummies.isEmpty() ? labelDummy.getLayer().id : this.rightLongEdgeDummies.get((int)(this.rightLongEdgeDummies.size() - 1)).getLayer().id;
            for (LLabel label : (List)labelDummy.getProperty(InternalProperties.REPRESENTED_LABELS)) {
                if (!label.hasProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY)) continue;
                this.placementStrategy = (CenterEdgeLabelPlacementStrategy)((Object)label.getProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY));
                break;
            }
        }

        private void gatherLeftLongEdgeDummies() {
            LNode source = this.labelDummy;
            do {
                if ((source = source.getIncomingEdges().iterator().next().getSource().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                this.leftLongEdgeDummies.add(source);
            } while (source.getType() == LNode.NodeType.LONG_EDGE);
            this.leftLongEdgeDummies = Lists.reverse(this.leftLongEdgeDummies);
        }

        private void gatherRightLongEdgeDummies() {
            LNode target = this.labelDummy;
            do {
                if ((target = target.getOutgoingEdges().iterator().next().getTarget().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                this.rightLongEdgeDummies.add(target);
            } while (target.getType() == LNode.NodeType.LONG_EDGE);
        }

        public int totalDummyCount() {
            return this.rightmostLayerId - this.leftmostLayerId + 1;
        }

        private LNode ithDummyNode(int i) {
            if (i < this.leftLongEdgeDummies.size()) {
                return this.leftLongEdgeDummies.get(i);
            }
            if (i == this.leftLongEdgeDummies.size()) {
                return this.labelDummy;
            }
            return this.rightLongEdgeDummies.get(i - this.leftLongEdgeDummies.size() - 1);
        }
    }
}

