/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval;

import java.io.Closeable;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.DefaultEvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThread;

public class EvaluatorThreadPoolExecutor
extends ThreadPoolExecutor {
    private final String name;
    private final AtomicReference<EvaluatorDebugger> debugger = new AtomicReference<DefaultEvaluatorDebugger>(DefaultEvaluatorDebugger.INSTANCE);
    private final Set<EvaluatorMonitor> monitorSet = ConcurrentHashMap.newKeySet();
    private final Map<String, Object> context = new ConcurrentHashMap<String, Object>();
    private final Map<String, Closeable> sharedResources = new ConcurrentHashMap<String, Closeable>();
    private Clock clock = AbstractEvaluator.MonotonicClock.UTC;

    public EvaluatorThreadPoolExecutor(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public EvaluatorThreadPoolExecutor(String name, int maximumPoolSize) {
        super(0, maximumPoolSize, 0L, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>());
        this.name = name;
        this.setThreadFactory(this.createThreadFactory());
    }

    public synchronized void attachDebugger(EvaluatorDebugger debugger) throws IllegalStateException {
        if (!this.debugger.compareAndSet(DefaultEvaluatorDebugger.INSTANCE, debugger)) {
            throw new IllegalStateException("A debugger is currently attached");
        }
    }

    public synchronized void detachDebugger(EvaluatorDebugger debugger) throws IllegalStateException {
        if (!this.debugger.compareAndSet(debugger, DefaultEvaluatorDebugger.INSTANCE)) {
            throw new IllegalStateException("Another debugger is currently attached");
        }
    }

    public EvaluatorDebugger getDebugger() {
        return this.debugger.get();
    }

    public void addMonitor(EvaluatorMonitor monitor) {
        this.monitorSet.add(monitor);
    }

    public void removeMonitor(EvaluatorMonitor monitor) {
        this.monitorSet.remove(monitor);
    }

    public Set<EvaluatorMonitor> getMonitorSet() {
        return this.monitorSet;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Map<String, Closeable> getSharedResources() {
        return this.sharedResources;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        this.debugger.get().beforeExecute(thread, runnable, this);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        this.debugger.get().afterExecute(Thread.currentThread(), runnable, throwable, this);
    }

    @Override
    protected void terminated() {
        this.sharedResources.forEach((key, value) -> {
            try {
                value.close();
            }
            catch (Exception e) {
                this.monitorSet.forEach(monitor -> monitor.error("Exception closing shared resource " + key, e));
            }
        });
        this.debugger.get().terminated(this);
        this.monitorSet.forEach(monitor -> monitor.terminated(this));
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) throws IllegalArgumentException {
        if (!(threadFactory instanceof EvaluatorThreadFactory)) {
            throw new IllegalArgumentException("Must use an EvaluatorThreadFactory");
        }
        super.setThreadFactory(threadFactory);
    }

    protected EvaluatorThreadFactory createThreadFactory() {
        return new EvaluatorThreadFactory();
    }

    protected class EvaluatorThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber;

        protected EvaluatorThreadFactory() {
            this.group = new ThreadGroup(EvaluatorThreadPoolExecutor.this.name);
            this.threadNumber = new AtomicInteger(1);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new EvaluatorThread(this.group, runnable, EvaluatorThreadPoolExecutor.this.name + "-" + this.threadNumber.getAndIncrement(), EvaluatorThreadPoolExecutor.this);
        }
    }
}

