---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# GitLab CI/CD artifacts reports types

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

Use [`artifacts:reports`](index.md#artifactsreports) to:

- Collect test reports, code quality reports, security reports, and other artifacts generated by included templates in
  jobs.
- Some of these reports are used to display information in:
  - Merge requests.
  - Pipeline views.
  - [Security dashboards](../../user/application_security/security_dashboard/index.md).

Artifacts created for `artifacts: reports` are always uploaded, regardless of the job results (success or failure).
You can use [`artifacts:expire_in`](index.md#artifactsexpire_in) to set an expiration
time for the artifacts, which overrides the instance's [default setting](../../administration/settings/continuous_integration.md#maximum-artifacts-size).
GitLab.com might have a [different default artifacts expiry value](../../user/gitlab_com/index.md#gitlab-cicd).

Some `artifacts:reports` types can be generated by multiple jobs in the same pipeline, and used by merge request or
pipeline features from each job.

To browse the report output files, ensure you include the [`artifacts:paths`](index.md#artifactspaths) keyword in your job definition.

NOTE:
Combined reports in parent pipelines using [artifacts from child pipelines](index.md#needspipelinejob) is
not supported. Track progress on adding support in [this issue](https://gitlab.com/gitlab-org/gitlab/-/issues/215725).

## `artifacts:reports:accessibility`

The `accessibility` report uses [pa11y](https://pa11y.org/) to report on the accessibility impact
of changes introduced in merge requests.

GitLab can display the results of one or more reports in the merge request
[accessibility widget](../testing/accessibility_testing.md#accessibility-merge-request-widget).

For more information, see [Accessibility testing](../testing/accessibility_testing.md).

## `artifacts:reports:annotations`

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/38337) in GitLab 16.3.

The `annotations` report is used to attach auxiliary data to a job.

An annotations report is a JSON file with annotation sections. Each annotation
section can have any desired name and can have any number of annotations of the
same or differing types.

Each annotation is a single key (the annotation type), containing the subkeys with
the data for that annotation.

### Annotation types

#### `external_link`

An `external_link` annotation can be attached to a job to add a link to the job
output page. The value of an `external_link` annotation is an object with the
following keys:

| Key     | Description                                        |
|---------|----------------------------------------------------|
| `label` | The human-readable label associated with the link. |
| `url`   | The URL pointed to by the link.                    |

### Example report

The following is an example of what a job annotations report might look like:

```json
{
  "my_annotation_section_1": [
    {
      "external_link": {
        "label": "URL 1",
        "url": "https://url1.example.com/"
      }
    },
    {
      "external_link": {
        "label": "URL 2",
        "url": "https://url2.example.com/"
      }
    }
  ]
}
```

## `artifacts:reports:api_fuzzing`

DETAILS:
**Tier:** Ultimate

The `api_fuzzing` report collects [API Fuzzing bugs](../../user/application_security/api_fuzzing/index.md)
as artifacts.

GitLab can display the results of one or more reports in:

- The merge request [security widget](../../user/application_security/api_fuzzing/configuration/enabling_the_analyzer.md#view-details-of-an-api-fuzzing-vulnerability).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/api_fuzzing/configuration/enabling_the_analyzer.md#security-dashboard).

## `artifacts:reports:browser_performance`

DETAILS:
**Tier:** Premium, Ultimate

The `browser_performance` report collects [Browser Performance Testing metrics](../testing/browser_performance_testing.md)
as an artifact. This artifact is a JSON file output by the [Sitespeed plugin](https://gitlab.com/gitlab-org/gl-performance).

GitLab can display the results of one report in the merge request
[browser performance testing widget](../testing/browser_performance_testing.md#how-browser-performance-testing-works).

GitLab cannot display the combined results of multiple `browser_performance` reports.

## `artifacts:reports:coverage_report`

Use `coverage_report` to collect coverage report in Cobertura format.

The `cobertura` report collects [Cobertura coverage XML files](../testing/test_coverage_visualization.md).

Cobertura was originally developed for Java, but there are many third-party ports for other languages such as
JavaScript, Python, and Ruby.

```yaml
artifacts:
  reports:
    coverage_report:
      coverage_format: cobertura
      path: coverage/cobertura-coverage.xml
```

The collected coverage report is uploaded to GitLab as an artifact. You can use
only one report per job.

GitLab can display the results of coverage report in the merge request
[diff annotations](../testing/test_coverage_visualization.md).

## `artifacts:reports:codequality`

> - Support for multiple reports in diff annotations and full pipeline report [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/9014) in 15.7.

The `codequality` report collects [code quality issues](../testing/code_quality.md). The
collected code quality report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [code quality widget](../testing/code_quality.md#merge-request-widget).
- The merge request [diff annotations](../testing/code_quality.md#merge-request-changes-view).
- The [full report](../testing/metrics_reports.md).

The [`artifacts:expire_in`](../yaml/index.md#artifactsexpire_in) value is set to `1 week`.

## `artifacts:reports:container_scanning`

DETAILS:
**Tier:** Ultimate

The `container_scanning` report collects [Container Scanning vulnerabilities](../../user/application_security/container_scanning/index.md).
The collected Container Scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [container scanning widget](../../user/application_security/container_scanning/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).

## `artifacts:reports:coverage_fuzzing`

DETAILS:
**Tier:** Ultimate

The `coverage_fuzzing` report collects [coverage fuzzing bugs](../../user/application_security/coverage_fuzzing/index.md).
The collected coverage fuzzing report uploads to GitLab as an artifact.
GitLab can display the results of one or more reports in:

- The merge request [coverage fuzzing widget](../../user/application_security/coverage_fuzzing/index.md#interacting-with-the-vulnerabilities).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:cyclonedx`

DETAILS:
**Tier:** Ultimate

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/360766) in GitLab 15.3

This report is a Software Bill of Materials describing the components of a project
following the [CycloneDX](https://cyclonedx.org/docs/1.4) protocol format.

You can specify multiple CycloneDX reports per job. These can be either supplied
as a list of filenames, a filename pattern, or both:

- A filename pattern (`cyclonedx: gl-sbom-*.json`, `junit: test-results/**/*.json`).
- An array of filenames (`cyclonedx: [gl-sbom-npm-npm.cdx.json, gl-sbom-bundler-gem.cdx.json]`).
- A combination of both (`cyclonedx: [gl-sbom-*.json, my-cyclonedx.json]`).
- Directories are not supported(`cyclonedx: test-results`, `cyclonedx: test-results/**`).

Below is an example of a job exposing CycloneDX artifacts:

```yaml
artifacts:
  reports:
    cyclonedx:
      - gl-sbom-npm-npm.cdx.json
      - gl-sbom-bundler-gem.cdx.json
```

## `artifacts:reports:dast`

DETAILS:
**Tier:** Ultimate

The `dast` report collects [DAST vulnerabilities](../../user/application_security/dast/index.md). The collected DAST
report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request security widget.
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:dependency_scanning`

DETAILS:
**Tier:** Ultimate

The `dependency_scanning` report collects [Dependency Scanning vulnerabilities](../../user/application_security/dependency_scanning/index.md).
The collected Dependency Scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [dependency scanning widget](../../user/application_security/dependency_scanning/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [dependency list](../../user/application_security/dependency_list/index.md).

## `artifacts:reports:dotenv`

The `dotenv` report collects a set of environment variables as artifacts.

The collected variables are registered as runtime-created variables of the job,
which you can [use in subsequent job scripts](../variables/index.md#pass-an-environment-variable-to-another-job)
or to [set dynamic environment URLs after a job finishes](../environments/index.md#set-a-dynamic-environment-url).

If duplicate environment variables are present in a `dotenv` report, the last one specified is used.

You should avoid storing sensitive data like credentials in dotenv reports, as the
reports can be downloaded from the pipeline details page. If necessary, you can use
[artifacts:access](index.md#artifactsaccess) to restrict the users that can download
the report artifacts in a job.

The exceptions to the [original dotenv rules](https://github.com/motdotla/dotenv#rules) are:

- The variable key can contain only letters, digits, and underscores (`_`).
- The maximum size of the `.env` file is 5 KB.
  This limit [can be changed on self-managed instances](../../administration/instance_limits.md#limit-dotenv-file-size).
- On GitLab.com, [the maximum number of inherited variables](../../user/gitlab_com/index.md#gitlab-cicd)
  is 50 for Free, 100 for Premium and 150 for Ultimate. The default for
  self-managed instances is 150, and can be changed by changing the
  `dotenv_variables` [application limit](../../administration/instance_limits.md#limit-dotenv-variables).
- Variable substitution in the `.env` file is not supported.
- [Multiline values in the `.env` file](https://github.com/motdotla/dotenv#multiline-values) are not supported.
- The `.env` file can't have empty lines or comments (starting with `#`).
- Key values in the `env` file cannot have spaces or newline characters (`\n`), including when using single or double quotes.
- Quote escaping during parsing (`key = 'value'` -> `{key: "value"}`) is not supported.
- Only UTF-8 encoding is [supported](../jobs/job_artifacts_troubleshooting.md#error-message-fatal-invalid-argument-when-uploading-a-dotenv-artifact-on-a-windows-runner).

## `artifacts:reports:junit`

The `junit` report collects [JUnit report format XML files](https://www.ibm.com/docs/en/developer-for-zos/16.0?topic=formats-junit-xml-format).
The collected Unit test reports upload to GitLab as an artifact. Although JUnit was originally developed in Java, there
are many third-party ports for other languages such as JavaScript, Python, and Ruby.

See [Unit test reports](../testing/unit_test_reports.md) for more details and examples.
Below is an example of collecting a JUnit report format XML file from Ruby's RSpec test tool:

```yaml
rspec:
  stage: test
  script:
    - bundle install
    - rspec --format RspecJunitFormatter --out rspec.xml
  artifacts:
    reports:
      junit: rspec.xml
```

GitLab can display the results of one or more reports in:

- The merge request [code quality widget](../testing/unit_test_reports.md#how-it-works).
- The [full report](../testing/unit_test_reports.md#view-unit-test-reports-on-gitlab).

Some JUnit tools export to multiple XML files. You can specify multiple test report paths in a single job to
concatenate them into a single file. Use either:

- A filename pattern (`junit: rspec-*.xml`, `junit: test-results/**/*.xml`).
- An array of filenames (`junit: [rspec-1.xml, rspec-2.xml, rspec-3.xml]`).
- A combination of both (`junit: [rspec.xml, test-results/TEST-*.xml]`).
- Directories are not supported(`junit: test-results`, `junit: test-results/**`).

## `artifacts:reports:load_performance`

DETAILS:
**Tier:** Premium, Ultimate

The `load_performance` report collects [Load Performance Testing metrics](../testing/load_performance_testing.md).
The report is uploaded to GitLab as an artifact.

GitLab can display the results of only one report in the merge request
[load testing widget](../testing/load_performance_testing.md#how-load-performance-testing-works).

GitLab cannot display the combined results of multiple `load_performance` reports.

## `artifacts:reports:metrics`

DETAILS:
**Tier:** Premium, Ultimate

The `metrics` report collects [Metrics](../testing/metrics_reports.md). The collected Metrics report uploads to GitLab as an
artifact.

GitLab can display the results of one or more reports in the merge request
[metrics reports widget](../testing/metrics_reports.md#metrics-reports).

## `artifacts:reports:requirements`

DETAILS:
**Tier:** Ultimate

The `requirements` report collects `requirements.json` files. The collected Requirements report uploads to GitLab as an
artifact and existing [requirements](../../user/project/requirements/index.md) are marked as Satisfied.

GitLab can display the results of one or more reports in the
[project requirements](../../user/project/requirements/index.md#view-a-requirement).

## `artifacts:reports:repository_xray`

DETAILS:
**Tier:** Ultimate

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/432235) in GitLab 16.7.

The `repository_xray` report collects information about your repository for use by AI in code suggestions.

## `artifacts:reports:sast`

The `sast` report collects [SAST vulnerabilities](../../user/application_security/sast/index.md).
The collected SAST report uploads to GitLab as an artifact.

For more information, see:

- [View SAST results](../../user/application_security/sast/index.md#view-sast-results)
- [SAST output](../../user/application_security/sast/index.md#output)

## `artifacts:reports:secret_detection`

The `secret-detection` report collects [detected secrets](../../user/application_security/secret_detection/pipeline/index.md).
The collected Secret Detection report is uploaded to GitLab.

GitLab can display the results of one or more reports in:

- The merge request [secret scanning widget](../../user/application_security/secret_detection/pipeline/index.md).
- The [pipeline security tab](../../user/application_security/index.md#pipeline-security-tab).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:terraform`

The `terraform` report obtains a Terraform `tfplan.json` file. [JQ processing required to remove credentials](../../user/infrastructure/iac/mr_integration.md#configure-terraform-report-artifacts).
The collected Terraform plan report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in the merge request
[Terraform widget](../../user/infrastructure/iac/mr_integration.md#output-terraform-plan-information-into-a-merge-request).

For more information, see [Output `terraform plan` information into a merge request](../../user/infrastructure/iac/mr_integration.md).
