/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedProperties {
    public static final int[] fontSizes = new int[]{8, 10, 12, 14, 18, 24, 36};
    public ArrayList<ChainedProperty> chain = new ArrayList();

    public String getProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            ChainedProperty p = this.chain.get(k);
            HashMap<String, String> prop = p.property;
            String ret = prop.get(key);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean hasProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            ChainedProperty p = this.chain.get(k);
            HashMap<String, String> prop = p.property;
            if (!prop.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public void addToChain(String key, HashMap<String, String> prop) {
        String value = prop.get("size");
        if (value != null) {
            if (value.endsWith("pt")) {
                prop.put("size", value.substring(0, value.length() - 2));
            } else {
                int s = 0;
                if (value.startsWith("+") || value.startsWith("-")) {
                    String old = this.getProperty("basefontsize");
                    if (old == null) {
                        old = "12";
                    }
                    float f = Float.parseFloat(old);
                    int c = (int)f;
                    for (int k = fontSizes.length - 1; k >= 0; --k) {
                        if (c < fontSizes[k]) continue;
                        s = k;
                        break;
                    }
                    int inc = Integer.parseInt(value.startsWith("+") ? value.substring(1) : value);
                    s += inc;
                } else {
                    try {
                        s = Integer.parseInt(value) - 1;
                    }
                    catch (NumberFormatException nfe) {
                        s = 0;
                    }
                }
                if (s < 0) {
                    s = 0;
                } else if (s >= fontSizes.length) {
                    s = fontSizes.length - 1;
                }
                prop.put("size", Integer.toString(fontSizes[s]));
            }
        }
        this.chain.add(new ChainedProperty(key, prop));
    }

    public void removeChain(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            if (!key.equals(this.chain.get((int)k).key)) continue;
            this.chain.remove(k);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChainedProperty {
        final String key;
        final HashMap<String, String> property;

        ChainedProperty(String key, HashMap<String, String> property) {
            this.key = key;
            this.property = property;
        }
    }
}

