#!/usr/local/bin/bash
#
# This script converts an Adobe Font Metric file for a special font to
# TeX font metric, and installs it in a distribution directory. It uses
# afm2tfm.
#
# (c) Sebastian Rahtz June 6th 1994 
#
# Options:
#  -download means that the lines written to psfonts.<family> have "<fontname"
#  -out [dir] specifies where the results are to go
#
# Parameters:
# $1 The font name, eg psyr
#-------------------------------------------------------------
# Provide a usage message to refresh human memories.
if test \( $# -lt 1 \) 
then 
  echo "Usage: [-download] [-out <dir>] font "
   exit 1
fi
#
# where to put the results
#
OUTDIR=.
#
# defaults
#
DOWNLOAD=
while true; do
	case $1 in
	-download)   shift ; DOWNLOAD=y ;;
	-out)        shift ; OUTDIR=$1 ; shift ;;
	-*) echo $0: illegal option - $1 1>&2; shift;;
	 *) break;;
	esac
done
#
# work out the family name and an 8 character abbreviation
#
F=`echo $1 | sed 's/\(...\).*/\1/'`
FF=`grep FamilyName ${1}.afm | sed 's/.*FamilyName //'`
FFF=`echo $FF | tr -d ' ' | sed 's/^ITC//' | tr '[A-Z]' '[a-z]' | sed 's/\(........\).*/\1/'`
OUT=${OUTDIR}/${FFF}
echo "Work on $F / $FF / $FFF -> $OUT"
#
afm2tfm $1
#
# psfonts.map entries
#
X=`grep FontName $1.afm | sed 's/FontName \([A-z0-9\-]*\).*/\1/'`
if test "$DOWNLOAD"x != x
then
   echo $1 $X "<"$1.pfb > ${F}.map
else
   echo $1 $X > ${F}.map
fi
#
# dvips config file
#
echo "p +${F}.map" > config.${F}
#
# fd file
#
echo "% LaTeX2e fd file for $FF font. for PSNFSS " `date +%Y/%m/%d` > U$F.fd
echo '\DeclareFontFamily{U}{'$F'}{}' >> U$F.fd
echo '\DeclareFontShape{U}{'$F'}{m}{n}{<->'$1'}{}' >> U$F.fd
echo '\endinput' >> U$F.fd
# install directories
#
if test ! -d ${OUT}
then
	mkdir ${OUT}
	mkdir ${OUT}/afm
	mkdir ${OUT}/dvips
	mkdir ${OUT}/tex
	mkdir ${OUT}/tfm
fi
cp $1.afm ${OUT}/afm
mv U${F}.fd ${OUT}/tex
mv $1.tfm ${OUT}/tfm
mv config.${F} ${OUT}/dvips
mv ${F}.map ${OUT}/dvips
cat > ${OUT}/README <<ENDOFCAT
This metric file for the ${FF} font was
created on `date` by Sebastian Rahtz
using Tom Rokicki's afm2tfm.
It consists of:
 + tfm file for use by TeX 
 + .fd (font description) file for use with LaTeX2e
 + a file ${F}.map which lists the raw font name and its
    full PostScript names. This can be added to eg the psfonts.map file
    of dvips to ensure that the driver recognizes the names as that
    of a PostScript font
 + a dvips config file config.${F} which can be used to tell dvips
   about the new font if you do not want to change the default psfonts.map
   (usage: dvips -P${F} to tell dvips about the ${FF} font)
ENDOFCAT
