{   UTILS.INC, zie UTILS.PAS en UTILS.DOC
}

procedure FillWord(var Dest; Width,Value : word);
begin
    if CheckSnow and (SEG(Dest)=$B800) then
    inline($C4/$BE/Dest/            {         LES     DI,Dest[BP]       }
           $8B/$8E/Width/           {         MOV     CX,Width[BP]      }
           $8B/$9E/Value/           {         MOV     BX,Value[BP]      }
           $FC/                     {         CLD                       }
           $E3/$16/                 {         JCXZ    READY             }
           $BA/$03DA/               {         MOV     DX,3DAH           }
           $B4/$09/                 { TEST0:  MOV     AH,9              }
           $EC/                     { TEST1:  IN      AL,DX             }
           $D0/$D8/                 {         RCR     AL,1              }
           $72/$FB/                 {         JB      TEST1             }
           $FA/                     {         CLI                       }
           $EC/                     { TEST2:  IN      AL,DX             }
           $22/$C4/                 {         AND     AL,AH             }
           $74/$FB/                 {         JZ      TEST2             }
           $8B/$C3/                 {         MOV     AX,BX             }
           $AB/                     {         STOSW                     }
           $FB/                     {         STI                       }
           $E2/$ED) else            {         LOOP    TEST0             }
                                    { READY:                            }
    inline($C4/$BE/Dest/            {         LES     DI,Dest[BP]       }
           $8B/$8E/Width/           {         MOV     CX,Width[BP]      }
           $8B/$86/Value/           {         MOV     AX,Value[BP]      }
           $FC/                     {         CLD                       }
           $F3/$AB);                {         REP     STOSW             }
end;


function CheckColor(C : byte) : byte;
    var ForeGround,BackGround : byte;
begin
    ForeGround := C mod 16;
    BackGround := C div 16;
    if not (LO(LASTMODE) in [CO40,CO80]) then
    begin
        if ForeGround in [1..7] then ForeGround:=7 else
        if ForeGround in [8..15] then
        begin
            if LCDHighColor<>0 then
                ForeGround:=LCDHighColor mod 16
            else
                ForeGround:=15;
        end;
        if BackGround in [1..7] then BackGround:=7 else
        if BackGround in [8..15] then BackGround:=15;
    end;
    if not HighLight then ForeGround:=ForeGround mod 8;
    if ForeGround=BackGround then
    begin
        if ForeGround>0 then BackGround:=0 else BackGround:=7;
    end;
    CheckColor := BackGround*16+ForeGround;
end;


function GetAdapterType : AdapterTypeDef;
{by Jeff Dunterman}
var Regs : Registers;
    Code : Byte;
begin
    Regs.AH := $1A;  {Attempt to call VGA Identify Adapter Function}
    Regs.AL := $00;  {Must clear AL to 0}
    INTR($10,Regs);
    if Regs.AL=$1A then  {if $1A comes back in AL, we know a PS/2 video BIOS is out there}
    begin
        case Regs.BL of
          $00:     GetAdapterType := None;
          $01:     GetAdapterType := MDA;
          $02:     GetAdapterType := CGA;
          $04:     GetAdapterType := EGAColor;
          $05:     GetAdapterType := EGAMono;
          $08:     GetAdapterType := VGAColor;
          $0A,$0C: GetAdapterType := MCGAColor;
          $0B:     GetAdapterType := MCGAMono;
          else     GetAdapterType := CGA;
        end;
    end else {if it's not PS/2 we have to check for the presence of an EGA BIOS:}
    begin
        Regs.AH := $12;       { Select Alternate Function service }
        Regs.BX := $10;       { BL=$10 means return EGA information }
        INTR($10,Regs);       { Call BIOS VIDEO }
        if Regs.BX<>$10 then  { BX unchanged means EGA is NOT there...}
        begin
            Regs.AH := $12;   { Once we know Alt Function exists... }
            Regs.BL := $10;   { ...we call it again to see if it's... }
            INTR($10,Regs);   { ...EGA color or EGA monochrome. }
            if (Regs.BH=0) then GetAdapterType:=EGAColor
                else GetAdapterType := EGAMono
        end else  { Now we know we have an CGA or MDA; let's see which: }
        begin
            INTR($11,Regs);   { Equipment determination service }
            Code := (Regs.AL AND $30) SHR 4;
            case Code of
              1:   GetAdapterType := CGA;
              2:   GetAdapterType := CGA;
              3:   GetAdapterType := MDA;
              else GetAdapterType := None
            end;
        end
    end;
end;


procedure TEXTMODE(Mode : word);
{deze procedure moet in de body van deze unit worden aangeroepen}
begin
    if not (LO(Mode) in [BW40,CO40,BW80,CO80,MONO]) then Mode:=BW80;
    if Mode<>LASTMODE then CRT.TEXTMODE(Mode);
    if LO(LASTMODE)=MONO then VideoSeg:=$B000 else VideoSeg:=$B800;
    NormalColor    := CheckColor($0F);
    DataColor      := CheckColor($0E);
    DataInputColor := CheckColor($1E);
    ErrorColor     := CheckColor($4F);
    Color := NormalColor;
    {eigenlijk alle windows disposen...,maar denk aan cursoroff terwijl GotoLC(CRT.WHEREY,...) nog volgt!}
    LineOfs := SUCC(LO(CRT.WINDMAX))*2;
    UpperLeftOfs := 0;
    CursorOfs := 0;
    LeftOfs := 0;
    RightOfs := LineOfs-2;
    LowerRightOfs := SUCC(HI(CRT.WINDMAX))*LineOfs-2;
    MaxMaxL := MaxL;
    MaxMaxC := MaxC;
    WINDMIN := 0;
    WINDMAX := CRT.WINDMIN;
end;


function ThisL : byte;
{returns current linenumber in window, replaces Turbo's WHEREY}
begin
    ThisL := SUCC((CursorOfs-UpperLeftOfs) div LineOfs);
end;


function ThisC : byte;
{returns current columnnumber in window, replaces Turbo's WHEREX}
begin
    ThisC := SUCC((CursorOfs-LeftOfs) shr 1);
end;


function WHEREX : byte;
begin
    WHEREX := ThisC;
end;


function WHEREY : byte;
begin
    WHEREY := ThisL;
end;


function MaxL : byte;
begin
    MaxL := SUCC((LowerRightOfs-UpperLeftOfs) div LineOfs);
end;


function MaxC : byte;
begin
    MaxC := SUCC((RightOfs-LeftOfs) shr 1);
end;


procedure GotoLC(L,C : byte);
{moves cursor to line L and column C in window}
begin
    CheckCtrlC;
    if (L=0) or (C=0) then EXIT;
    LeftOfs := UpperLeftOfs+PRED(L)*LineOfs;
    if LeftOfs>LowerRightOfs then LeftOfs:=UpperLeftOfs;
    RightOfs := LeftOfs + (LowerRightOfs-UpperLeftOfs) mod LineOfs;
    CursorOfs := LeftOfs + PRED(C)*2;
    if CursorOfs>RightOfs then CursorOfs:=RightOfs;
end;


procedure GotoC(C : byte);
begin
    if C=0 then EXIT;
    if FileEchoEnabled and (C>ThisC) then WRITE(EchoF,Space:C-ThisC);
    CursorOfs := LeftOfs + PRED(C)*2;
    if CursorOfs>RightOfs then CursorOfs:=RightOfs;
end;


procedure GOTOXY(X,Y : byte);
begin
    GotoLC(Y,X);
end;


procedure TEXTCOLOR(Color : byte);
begin
    TEXTATTR := (TEXTATTR and $F0) + LO(Color);
    if Color>15 then TEXTATTR:=TEXTATTR or $80;
end;


procedure TEXTBACKGROUND(Color : byte);
begin
    TEXTATTR := (TEXTATTR and $8F) or (Color and $07) shl 4;
end;


procedure NORMVIDEO;
begin
    Color := NormalColor;
end;


procedure LOWVIDEO;
begin
    Color := Color and $F7;
end;


procedure HIGHVIDEO;
begin
    Color := Color or $08;
end;


procedure ChangeColorToLC(Color,L,C : byte);
{changes color on screen from upperleftcorner (ThisL,ThisC) to lowerrightcorner (L,C)}
    var Offset,Width,I : integer;
    procedure FillAlternating(var Dest; Num : integer; Value : byte);
    begin
        inline($C4/$BE/Dest/            {         LES     DI,Dest[BP]  }
               $8B/$8E/Num/             {         MOV     CX,Num[BP]   }
               $8A/$86/Value/           {         MOV     AL,Value[BP] }
               $FC/                     {         CLD                  }
               $AA/                     { L1:     STOSB                }
               $47/                     {         INC     DI           }
               $E2/$FC);                {         LOOP    L1           }
    end;
begin
    L := IntMinMax(ThisL,MaxL,L);
    C := IntMinMax(ThisC,MaxC,C);
    Offset := CursorOfs;
    Width := C-ThisC+1;
    for I:=ThisL to L do
    begin
        FillAlternating(MEM[VideoSeg:Offset+1],Width,Color);
        INC(Offset,LineOfs);
    end;
end;


procedure CursorOn;
{used in MyConIn and ExitUtils}
{cursor is always off, except while waiting for keyboardinput}
    var L,C : byte; {absolute cursorposition}
begin
    CursorIsOn := true;
    L := SUCC(CursorOfs div LineOfs);
    C := SUCC((CursorOfs mod LineOfs) shr 1);
    {see p174 of Nortons Programmers Guide:}
    inline($B4/$02/                     {         MOV     AH,2     }
           $B7/$00/                     {         MOV     BH,0     }
           $8A/$B6/L/                   {         MOV     DH,L[BP] }
           $FE/$CE/                     {         DEC     DH       }
           $8A/$96/C/                   {         MOV     DL,C[BP] }
           $FE/$CA/                     {         DEC     DL       }
           $CD/$10);                    {         INT     10H      }
end;


procedure CursorOff;
{used in MyConIn and InitUtils}
{cursor is always off, except while waiting for keyboardinput}
    var L,C : byte;
begin
    CursorIsOn := false;
    L := MaxMaxL+1;     {move cursor off the screen}
    C := 1;
    {see p174 of Nortons Programmers Guide:}
    inline($B4/$02/                     {         MOV     AH,2     }
           $B7/$00/                     {         MOV     BH,0     }
           $8A/$B6/L/                   {         MOV     DH,L[BP] }
           $FE/$CE/                     {         DEC     DH       }
           $8A/$96/C/                   {         MOV     DL,C[BP] }
           $FE/$CA/                     {         DEC     DL       }
           $CD/$10);                    {         INT     10H      }
end;


procedure ScrollUpFromLine(L : byte);
{cursorposition (CursorOfs) not changed}
    var W,Offset : word;
begin
    if LeftOfs+LineOfs-2=RightOfs then  {continuous videomemory}
        MOVE(MEM[VideoSeg:UpperLeftOfs+LineOfs*L],
             MEM[VideoSeg:UpperLeftOfs+LineOfs*PRED(L)],
             LowerRightOfs+2-UpperLeftOfs-L*LineOfs) else
    begin
        Offset := UpperLeftOfs+LineOfs*L;
        W := MaxC*2;
        while Offset<LowerRightOfs do
        begin
            MOVE(MEM[VideoSeg:Offset],MEM[VideoSeg:Offset-LineOfs],W);
            INC(Offset,LineOfs);
        end;
    end;
    FillWord(MEM[VideoSeg:LowerRightOfs-RightOfs+LeftOfs],MaxC,ORD(Space)+Color shl 8);
end;


procedure ScrollDownFromLine(L : byte);
{cursorposition (CursorOfs) not changed}
    var Offset,W : word;
begin
    if LeftOfs+LineOfs-2=RightOfs then  {continuous videomemory}
        MOVE(MEM[VideoSeg:UpperLeftOfs+LineOfs*PRED(L)],
             MEM[VideoSeg:UpperLeftOfs+LineOfs*L],
             LowerRightOfs+2-UpperLeftOfs-L*LineOfs) else
    begin
        Offset := LowerRightOfs-RightOfs+LeftOfs-LineOfs;
        W := MaxC*2;
        while Offset>=UpperLeftOfs+PRED(L)*LineOfs do
        begin
            MOVE(MEM[VideoSeg:Offset],MEM[VideoSeg:Offset+LineOfs],W);
            DEC(Offset,LineOfs);
        end;
    end;
    FillWord(MEM[VideoSeg:UpperLeftOfs+PRED(L)*LineOfs],MaxC,ORD(Space)+Color shl 8);
end;


procedure CLRSCR;
    var Offset : word;
begin
    GotoLC(1,1);    {contains CheckCtrlC}
    if LeftOfs+LineOfs-2=RightOfs then  {continuous videomemory}
        FillWord(MEM[VideoSeg:UpperLeftOfs],
                 SUCC((LowerRightOfs-UpperLeftOfs) div 2),
                 ORD(Space)+Color shl 8) else
    begin
        Offset := UpperLeftOfs;
        repeat
            FillWord(MEM[VideoSeg:Offset],MaxC,ORD(Space)+Color shl 8);
            INC(Offset,LineOfs);
        until Offset>LowerRightOfs;
    end;
end;


procedure CLREOL;
begin
    FillWord(MEM[VideoSeg:CursorOfs],
             SUCC((RightOfs-CursorOfs) div 2),
             ORD(Space)+Color shl 8);
end;


procedure ClrToL(L : byte);
{erases screen from (ThisL,ThisC) to (L,MaxC)}
    var Offset,I : word;
begin
    L := IntMinMax(ThisL,MaxL,L);
    if LeftOfs+LineOfs-2=RightOfs then  {continuous videomemory}
        FillWord(MEM[VideoSeg:CursorOfs],
                 (UpperLeftOfs+L*LineOfs-CursorOfs) div 2,
                 ORD(Space)+Color shl 8) else
    begin
        CLREOL;
        Offset := LeftOfs+LineOfs;
        for I:=ThisL+1 to L do
        begin
            FillWord(MEM[VideoSeg:Offset],MaxC,ORD(Space)+Color shl 8);
            INC(Offset,LineOfs);
        end;
    end;
end;


procedure DELLINE;
begin
    ScrollUpFromLine(ThisL);
end;


procedure INSLINE;
begin
    ScrollDownFromLine(ThisL);
end;


procedure Bell;
begin
    SOUND(800); DELAY(60); NOSOUND;
end;


procedure WriteStrVar(var V);
    var S       : Str255 absolute V;
        LengthS : byte absolute S;
        Count   : byte;
begin
    if LengthS=0 then EXIT;
    Count := IntMinMax(1,SUCC((RightOfs-CursorOfs) div 2),LengthS);
    if FileEchoEnabled then WRITE(EchoF,S); {hier niet beperkt tot schermbreedte! ivm FINAN}
    if CHECKSNOW and (VideoSeg=$B800) then
    inline($55/                     {         PUSH    BP                }
           $8A/$8E/Count/           {         MOV     CL,Count[BP]      }
           $B5/$00/                 {         MOV     CH,0              }
           $8A/$26/Color/           {         MOV     AH,DS:Color       }
           $8E/$06/VideoSeg/        {         MOV     ES,DS:VideoSeg    }
           $8B/$3E/CursorOfs/       {         MOV     DI,DS:CursorOfs   }
           $1E/                     {         PUSH    DS                }
           $C5/$B6/S/               {         LDS     SI,S[BP]          }
           $46/                     {         INC     SI                }
           $FC/                     {         CLD                       }
           $E3/$19/                 {         JCXZ    READY             }
           $BA/$03DA/               {         MOV     DX,3DAH           }
           $B3/$09/                 {         MOV     BL,9              }
           $AC/                     { NEXT:   LODSB                     }
           $8B/$E8/                 {         MOV     BP,AX             }
           $EC/                     { TEST1:  IN      AL,DX             }
           $D0/$D8/                 {         RCR     AL,1              }
           $72/$FB/                 {         JB      TEST1             }
           $FA/                     {         CLI                       }
           $EC/                     { TEST2:  IN      AL,DX             }
           $22/$C3/                 {         AND     AL,BL             }
           $74/$FB/                 {         JZ      TEST2             }
           $8B/$C5/                 {         MOV     AX,BP             }
           $AB/                     {         STOSW                     }
           $FB/                     {         STI                       }
           $E2/$EC/                 {         LOOP    NEXT              }
           $1F/                     { READY:  POP     DS                }
           $5D) else                {         POP     BP                }
    inline($8A/$8E/Count/           {         MOV     CL,Count[BP]      }
           $B5/$00/                 {         MOV     CH,0              }
           $8A/$26/Color/           {         MOV     AH,DS:Color       }
           $8E/$06/VideoSeg/        {         MOV     ES,DS:VideoSeg    }
           $8B/$3E/CursorOfs/       {         MOV     DI,DS:CursorOfs   }
           $1E/                     {         PUSH    DS                }
           $C5/$B6/S/               {         LDS     SI,S[BP]          }
           $46/                     {         INC     SI                }
           $FC/                     {         CLD                       }
           $E3/$04/                 {         JCXZ    READY             }
           $AC/                     { NEXT:   LODSB                     }
           $AB/                     {         STOSW                     }
           $E2/$FC/                 {         LOOP    NEXT              }
           $1F);                    { READY:  POP     DS                }
    INC(CursorOfs,Count*2);
    if CursorOfs>RightOfs then CursorOfs:=RightOfs;
end;


procedure SetLeftMargin(C : byte);
begin
    if (C=0) or (C>MaxC) then C:=1;
    LeftMarginOfs := PRED(C)*2;
end;


procedure WriteNewLine;
begin
    if FileEchoEnabled then
    begin
        WRITELN(EchoF);
        if LeftMarginOfs>0 then WRITE(EchoF,Space:LeftMarginOfs div 2);
    end;
    if ((CursorOfs+LineOfs)>LowerRightOfs) and not NoScroll then ScrollUpFromLine(1) else
    begin
        INC(LeftOfs,LineOfs);
        INC(RightOfs,LineOfs);
    end;
    CursorOfs := LeftOfs+LeftMarginOfs;
end;


procedure WriteInt(I : longint; W : byte);
    var Result : Str32;
begin
    Result := IntToStr(I,W);
    WriteStrVar(Result);
end;


procedure WriteReal(R : real; W,D : shortint);
    var Result : Str32;
begin
    Result := RealToStr(R,W,D);
    WriteStrVar(Result);
end;


{$F+} function CrtInput(var F : TextRec) : integer; {$F-}
    var OrgColor : byte;
begin
    CursorOn;
    GetKey;
    CursorOff;
    if ThisKey=^M then
    begin
        F.BUFPTR^[0] := ^M;
        F.BUFPTR^[1] := ^J;
        F.BUFEND := 2;
        WriteNewLine;
    end else
    begin
        F.BUFPTR^[0]:=ThisKey;
        F.BUFEND := 1;
        OrgColor := Color;
        Color := DataColor;
        WRITE(ThisKey);
        Color := OrgColor;
    end;
    F.BUFPOS := 0;
    CrtInput := 0;
end;


{$F+} function CrtOutput(var F : TextRec) : integer; {$F-}
begin
    if (F.BUFPOS>=2) and (F.BUFPTR^[F.BUFPOS-2]=#13) and (F.BUFPTR^[F.BUFPOS-1]=#10) then
    begin
        F.NAME[79] := CHR((F.BUFPOS-2) and $00FF);   {grote truuk!!!}
        WriteStrVar(F.NAME[79]);
        WriteNewLine; {letop: hierin nog geen CheckCtrlC, eerst BUFPOS:=0}
    end else
    begin
        F.NAME[79] := CHR(F.BUFPOS and $00FF);   {truuk}
        WriteStrVar(F.NAME[79]);
    end;
    F.BUFPOS := 0;
    CrtOutput := 0;
    CheckCtrlC;
end;


{$F+} function CrtIgnore(var F : TextRec) : integer; {$F-}
begin
    CrtIgnore:=0;
end;


{$F+} function CrtOpen(var F : TextRec) : integer; {$F-}
begin
    if F.MODE=FMINPUT then      {RESET}
    begin
         F.INOUTFUNC := @CrtInput;
         F.FLUSHFUNC := @CrtIgnore;
    end else
    begin                       {REWRITE,APPEND}
        F.MODE := FMOUTPUT;
        F.INOUTFUNC := @CrtIgnore;  {used only if buffer is full before end of WRITE-statement}
        F.FLUSHFUNC := @CrtOutput;
    end;
    F.CLOSEFUNC := @CrtIgnore;
    CrtOpen := 0;
end;


procedure ASSIGNCRT(var F : text);
begin
    with TEXTREC(F) do
    begin
        HANDLE := $FFFF;
        MODE := FMCLOSED;
        BUFSIZE := SIZEOF(BUFFER);
        BUFPTR := @BUFFER;
        OPENFUNC := @CrtOpen;
        NAME[0] := #0;
    end;
end;


procedure WriteToWindow(W : WindowPtr);
begin
    CheckCtrlC;
    if ActiveWindow<>nil then
    begin
        Swap(ActiveWindow^.VideoSeg,VideoSeg,16);   {letop!!!, wijzig nooit volgorde variabelen}
        Swap(ActiveWindow^.Color,Color,5);      {sizeof color control area}
    end;
    if W<>nil then
    begin
        Swap(VideoSeg,W^.VideoSeg,16);
        Swap(Color,W^.Color,5);
    end;
    ActiveWindow := W;
    if ((W=nil) or W^.Open) and CursorIsOn then CursorOn { else CursorOff}; {short circuit evaluation}
end;                                                    {^ivm FINAN      ^}


function NewWindow(Title : Str64; SizeL,SizeC,Color : byte) : WindowPtr;
    var W : WindowPtr;
    procedure InitBorder(W : WindowPtr; Title : Str64);
        var OrgWindow             : WindowPtr;
            L,LocalMaxL,LocalMaxC : byte;
    begin
        if W=nil then EXIT;
        OrgWindow := ActiveWindow;
        WriteToWindow(W);
        LocalMaxL := MaxL;
        LocalMaxC := MaxC;
        Title := COPY(Title,1,LocalMaxC-4);
        GotoLC(1,1);
        WRITE(#218,#196,Title,FillStr(#196,LocalMaxC-3-LENGTH(Title)),#191);
        for L:=2 to LocalMaxL-1 do
        begin
            GotoLC(L,1);
            WRITE(#179);
            GotoC(LocalMaxC);
            WRITE(#179);
        end;
        GotoLC(LocalMaxL,1);
        WRITE(#192,FillStr(#196,LocalMaxC-2),#217);
        INC(UpperLeftOfs,LineOfs+2);
        DEC(LowerRightOfs,LineOfs+2);
        CursorOfs := UpperLeftOfs;
        LeftOfs := UpperLeftOfs;
        RightOfs := LeftOfs + (LowerRightOfs-UpperLeftOfs) mod LineOfs;
        WriteToWindow(OrgWindow);
    end;
begin
    SizeL := IntMinMax(1,MaxMaxL,SizeL);
    SizeC := IntMinMax(1,MaxMaxC,SizeC);
    NEW(W); FILLCHAR(W^,SIZEOF(W^),0);
    W^.BufferSize := SizeL*SizeC*2;
    GETMEM(W^.Buffer,W^.BufferSize);
    FillWord(W^.Buffer^,W^.BufferSize div 2,(Color shl 8)+ORD(Space));
    W^.BufferStartOfs := PtrRec(W^.Buffer).Ofs;
    W^.BufferLineOfs := SizeC*2;
    W^.VideoSeg := PtrRec(W^.Buffer).Seg;
    W^.CursorOfs := W^.BufferStartOfs;
    W^.LineOfs := W^.BufferLineOfs;
    W^.UpperLeftOfs := W^.CursorOfs;
    W^.LowerRightOfs := W^.UpperLeftOfs+W^.BufferSize-2;
    W^.LeftOfs := W^.UpperLeftOfs;
    W^.RightOfs := W^.LeftOfs+W^.LineOfs-2;
    W^.MaxMaxL := SizeL;
    W^.MaxMaxC := SizeC;
    W^.Color := Color;
    W^.NormalColor := Color;
    W^.DataColor := DataColor;
    W^.DataInputColor := DataInputColor;
    if Title<>Space then InitBorder(W,Title);
    NewWindow := W;
end;


procedure OpenWindow(W : WindowPtr; AbsL,AbsC : byte);
    var L,BufferOfs,ScreenOfs : word;
        OrgWindow             : WindowPtr;
    function BufferOfsToScreenOfs(BufferOfs : word; W : WindowPtr) : word;
    begin
        DEC(BufferOfs,W^.BufferStartOfs);
        BufferOfsToScreenOfs := W^.ScreenStartOfs
                                + (BufferOfs div W^.BufferLineOfs)*LineOfs
                                + (BufferOfs mod W^.BufferLineOfs);
    end;
begin
    if (W=nil) or W^.Open then EXIT;
    OrgWindow := ActiveWindow;
    WriteToWindow(nil);
    AbsL := IntMinMax(1,MaxMaxL-W^.MaxMaxL+1,AbsL);
    AbsC := IntMinMax(1,MaxMaxC-W^.MaxMaxC+1,AbsC);
    W^.ScreenStartOfs := PRED(AbsL)*LineOfs+PRED(AbsC)*2;
    BufferOfs := W^.BufferStartOfs;
    ScreenOfs := W^.ScreenStartOfs;
    for L:=1 to W^.MaxMaxL do
    begin
        Swap(MEM[VideoSeg:ScreenOfs],MEM[SEG(W^.Buffer^):BufferOfs],W^.BufferLineOfs);
        INC(BufferOfs,W^.BufferLineOfs);
        INC(ScreenOfs,LineOfs);
    end;
    W^.Open := true;
    W^.VideoSeg := VideoSeg;
    W^.CursorOfs := BufferOfsToScreenOfs(W^.CursorOfs,W);
    W^.LineOfs := LineOfs;
    W^.UpperLeftOfs := BufferOfsToScreenOfs(W^.UpperLeftOfs,W);
    W^.LowerRightOfs := BufferOfsToScreenOfs(W^.LowerRightOfs,W);
    W^.LeftOfs := BufferOfsToScreenOfs(W^.LeftOfs,W);
    W^.RightOfs := BufferOfsToScreenOfs(W^.RightOfs,W);
    W^.PrevOpenedWindow := OpenedWindow;
    OpenedWindow := W;
    WriteToWindow(OrgWindow);
end;


procedure CloseWindow(W : WindowPtr);
    var L,BufferOfs,ScreenOfs : word;
        OrgWindow             : WindowPtr;
    function ScreenOfsToBufferOfs(ScreenOfs : word; W : WindowPtr) : word;
    begin
        DEC(ScreenOfs,W^.ScreenStartOfs);
        ScreenOfsToBufferOfs := W^.BufferStartOfs
                                + (ScreenOfs div LineOfs)*W^.BufferLineOfs
                                + (ScreenOfs mod LineOfs);
    end;
begin
    if (W=nil) or not W^.Open then EXIT;
    OrgWindow := ActiveWindow;
    WriteToWindow(nil);
    BufferOfs := W^.BufferStartOfs;
    ScreenOfs := W^.ScreenStartOfs;
    for L:=1 to W^.MaxMaxL do
    begin
        Swap(MEM[VideoSeg:ScreenOfs],MEM[SEG(W^.Buffer^):BufferOfs],W^.BufferLineOfs);
        INC(BufferOfs,W^.BufferLineOfs);
        INC(ScreenOfs,LineOfs);
    end;
    W^.Open := false;
    W^.VideoSeg := PtrRec(W^.Buffer).Seg;
    W^.CursorOfs := ScreenOfsToBufferOfs(W^.CursorOfs,W);
    W^.LineOfs := W^.BufferLineOfs;
    W^.UpperLeftOfs := ScreenOfsToBufferOfs(W^.UpperLeftOfs,W);
    W^.LowerRightOfs := ScreenOfsToBufferOfs(W^.LowerRightOfs,W);
    W^.LeftOfs := ScreenOfsToBufferOfs(W^.LeftOfs,W);
    W^.RightOfs := ScreenOfsToBufferOfs(W^.RightOfs,W);
    OpenedWindow := W^.PrevOpenedWindow;
    W^.PrevOpenedWindow := nil;
    WriteToWindow(OrgWindow);
end;


procedure DisposeWindow(var W : WindowPtr);
begin
    if W=nil then EXIT;
    if W^.Open then CloseWindow(W);
    if W=ActiveWindow then WriteToWindow(nil);
    FREEMEM(W^.Buffer,W^.BufferSize);
    DISPOSE(W);
    W := nil;
end;


procedure QuickOpenWindow(Title : Str64; L1,C1,L2,C2,Color : byte);
    var W : WindowPtr;
begin
    W := NewWindow(Title,L2-L1+1,C2-C1+1,Color);
    W^.PrevQuickWindow := ActiveWindow;
    OpenWindow(W,L1,C1);
    WriteToWindow(W);
end;


procedure QuickCloseWindow;
    var W,PrevW : WindowPtr;
begin
    if ActiveWindow=nil then EXIT;
    W := ActiveWindow;
    PrevW:=W^.PrevQuickWindow;
    CloseWindow(W);
    WriteToWindow(PrevW);
    DisposeWindow(W);
end;


procedure WINDOW(X1,Y1,X2,Y2 : byte);
begin
    QuickCloseWindow;
    QuickOpenWindow(Space,Y1,X1,Y2,X2,Color);
    WINDMIN := PRED(X1) shl 8 + PRED(Y1);
    WINDMAX := PRED(X2) shl 8 + PRED(Y2);
end;


{$IFDEF sdump}

const DumpScreenNr : word = 0;

procedure DumpScreenBin;
    var DumpF     : text;
        FileName  : Str16;
        VideoOfs  : word;
        OrgWindow : WindowPtr;
begin
    if not (ThisTextMode in [MONO,BW80,CO80]) then
    begin
        Error('dump screen','not in normal text mode','');
        EXIT;
    end;
    INC(DumpScreenNr);
    QuickOpenWindow('ctrl-D',10,20,12,61,ErrorColor);
    repeat
        ErrorFound := false;
        WRITE(' dump screen to file: ');
        FileName := InStr(FileSpecCharSet,'DUMP'+IntToStr(DumpScreenNr,0)+'.BIN',16);
        if OpenOutputTextFile(DumpF,FileName) then
        begin
            QuickCloseWindow;
            OrgWindow := ActiveWindow;
            WriteToWindow(nil);
            for VideoOfs:=0 to 3999 do WRITE(DumpF,CHR(MEM[VideoSeg:VideoOfs]));
            CLOSE(DumpF);
            WriteToWindow(OrgWindow);
        end else Error(FileName,'unable to open','try again');
    until not ErrorFound;
end;


procedure DumpScreenASCII;
    var DumpF     : text;
        FileName  : Str16;
        L,C       : byte;
        OrgWindow : WindowPtr;
begin
    if not (ThisTextMode in [MONO,BW80,CO80]) then
    begin
        Error('dump screen','not in normal text mode','');
        EXIT;
    end;
    INC(DumpScreenNr);
    QuickOpenWindow('ctrl-A',10,20,12,61,ErrorColor);
    repeat
        ErrorFound := false;
        WRITE(' dump screen to file: ');
        FileName := InStr(FileSpecCharSet,'DUMP'+IntToStr(DumpScreenNr,0)+'.TXT',16);
        if OpenOutputTextFile(DumpF,FileName) then
        begin
            QuickCloseWindow;
            OrgWindow := ActiveWindow;
            WriteToWindow(nil);
            for L:=1 to MaxL do
            begin
                for C:=1 to MaxC do WRITE(DumpF,CHR(MEM[VideoSeg:(L-1)*MaxC*2+(C-1)*2]));
                WRITELN(DumpF);
            end;
            CLOSE(DumpF);
            WriteToWindow(OrgWindow);
        end else Error(FileName,'unable to open','try again');
    until not ErrorFound;
end;
{$ENDIF}


procedure FlushKeyBoardBuffer;
    var BufferHeadOfs : word absolute $0040:$001A;
        BufferTailOfs : word absolute $0040:$001C;
begin
    BufferHeadOfs := BufferTailOfs;
end;


function KEYPRESSED : boolean;
    var BufferHeadOfs : word absolute $0040:$001A;
        BufferTailOfs : word absolute $0040:$001C;
begin
    CheckCtrlC;   {catch ctrl-S first}
    KEYPRESSED := BufferHeadOfs<>BufferTailOfs;
end;


procedure WaitForKeyPressed;
    var StartTime : real;
begin
    StartTime := Timer(0);
    repeat SmallJob until KEYPRESSED;   {CheckCtrlC is called in KEYPRESSED}
    UserWaitTime := UserWaitTime + Timer(StartTime);
end;


procedure PushKeyCodeIntoKeyboardBuffer(KeyCode : word);
    var BufferHeadOfs : word absolute $0040:$001A;
        BufferTailOfs : word absolute $0040:$001C;
begin
    if (BufferTailOfs+2=BufferHeadOfs) or
       ((BufferTailOfs=$003C) and (BufferHeadOfs=$001E)) then EXIT; {buffer full}
    MEMW[$0040:BufferTailOfs] := KeyCode;
    INC(BufferTailOfs,2);
    if BufferTailOfs>$003C then BufferTailOfs:=$001E;
end;


{ Keyboard input:
{   ThisKeyCode (global var) - last character read
{   NextKeyCode (function)   - character at the head of the type-ahead buffer
{
{ KeyCode is word: LO(KeyCode) = ASCII value of character (=ThisKey)
{                  HI(KeyCode) = scan code
}

function NextKeyCode : word;
{looks ahead in inputbuffer, does not read}
{returns KeyCode of key that will be read next, returns 0 if no key is pressed}
    var BufferHeadOfs : word absolute $0040:$001A;
begin
    if KEYPRESSED then NextKeyCode:=MEMW[$0040:BufferHeadOfs] else NextKeyCode:=0;
end;


procedure GetKey;   {cursor remains off}
    var BufferHeadOfs : word absolute $0040:$001A;
begin
    WaitForKeyPressed;
    ThisKeyCode := MEMW[$0040:BufferHeadOfs];       {global}
    {maak van komma op numerieke NL-toetsenbord van IBM een punt:}
    if ThisKeyCode=$532C then ThisKeyCode:=$342E;
    ThisKey := CHR(LO(ThisKeyCode));                {global}
    BufferHeadOfs := BufferHeadOfs+2;
    if BufferHeadOfs>$003C then BufferHeadOfs:=$001E;
end;


function READKEY : char;
    const SpecialKey : boolean = false;     {static variable}
begin
    if SpecialKey then
    begin
        READKEY := CHR(HI(ThisKeyCode));
        SpecialKey := false;
    end else
    begin
        CursorOn;
        GetKey;
        CursorOff;
        SpecialKey := ThisKey=#0;
        READKEY := ThisKey;
    end;
end;


function InKey(CharSet : CharSetDef) : char;
{read character (if in CharSet) without echo}
begin
    CursorOn;
    repeat
        GetKey;
        if not (ThisKey in CharSet) then
        begin
            if UPCASE(ThisKey) in CharSet then ThisKey:=UPCASE(ThisKey) else Bell;
        end;
    until ThisKey in CharSet;
    CursorOff;
    InKey := ThisKey;
end;


function InChar(CharSet : CharSetDef) : char;
{read character with echo}
    var OrgColor : byte;
begin
    OrgColor := Color;
    Color := DataColor;
    WRITE(InKey(CharSet));
    Color := OrgColor;
    InChar := ThisKey;
end;


function InStr(CharSet : CharSetDef; DefaultStr : Str80; W : integer) : Str80;
    var S           : Str80;
        Length      : byte absolute S;
        OrgColor,
        P,L,C       : byte;
        FirstStrike,
        Stop,
        CursorAtEnd : boolean;
begin
    OrgColor := Color;
    S := DefaultStr;
    L:=ThisL; C:=ThisC;
    CursorAtEnd := W<0;
    W := ABS(W);
    if W=0 then W:=MaxC;
    W := IntMinMax(1,MaxC-C+1,W);
    if Length>W then Length:=W;
    for P:=1 to Length do if not (S[P] in CharSet) then
    begin
        if UPCASE(S[P]) in CharSet then S[P]:=UPCASE(S[P]) else S[P]:=Space;
    end;
    Color := DataInputColor;
    if CursorAtEnd then
    begin
        if Length<W then P:=Length+1 else P:=Length;
    end else P:=1;
    Stop := false;
    FirstStrike := true;
    repeat
        WRITE(FillRight(S,W));
        GotoLC(L,C+P-1);
        CursorOn;
        GetKey;
        CursorOff;
        case integer(ThisKeyCode) of
{BkSp}      $0E08:          if P>1 then
                            begin
                                DEC(P);
                                if P=Length then Length:=P-1 else S[P]:=Space;
                            end else Bell;
{Ins}       $5200,$52E0:    begin
                                DELETE(S,W,1);
                                INSERT(Space,S,P);
                            end;
{Del}       $5300,$53E0:    DELETE(S,P,1);
{Left}      $4B00,$4BE0:    if P>1 then DEC(P) else Bell;
{Right}     $4D00,$4DE0:    if P<W then INC(P) else Bell;
{Home}      $4700,$47E0:    if P>1 then P:=1 else Stop:=MultipleInput;
{End}       $4F00,$4FE0:    if (P<>(Length+1)) and (Length<W) then P:=Length+1 else
                            if (P<Length) and (Length=W) then P:=Length else
                            Stop:=MultipleInput;
{Enter}     $1C0D,-8179:    Stop:=true;
{Up}        $4800,$48E0,
{Down}      $5000,$50E0:    if MultipleInput then Stop:=true else Bell;
{Escape}    $011B:          begin
                                S := DefaultStr;
                                P := 1;
                                Stop := MultipleInput;
                            end;
            else            if ([ThisKey,UPCASE(ThisKey)]*CharSet<>[]) or (ThisKey=Space) then
                            begin
                                if FirstStrike and not CursorAtEnd then Length:=1;
                                while P>Length do S:=S+Space;
                                S[P] := ThisKey;
                                if not (ThisKey in CharSet) then S[P]:=UPCASE(S[P]);
                                if P<W then INC(P);
                            end else Bell;
        end;
        FirstStrike := false;
        if Stop and not (Space in CharSet) then
        begin
            StripVar(S);
            P := POS(Space,S);
            if P>0 then
            begin
                Error(S,FillStr(Space,P-1)+'^ spaces not allowed','');
                Stop := false;
            end;
        end;
        GotoLC(L,C);
    until Stop;
    Color := OrgColor;
    Color := DataColor;
    WRITELN(FillRight(S,W));
    Color := OrgColor;
    InStr := S;
end;


function InReal(Min,Max,R : real; W : byte; Dec : shortint) : real;
    var Stop            : boolean;
        S               : Str32;
        OrgColor,L,C,WW : byte;
begin
    OrgColor := Color;
    if W=0 then WW:=12 else WW:=W;
    if Dec>(W-2) then Dec:=-1;
    if Min=RealNA then Min:=-MaxReal;
    if Max=RealNA then Max:=MaxReal;
    if R<>RealNA then begin if R<Min then R:=Min else if R>Max then R:=Max end;
    L:=ThisL; C:=ThisC;
    if not NoScroll and (L=MaxL) then L:=L-1;  {scroll in InStr}
    Stop := false;
    repeat
        S := InStr(['0'..'9','.',','{,'E'},'-'],RealToStr(R,0,Dec),WW);
        R := StrToReal(S);      { ^ komma is toegestaan i.p.v. punt, zie StrToReal}
        if R=RealNA then Stop:=true else
        if R=RealER then Error(S,'not a correct number','') else
        if R<Min then Error(S,'is less than ',RealToStr(Min,0,Dec)) else
        if R>Max then Error(S,'is greater than ',RealToStr(Max,0,Dec)) else
        if (LENGTH(RealToStr(R,0,Dec))>W) and (W>0) then Error(S,'number too long','') else
            Stop:=true;
        GotoLC(L,C);
    until Stop;
    Color := DataColor;
    WriteReal(R,W,Dec);
    WRITELN;
    Color := OrgColor;
    InReal := R;
end;


function InInt(Min,Max,I : longint; W : byte) : longint;
begin
    InInt := RealToInt(InReal(IntToReal(Min),IntToReal(Max),IntToReal(I),W,0));
end;


function InChoice(ChoiceStr : Str255; DefaultChoice : byte) : byte;
    const Delimiter = '|';
    var Choice,I,MaxChoice,OrgColor,LastC,L,C : byte;
        Stop                                  : boolean;
begin
    OrgColor := Color;
    L:=ThisL; C:=ThisC;
    LastC := C;
    MaxChoice := CountChar(Delimiter,ChoiceStr)+1;
    Choice := IntMinMax(1,MaxChoice,DefaultChoice);
    Stop := false;
    repeat
        Color := DataInputColor;
        WRITE(StrField(Delimiter,ChoiceStr,Choice));
        Color := OrgColor;
        CLREOL;
        LastC := ThisC;
        GotoLC(L,C);
        CursorOn;
        GetKey;
        CursorOff;
        case integer(ThisKeyCode) of
{Left}      $4B00,$4BE0:    if Choice>1 then DEC(Choice) else Choice:=MaxChoice;
{Home}      $4700,$47E0:    if Choice>1 then Choice:=1 else Stop:=MultipleInput;
{End}       $4F00,$4FE0:    if Choice<MaxChoice then Choice:=MaxChoice else Stop:=MultipleInput;
{Up}        $4800,$48E0,
{Down}      $5000,$50E0:    if MultipleInput then Stop:=true else Bell;
{Enter}     $1C0D,-8179:    Stop := true;
{Escape}    $011B:          begin
                                Choice := DefaultChoice;
                                Stop := MultipleInput;
                            end;
            else            begin
                                I := 0;
                                repeat
                                    INC(I);
                                    Stop := UPCASE(ThisKey)
                                            =UPCASE(StrToChar(StrField(Delimiter,ChoiceStr,I)));
                                until (I=MaxChoice) or Stop;
                                if Stop then Choice:=I else
                                if Choice<MaxChoice then INC(Choice) else Choice:=1;
                            end;
        end;
    until Stop;
    Color := DataColor;
    WRITE(StrField(Delimiter,ChoiceStr,Choice));
    Color := OrgColor;
    CLREOL;
    WRITELN;
    InChoice := Choice;
end;


procedure NewGet(var V; GetType : GetTypeDef; W,Dec : shortint;
                 Min,Max : real; CharSet : CharSetDef; ChoiceStr : Str255);
    var G : RefGet;
begin
    NEW(G);
    FILLCHAR(G^,SIZEOF(G^),0);
    G^.VarPtr := @V;
    G^.GetType := GetType;
    G^.W := W;
    G^.Dec := Dec;
    G^.Min := Min;
    G^.Max := Max;
    G^.CharSet := CharSet;
    GETMEM(G^.ChoiceStrPtr,LENGTH(ChoiceStr)+1);
    G^.ChoiceStrPtr^ := ChoiceStr;
    G^.L := ThisL;
    G^.C := ThisC;
    if LastGet<>nil then LastGet^.Suc:=G else FirstGet:=G;
    G^.Pred := LastGet;
    LastGet := G;
end;


procedure GetStr(var S; CharSet : CharSetDef; W : byte);
    var EditStr  : Str80 absolute S;     {so no typechecking is made}
        OrgColor : byte;
begin
    OrgColor := Color;
    if W=0 then W:=MaxC;
    W := IntMinMax(1,MaxC-ThisC+1,W);
    NewGet(S,StrGet,W,0,0,0,CharSet,'');
    Color := DataColor;
    WRITE(FillRight(EditStr,W));
    Color := OrgColor;
end;


procedure GetReal(var R : real; Min,Max : real; W : byte; Dec : shortint);
    var OrgColor : byte;
begin
    OrgColor := Color;
    if W=0 then W:=12;
    W := IntMinMax(1,MaxC-ThisC+1,W);
    if Dec>(W-2) then Dec:=-1;
    NewGet(R,RealGet,W,Dec,Min,Max,[],'');
    Color := DataColor;
    WriteReal(R,W,Dec);
    Color := OrgColor;
end;


procedure GetInt(var I : longint; Min,Max : longint; W : byte);
    var OrgColor : byte;
begin
    OrgColor := Color;
    if W=0 then W:=12;
    W := IntMinMax(1,MaxC-ThisC+1,W);
    NewGet(I,IntGet,W,0,Min,Max,[],'');
    Color := DataColor;
    WriteInt(I,W);
    Color := OrgColor;
end;


procedure GetChoice(var B : byte; ChoiceStr : Str255);
    const Delimiter = '|';
    var OrgColor : byte;
begin
    OrgColor := Color;
    if B>(CountChar(Delimiter,ChoiceStr)+1) then B:=1;
    NewGet(B,ChoiceGet,0,0,0,0,[],ChoiceStr);
    Color := DataColor;
    WRITE(StrField(Delimiter,ChoiceStr,B));
    Color := OrgColor;
end;


procedure GetNow;
    type RefB = ^byte;
         RefI = ^longint;
         RefS = ^Str80;
         RefR = ^real;
    var G    : RefGet;
        Stop : boolean;

    procedure DisposeGets;
        var ThisG,NextG : RefGet;
    begin
        ThisG := FirstGet;
        while ThisG<>nil do
        begin
            NextG := ThisG^.Suc;
            FREEMEM(ThisG^.ChoiceStrPtr,LENGTH(ThisG^.ChoiceStrPtr^)+1);
            DISPOSE(ThisG);
            ThisG := NextG;
        end;
        FirstGet := nil;
        LastGet := nil;
    end;
begin
    if FirstGet=nil then EXIT;
    G := FirstGet;
    MultipleInput := true;
    Stop := false;
    repeat
        GotoLC(G^.L,G^.C);
        with G^ do case GetType of
            StrGet:     RefS(VarPtr)^:=InStr(CharSet,RefS(VarPtr)^,W);
            IntGet:     RefI(VarPtr)^:=InInt(RealToInt(Min),RealToInt(Max),RefI(VarPtr)^,W);
            RealGet:    RefR(VarPtr)^:=InReal(Min,Max,RefR(VarPtr)^,W,Dec);
            ChoiceGet:  RefB(VarPtr)^:=InChoice(ChoiceStrPtr^,RefB(VarPtr)^);
        end;
        case integer(ThisKeyCode) of
{Up}        $4800,$48E0:    if G^.Pred<>nil then G:=G^.Pred else Bell;
{Down}      $5000,$50E0:    if G^.Suc<>nil then G:=G^.Suc else Bell;
{Home}      $4700,$47E0:    if G<>FirstGet then G:=FirstGet else Bell;
{End}       $4F00,$4FE0:    if G<>LastGet then G:=LastGet else Bell;
{Enter}     $1C0D,-8179:    if G<>LastGet then G:=G^.Suc else Stop:=true;
{Escape}    $011B:          Stop:=true;
            else            Bell;
        end;
    until Stop;
    DisposeGets;
    MultipleInput := false;
end;


function AttrByteToStr(AttrByte : byte) : Str4;
    var AttrStr : Str4;
        P       : byte;
begin
    AttrStr := '';
    for P:=8 downto 1 do
        if (AttrByte and (1 shl (P-1)))<>0 then
            AttrStr := AttrStr + COPY('XYADVSHR',9-P,1);
    AttrByteToStr := AttrStr;
end;


function AttrStrToByte(AttrStr : Str4) : byte;
    var P,PP,AttrByte : byte;
begin
    UpStrVar(AttrStr);
    AttrByte := $00;
    for P:=1 to LENGTH(AttrStr) do
    begin
       PP := POS(AttrStr[P],'XYADVSHR');
       if PP>0 then AttrByte:=AttrByte or (1 shl (8-PP));
    end;
    AttrStrToByte := AttrByte;
end;


function FreeDiskSpace(Drive : char) : longint;
    var Result : longint;
begin
    Result := DISKFREE(ORD(Drive) mod 32);
    if Result=-1 then FreeDiskSpace:=IntER else FreeDiskSpace:=Result;
end;


function TotalDiskSpace(Drive : char) : longint;
    var Result : longint;
begin
    Result := DISKSIZE(ORD(Drive) mod 32);
    if Result=-1 then TotalDiskSpace:=IntER else TotalDiskSpace:=Result;
end;


function ClusterSize(Drive : char) : longint;
    var Reg : Registers;
begin
    Reg.AH := $36;
    Reg.DL := ORD(Drive) mod 32;    {0=default, 1=A, 2=B etc.}
    MSDOS(Reg);
    if Reg.AX<>$FFFF then ClusterSize:=Reg.CX*Reg.AX else ClusterSize:=IntER;
end;


function ThisPath : Str64;
{returns current drive and directory}
    var S : Str64;
begin
    GETDIR(0,S);
    ThisPath := S;
end;


function ChangePath(Path : Str64) : boolean;
{changes default drive and directory, returns true if successful}
begin
    {$I-} CHDIR(Path); {$I+}
    ChangePath := IORESULT=0;
end;


function MakeDir(DirName : Str64) : boolean;
{creates new directory, returns true if successful}
begin
    {$I-} MKDIR(DirName); {$I+}
    MakeDir := IORESULT=0;
end;


function RemoveDir(DirName : Str64) : boolean;
{romoves an empty directory, returns true if successful}
begin
    {$I-} RMDIR(DirName); {$I+}
    RemoveDir := IORESULT=0;
end;


function SizeOfFile(FileSpec : Str64) : longint;
    var FileInfo : RefFileInfo;
begin
    {Gebruik niet FILESIZE (DOS-unit), want dan wordt niet de omvang van een
     subdirectory berekend}
    FileInfo := BuildFileInfoList(FileSpec,'DSH');
    if FileInfo=nil then SizeOfFile:=IntER else SizeOfFile:=FileInfo^.Size;
    DisposeFileInfoList(FileInfo);
end;


function DeleteFile(FileSpec : Str64) : boolean;
{deletes file, returns true if successful}
    var F : file;
begin
    ASSIGN(F,FileSpec);
    {$I-} ERASE(F); {$I+}
    DeleteFile := IORESULT=0;
end;


function RenameFile(OldFileSpec, NewFileSpec : Str64): boolean;
{renames file, returns true if successful}
    var F : file;
begin
    ASSIGN(F,OldFileSpec);
    {$I-} RENAME(F,NewFileSpec); {$I+}
    RenameFile := IORESULT=0;
end;


function ExtractFileName(FileSpec : Str64) : Str12;
begin
    if FileSpec<>'' then
    if POS('\',FileSpec)<>0 then FileSpec:=StrField('\',FileSpec,CountChar('\',FileSpec)+1) else
    if FileSpec[2]=':' then FileSpec:=COPY(FileSpec,3,16);
    ExtractFileName := FileSpec;
end;


function ExtractPath(FileSpec : Str64) : Str64;
    var FileSpecLength : byte absolute FileSpec;
begin
    FileSpec := COPY(FileSpec,1,FileSpecLength-LENGTH(ExtractFileName(FileSpec)));
    if FileSpec[FileSpecLength]='\' then
    if (FileSpecLength<>1) and not ((FileSpecLength=3) and (FileSpec[2]=':')) then
        DELETE(FileSpec,FileSpecLength,1);
    ExtractPath := FileSpec;
end;


function ExtractDrive(FileSpec : Str64) : char;
begin
    if (LENGTH(FileSpec)>=2) and (FileSpec[2]=':') then ExtractDrive:=FileSpec[1] else
        ExtractDrive:='@';
end;


function MakeFileSpec(Path : Str64; FileName : Str12) : Str64;
begin
    if (LENGTH(Path)>0) and not (Path[LENGTH(Path)] in ['\',':']) then
        MakeFileSpec := Path+'\'+FileName
    else MakeFileSpec:=Path+FileName;
end;


function FindPath(FileSpec : Str64) : Str64;
{returns '' if File does not exist, even if a path is specified in FileSpec}
{searches in MS-DOS path (SET PATH=...) if no path is specified in FileSpec}
{wildcards are allowed}
    var Path     : Str64;
        N        : integer;
        Found    : boolean;
    function ExistFileSpec(FileSpecMask : Str80) : boolean;
        var SR : SEARCHREC;
    begin
        FINDFIRST(FileSpecMask,0,SR);
        ExistFileSpec := DOSERROR=0;
    end;
begin
    CheckCtrlC;
    if ExistFileSpec(FileSpec) then
    begin
        Path := ExtractPath(FileSpec);
        if Path='' then FindPath:=ThisPath else FindPath:=Path;
    end else if ExtractPath(FileSpec)<>'' then FindPath:='' else
    begin
        N := 0;
        Found := false;
        repeat
            INC(N);
            Path := StrField(';',GetEnvironmentStr('PATH'),N);
            if Path<>'' then Found:=ExistFileSpec(MakeFileSpec(Path,FileSpec));
        until (Path='') or Found;
        FindPath := Path;
    end;
end;


function ExistFile(FileSpec : Str64) : boolean;
{searches MS-DOS path if no path is included in FileSpec, wildcards allowed}
begin
    ExistFile:=FindPath(FileSpec)<>''
end;


function OpenInputTextFile(var InF : text; FileSpec : Str64) : boolean;
begin
    CheckCtrlC;
    if ExtractPath(FileSpec)='' then FileSpec:=MakeFileSpec(FindPath(FileSpec),FileSpec);
    ASSIGN(InF,FileSpec);
    {$I-} RESET(InF); {$I+}
    OpenInputTextFile := IORESULT=0;
end;


function OpenOutputTextFile(var OutF : text; FileSpec : Str64) : boolean;
begin
    CheckCtrlC;
    UpStrVar(FileSpec);
    if FileSpec='CON' then AssignCrt(OutF) else ASSIGN(OutF,FileSpec);
    {nog printerstatus test inbouwen ingeval FileSpec='PRN'}
    {$I-} REWRITE(OutF); {$I+}
    OpenOutputTextFile := IORESULT=0;
end;


function OpenAppendTextFile(var OutF : text; FileSpec : Str64) : boolean;
{searches MS-DOS path if no path is included in FileSpec}
begin
    CheckCtrlC;
    UpStrVar(FileSpec);
    OpenAppendTextFile := true;
    if FileSpec='CON' then AssignCrt(OutF) else
    if FileSpec='PRN' then OpenAppendTextFile:=OpenOutputTextFile(OutF,'PRN') else
    begin
        ASSIGN(OutF,FileSpec);
        {$I-} APPEND(OutF); {$I+}
        if IORESULT<>0 then OpenAppendTextFile:=OpenOutputTextFile(OutF,FileSpec);
    end;
end;


function EchoToFile(FileSpec : Str64) : boolean;
begin
    {$I-} CLOSE(EchoF); {$I+}
    if IORESULT<>0 then;
    FileEchoEnabled := OpenAppendTextFile(EchoF,FileSpec);
    EchoToFile := FileEchoEnabled;
end;


procedure EndEchoToFile;
begin
    CheckCtrlC;
    {$I-} CLOSE(EchoF); {$I+}
    if IORESULT<>0 then;
    FileEchoEnabled := false;
end;


function SetFileDateTime(FileSpec : Str64; DateTimeInt : longint) : boolean;
    var F : file;
begin
    CheckCtrlC;
    ASSIGN(F,FileSpec);
    {$I-}
    RESET(F);
    {$I+}
    if IORESULT=0 then
    begin
        SETFTIME(F,DateTimeInt);
        SetFileDateTime := DOSERROR=0;
        CLOSE(F);
    end else SetFileDateTime:=false;
end;


function GetFileDateTime(FileSpec : Str64) : longint;
    var F      : file;
        Result : longint;
begin
    CheckCtrlC;
    ASSIGN(F,FileSpec);
    {$I-}
    RESET(F);
    {$I+}
    if IORESULT=0 then
    begin
        GETFTIME(F,Result);
        if DOSERROR=0 then GetFileDateTime:=Result else GetFileDateTime:=IntER;
        CLOSE(F);
    end else GetFileDateTime:=IntER;
end;


function GetFileAttr(FileSpec : Str64) : Str8;      {Str8 vanwege StrER}
    var F      : file;
        Result : word;
begin
    CheckCtrlC;
    ASSIGN(F,FileSpec);
    GETFATTR(F,Result);
    if DOSERROR=0 then GetFileAttr:=AttrByteToStr(Result) else GetFileAttr:=StrER;
end;


function SetFileAttr(FileSpec : Str80; Attr : Str8) : boolean;
    var F : file;
begin
    CheckCtrlC;
    ASSIGN(F,FileSpec);
    SETFATTR(F,AttrStrToByte(Attr));
    SetFileAttr := DOSERROR=0;
end;


function BuildFileInfoList(FileSpecMask : Str80; AttrStr : Str4) : RefFileInfo;
    var FirstFileInfo,FileInfo : RefFileInfo;
        SR                     : SEARCHREC;
        DirOnly                : boolean;

    function NewFileInfo(FileName : Str12; AttrStr : Str4;
                         DateTimeInt,Size : longint) : RefFileInfo;
        var Result : RefFileInfo;
    begin
        CheckCtrlC;
        NEW(Result);
        FILLCHAR(Result^,SIZEOF(Result^),0);
        Result^.FileName := FileName;
        Result^.AttrStr := AttrStr;
        Result^.DateTimeInt := DateTimeInt;
        Result^.Size:=Size;
        NewFileInfo := Result;
    end;

    procedure GetSubDirFilesAndSize(DirInfo : RefFileInfo);
        var FirstFileInfo,FileInfo : RefFileInfo;
            Size,Files             : longint;
    begin
        if POS('D',DirInfo^.AttrStr)=0 then EXIT;
        Files := 0;
        Size := 0;
        {recursie:}
        FirstFileInfo := BuildFileInfoList(MakeFileSpec(ExtractPath(FileSpecMask),DirInfo^.FileName)+'\*.*','DSH');
        FileInfo := FirstFileInfo;
        while FileInfo<>nil do
        begin
            INC(Size,FileInfo^.Size);
            if POS('D',FileInfo^.AttrStr)=0 then INC(Files) else INC(Files,FileInfo^.DateTimeInt);
            FileInfo := FileInfo^.Next;
        end;
        DisposeFileInfoList(FirstFileInfo);
        DirInfo^.Size := Size;
        DirInfo^.DateTimeInt := Files; {dus andere betekenis bij subdirectories}
    end;
begin
    if ExtractFileName(FileSpecMask)='' then FileSpecMask:=MakeFileSpec(FileSpecMask,'*.*');
    DirOnly := POS('d',AttrStr)<>0;  {lower case 'd'}
    FINDFIRST(FileSpecMask,AttrStrToByte(AttrStr),SR);
    while (DOSERROR=0) and (SR.NAME[1]='.') do FINDNEXT(SR);  {skip . and ..}
    while (DOSERROR=0) and DirOnly and (POS('D',AttrByteToStr(SR.ATTR))=0) do FINDNEXT(SR);
    if DOSERROR<>0 then begin BuildFileInfoList:=nil; EXIT end;
    FirstFileInfo := NewFileInfo(SR.NAME,AttrByteToStr(SR.ATTR),SR.TIME,SR.SIZE);
    GetSubDirFilesAndSize(FirstFileInfo); {indien het een subdirectory is}
    FileInfo := FirstFileInfo;
    FINDNEXT(SR);
    while DOSERROR=0 do
    begin
        if not (DirOnly and (POS('D',AttrByteToStr(SR.ATTR))=0)) then
        begin
            FileInfo^.Next := NewFileInfo(SR.NAME,AttrByteToStr(SR.ATTR),SR.TIME,SR.SIZE);
            GetSubDirFilesAndSize(FileInfo^.Next); {indien het een subdirectory is}
            FileInfo := FileInfo^.Next;
        end;
        FINDNEXT(SR);
    end;
    BuildFileInfoList := FirstFileInfo;
end;


{$S+}
procedure SortFileInfoList(var FirstFileInfo : RefFileInfo);
    const MaxN = 1024;  {4K stackspace for List}
    var List     : array[1..MaxN] of RefFileInfo;
        N        : integer;

    procedure QuickSort(L,R : integer);
    {let op, bij aanroep moet L<=R, en L>0}
        var I,J : integer;
            Key : Str12;
    begin
        I := L;
        J := R;
        Key := List[(L+R) div 2]^.FileName;
        repeat
            while List[I]^.FileName<Key do INC(I);
            while Key<List[J]^.FileName do DEC(J);
            if I<=J then
            begin
                Swap(List[I],List[J],SIZEOF(List[1]));
                INC(I);
                DEC(J);
            end;
        until I>J;
        if L<J then QuickSort(L,J);
        if I<R then QuickSort(I,R);
    end;
begin
    if FirstFileInfo=nil then EXIT;
    N := 1;
    List[1] := FirstFileInfo;
    while (List[N]^.Next<>nil) and (N<MaxN) do
    begin
        INC(N);
        List[N] := List[N-1]^.Next;
    end;
    if List[N]^.Next<>nil then Error('list of files too long','','');
    QuickSort(1,N);
    List[N]^.Next := nil;
    while N>1 do
    begin
        List[N-1]^.Next := List[N];
        DEC(N);
    end;
    FirstFileInfo := List[1];
end;
{$S-}


procedure DisposeFileInfoList(var FirstFileInfo : RefFileInfo);
    var FileInfo,NextFileInfo : RefFileInfo;
begin
    FileInfo := FirstFileInfo;
    while FileInfo<>nil do
    begin
        NextFileInfo := FileInfo^.Next;
        DISPOSE(FileInfo);
        FileInfo := NextFileInfo;
    end;
    FirstFileInfo := nil;
end;

