/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.datatool2bib;

import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValue;
import com.dickimawbooks.bibgls.common.BibGlsConverter;
import com.dickimawbooks.bibgls.datatool2bib.DTLgidxSetDefaultDB;
import com.dickimawbooks.bibgls.datatool2bib.DataGidxAtBothOfTwo;
import com.dickimawbooks.bibgls.datatool2bib.DataGidxAtInvert;
import com.dickimawbooks.bibgls.datatool2bib.GidxData;
import com.dickimawbooks.bibgls.datatool2bib.NewAcro;
import com.dickimawbooks.bibgls.datatool2bib.NewGidx;
import com.dickimawbooks.bibgls.datatool2bib.NewTerm;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.AtNumberOfNumber;
import com.dickimawbooks.texparserlib.latex.GobbleOpt;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataGidxSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class DataTool2Bib
extends BibGlsConverter {
    public static final String NAME = "datatool2bib";
    private boolean split = false;
    private String labelColumn = "Label";
    private String fallbackLabelColumn = "Name";
    private boolean autoLabel = false;
    private String autoLabelPrefix = null;
    private String readOpts = null;
    private int autoLabelIdx = 0;
    private String setup = null;
    private String dependencyField = "dependency";
    private String databaseField = null;
    private boolean stripGlsAdd = true;
    private boolean stripAcronymFont = true;
    private boolean stripAcronymText = true;
    private boolean stripAcronymName = true;
    private boolean stripCaseChange = false;
    private boolean adjustGls = true;
    private boolean skipDataGidx = true;
    private boolean detectSymbols = false;
    private String dataValueSuffix = null;
    private String dataCurrencySuffix = null;
    private Locale numericLocale = null;
    private NumberFormat numberFormat = null;
    private DataToolSty datatoolSty;
    private DataGidxSty datagidxSty;
    private HashMap<String, Vector<GidxData>> gidxdata;
    public static final String DATAGIDX_DEFAULT_DATABASE = "l__datagidx_default_database_tl";

    protected void addCustomCommands() {
        this.parser.putControlSequence(new GobbleOpt("DTLwrite", 1, 1, new int[0]));
        this.parser.putControlSequence(new DTLgidxSetDefaultDB());
        this.parser.putControlSequence(new NewGidx(this));
        this.parser.putControlSequence(new NewTerm(this));
        this.parser.putControlSequence(new NewAcro(this));
        this.parser.putControlSequence(new GenericCommand(true, "datagidxwordifygreek", null, TeXParserUtils.createStack(this.listener, new TeXCsRef("def"), new TeXCsRef("alpha"), this.listener.createGroup("alpha"), new TeXCsRef("def"), new TeXCsRef("beta"), this.listener.createGroup("beta"), new TeXCsRef("def"), new TeXCsRef("gamma"), this.listener.createGroup("gamma"), new TeXCsRef("def"), new TeXCsRef("delta"), this.listener.createGroup("delta"), new TeXCsRef("def"), new TeXCsRef("epsilon"), this.listener.createGroup("epsilon"), new TeXCsRef("def"), new TeXCsRef("varepsilon"), this.listener.createGroup("epsilon"), new TeXCsRef("def"), new TeXCsRef("zeta"), this.listener.createGroup("zeta"), new TeXCsRef("def"), new TeXCsRef("eta"), this.listener.createGroup("eta"), new TeXCsRef("def"), new TeXCsRef("theta"), this.listener.createGroup("theta"), new TeXCsRef("def"), new TeXCsRef("vartheta"), this.listener.createGroup("theta"), new TeXCsRef("def"), new TeXCsRef("iota"), this.listener.createGroup("iota"), new TeXCsRef("def"), new TeXCsRef("kappa"), this.listener.createGroup("kappa"), new TeXCsRef("def"), new TeXCsRef("lambda"), this.listener.createGroup("lambda"), new TeXCsRef("def"), new TeXCsRef("mu"), this.listener.createGroup("mu"), new TeXCsRef("def"), new TeXCsRef("nu"), this.listener.createGroup("nu"), new TeXCsRef("def"), new TeXCsRef("xi"), this.listener.createGroup("xi"), new TeXCsRef("def"), new TeXCsRef("pi"), this.listener.createGroup("pi"), new TeXCsRef("def"), new TeXCsRef("varpi"), this.listener.createGroup("pi"), new TeXCsRef("def"), new TeXCsRef("rho"), this.listener.createGroup("rho"), new TeXCsRef("def"), new TeXCsRef("sigma"), this.listener.createGroup("sigma"), new TeXCsRef("def"), new TeXCsRef("varsigma"), this.listener.createGroup("sigma"), new TeXCsRef("def"), new TeXCsRef("tau"), this.listener.createGroup("tau"), new TeXCsRef("def"), new TeXCsRef("upsilon"), this.listener.createGroup("upsilon"), new TeXCsRef("def"), new TeXCsRef("phi"), this.listener.createGroup("phi"), new TeXCsRef("def"), new TeXCsRef("avarphi"), this.listener.createGroup("phi"), new TeXCsRef("def"), new TeXCsRef("chi"), this.listener.createGroup("chi"), new TeXCsRef("def"), new TeXCsRef("psi"), this.listener.createGroup("psi"), new TeXCsRef("def"), new TeXCsRef("omega"), this.listener.createGroup("omega"), new TeXCsRef("def"), new TeXCsRef("Gamma"), this.listener.createGroup("Gamma"), new TeXCsRef("def"), new TeXCsRef("Delta"), this.listener.createGroup("Delta"), new TeXCsRef("def"), new TeXCsRef("Theta"), this.listener.createGroup("Theta"), new TeXCsRef("def"), new TeXCsRef("Lambda"), this.listener.createGroup("Lambda"), new TeXCsRef("def"), new TeXCsRef("Xi"), this.listener.createGroup("Xi"), new TeXCsRef("def"), new TeXCsRef("Pi"), this.listener.createGroup("Pi"), new TeXCsRef("def"), new TeXCsRef("Sigma"), this.listener.createGroup("Sigma"), new TeXCsRef("def"), new TeXCsRef("Upsilon"), this.listener.createGroup("Upsilon"), new TeXCsRef("def"), new TeXCsRef("Phi"), this.listener.createGroup("Phi"), new TeXCsRef("def"), new TeXCsRef("Psi"), this.listener.createGroup("Psi"), new TeXCsRef("def"), new TeXCsRef("Omega"), this.listener.createGroup("Omega"))));
        this.parser.putControlSequence(new TextualContentCommand("DTLgidxCounter", "page"));
        this.parser.putControlSequence(new AtGobble("DTLgidxAddLocationType"));
        this.parser.putControlSequence(new AtGobble("DTLgidxSetCompositor"));
        this.parser.putControlSequence(new AtGobble("DTLgidxGobble"));
        this.parser.putControlSequence(new AtFirstOfOne("DTLgidxNoFormat"));
        this.parser.putControlSequence(new AtGobble("glsadd"));
        this.parser.putControlSequence(new AtGobble("glsaddall"));
        this.parser.putControlSequence(new AtGobble("glsreset"));
        this.parser.putControlSequence(new AtGobble("glsunset"));
        this.parser.putControlSequence(new AtGobble("glsresetall"));
        this.parser.putControlSequence(new AtGobble("glsunsetall"));
        this.parser.putControlSequence(new LaTeXGenericCommand(true, "newtermaddfield", "omomom", new TeXObjectList(), TeXParserUtils.createStack(this.parser, new TeXObjectList(), new TeXObjectList(), new TeXObjectList())));
    }

    @Override
    public boolean isSpecialUsePackage(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        if (string.equals("datatool") || string.equals("datatool-base") || string.equals("datagidx")) {
            if (keyValList != null) {
                for (String string2 : keyValList.keySet()) {
                    TeXObject teXObject = (TeXObject)keyValList.get(string2);
                    this.datatoolSty.processSetupOption(string2, teXObject, teXObjectList);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process() throws IOException, Bib2GlsException {
        Charset charset;
        int n;
        Object object;
        Vector<String> vector;
        this.datatoolSty = (DataToolSty)this.listener.requirepackage("datatool", null);
        this.datagidxSty = (DataGidxSty)this.listener.requirepackage("datagidx", null);
        if (this.dependencyField != null) {
            this.dependencyField = this.processLabel(this.applyFieldCase(this.dependencyField)).trim();
            if (this.dependencyField.isEmpty()) {
                this.dependencyField = null;
            }
        }
        if (this.databaseField != null) {
            this.databaseField = this.processLabel(this.applyFieldCase(this.databaseField)).trim();
            if (this.databaseField.isEmpty()) {
                this.databaseField = null;
            }
        }
        this.addCustomCommands();
        if (this.setup != null && !this.setup.isEmpty()) {
            vector = new TeXReader((TeXApp)this, String.format("\\DTLsetup{%s}", this.setup));
            this.parser.parse((TeXReader)((Object)vector));
        }
        if (this.readOpts == null) {
            this.parser.parse(this.texFile, this.charset);
        } else {
            vector = new TeXPath(this.parser, this.texFile);
            object = new TeXReader((TeXApp)this, String.format("\\DTLread[%s]{%s}", this.readOpts, ((TeXPath)((Object)vector)).getTeXPath(false)));
            this.parser.parse((TeXReader)object);
        }
        vector = null;
        object = this.datatoolSty.getDataBaseNames();
        while (object.hasMoreElements()) {
            String string = object.nextElement();
            if (this.skipDataGidx && string.equals("datagidx")) {
                this.verboseMessage("datatool2bib.skipping.database", "datagidx");
                this.skipDataGidx = false;
                continue;
            }
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.add(string);
        }
        int n2 = vector == null ? 0 : vector.size();
        int n3 = n2 + (n = this.gidxdata == null ? 0 : this.gidxdata.size());
        if (n3 == 0) {
            throw new Bib2GlsException(this.getMessage("datatool2bib.no.databases"));
        }
        if (n3 == 1) {
            this.split = false;
        }
        this.message(this.getMessage("datatool2bib.databases.found", n2));
        this.message(this.getMessage("datatool2bib.gidxdata.found", n));
        if (this.bibCharsetName == null) {
            charset = this.getDefaultCharset();
            this.bibCharsetName = charset.name();
        } else {
            charset = Charset.forName(this.bibCharsetName);
        }
        PrintWriter printWriter = null;
        if (this.split) {
            File file;
            String string = this.bibFile.getName();
            File file2 = this.bibFile.getParentFile();
            int n4 = string.lastIndexOf(".");
            if (n4 > 0) {
                string = string.substring(0, n4);
            }
            if (vector != null) {
                for (String string2 : vector) {
                    file = new File(file2, string + "-" + string2 + ".bib");
                    if (!this.overwriteFiles && file.exists()) {
                        throw new IOException(this.getMessage("error.file_exists.nooverwrite", file, "--overwrite"));
                    }
                    this.message(this.getMessage("message.writing", file));
                    try {
                        printWriter = new PrintWriter(this.createBufferedWriter(file.toPath(), charset));
                        printWriter.println("% Encoding: " + this.bibCharsetName);
                        this.writeEntries(this.datatoolSty.getDataBase(string2), printWriter);
                    }
                    finally {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                    }
                }
            }
            if (this.gidxdata == null) return;
            for (String string2 : this.gidxdata.keySet()) {
                file = new File(file2, string + "-" + string2 + ".bib");
                if (!this.overwriteFiles && file.exists()) {
                    throw new IOException(this.getMessage("error.file_exists.nooverwrite", file, "--overwrite"));
                }
                this.message(this.getMessage("message.writing", file));
                try {
                    printWriter = new PrintWriter(this.createBufferedWriter(file.toPath(), charset));
                    printWriter.println("% Encoding: " + this.bibCharsetName);
                    this.writeGidxPreamble(printWriter);
                    this.writeEntries(string2, this.gidxdata.get(string2), printWriter);
                }
                finally {
                    if (printWriter == null) continue;
                    printWriter.close();
                }
            }
            return;
        }
        try {
            if (!this.overwriteFiles && this.bibFile.exists()) {
                throw new IOException(this.getMessage("error.file_exists.nooverwrite", this.bibFile, "--overwrite"));
            }
            this.message(this.getMessage("message.writing", this.bibFile));
            printWriter = new PrintWriter(this.createBufferedWriter(this.bibFile.toPath(), charset));
            printWriter.println("% Encoding: " + this.bibCharsetName);
            if (vector != null) {
                for (String string : vector) {
                    this.writeEntries(this.datatoolSty.getDataBase(string), printWriter);
                }
            }
            if (this.gidxdata == null) return;
            this.writeGidxPreamble(printWriter);
            for (String string : this.gidxdata.keySet()) {
                this.writeEntries(string, this.gidxdata.get(string), printWriter);
            }
            return;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public String processLabel(DataToolEntry dataToolEntry) throws IOException {
        TeXObject teXObject = dataToolEntry.getContents();
        if (this.isDebuggingOn()) {
            this.logAndPrintMessage(this.getMessage("datatool2bib.processing.entry_label", teXObject.toString(this.parser)));
        }
        String string = this.parser.expandToString(teXObject, null);
        return this.processLabel(string);
    }

    protected void writeEntries(DataBase dataBase, PrintWriter printWriter) throws IOException, Bib2GlsException {
        Object object;
        String string;
        String string2;
        this.message(this.getMessage("datatool2bib.database", dataBase.getName()));
        if (this.autoLabelPrefix == null) {
            string2 = this.processLabel(dataBase.getName());
            this.autoLabelIdx = 0;
        } else {
            string2 = this.autoLabelPrefix;
        }
        DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
        DataToolRows dataToolRows = dataBase.getData();
        int n = dataToolHeaderRow.size();
        int n2 = dataToolRows.size();
        if (n == 0 || n2 == 0) {
            this.message(this.getMessage("datatool2bib.database.empty", dataBase.getName()));
            return;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (Object object2 : dataToolHeaderRow) {
            int n6 = ((DataToolHeader)object2).getColumnIndex();
            string = ((DataToolHeader)object2).getColumnLabel();
            if (!this.autoLabel) {
                if (string.equals(this.labelColumn)) {
                    n3 = n6;
                } else if (string.equals(this.fallbackLabelColumn)) {
                    n5 = n6;
                }
            }
            if ((object = this.getFieldName(string)) == null) continue;
            hashMap.put(n6, (String)object);
            if (!this.isIndexConversionOn() || !((String)object).equalsIgnoreCase("description")) continue;
            n4 = n6;
        }
        if (!this.autoLabel && n3 < 1) {
            if (n5 > 0) {
                this.verboseMessage("datatool2bib.replace.missing.label.column", dataBase.getName(), this.labelColumn, this.fallbackLabelColumn);
                n3 = n5;
            }
            if (n3 < 1) {
                this.warning(this.getMessage("datatool2bib.missing.label.column", dataBase.getName(), this.labelColumn, "--label", "--auto-label"));
                return;
            }
        }
        Object object3 = null;
        if (this.dependencyField != null) {
            object3 = new Vector();
        }
        for (DataToolEntryRow dataToolEntryRow : dataToolRows) {
            if (object3 != null) {
                ((Vector)object3).clear();
            }
            printWriter.println();
            string = "entry";
            if (this.isIndexConversionOn() && (n4 == 0 || dataToolEntryRow.getEntry(n4) == null)) {
                string = "index";
            }
            printWriter.format("@%s{", this.applyFieldCase(string));
            String string3 = "";
            String string4 = "";
            if (this.autoLabel) {
                string4 = string3 = string2 + ++this.autoLabelIdx;
            } else {
                object = dataToolEntryRow.getEntry(n3);
                if (object != null) {
                    string4 = ((DataToolEntry)object).toString(this.parser);
                    string3 = this.processLabel((DataToolEntry)object);
                    if (this.isMappedLabel(string3)) {
                        this.warningMessage("common.label_clash", string3);
                        string3 = "";
                    }
                }
                if (string3.isEmpty()) {
                    if (n5 > 0 && n5 != n3) {
                        this.verboseMessage("datatool2bib.using.fallback", string4, this.fallbackLabelColumn);
                        object = dataToolEntryRow.getEntry(n5);
                        if (object != null && this.isMappedLabel(string3 = this.processLabel((DataToolEntry)object))) {
                            this.warningMessage("common.label_clash", string3);
                            string3 = "";
                        }
                    }
                    if (string3.isEmpty()) {
                        this.verboseMessage("datatool2bib.using.autolabel", string4);
                        string4 = string3 = string2 + ++this.autoLabelIdx;
                    }
                }
            }
            this.addLabelMapping(string4, string3);
            printWriter.print(string3);
            for (Integer n7 : hashMap.keySet()) {
                Object object4;
                DataElement dataElement;
                DatumType datumType;
                object = dataToolEntryRow.getEntry(n7);
                if (object == null) continue;
                TeXObject teXObject = this.processValue(((DataToolEntry)object).getContents(), (Vector<String>)object3);
                String string5 = (String)hashMap.get(n7);
                printWriter.println(",");
                String string6 = teXObject.toString(this.getParser());
                printWriter.format("  %s = {%s}", string5, string6);
                if (this.dataValueSuffix == null && this.dataCurrencySuffix == null || !(datumType = (dataElement = this.datatoolSty.getElement(teXObject)).getDatumType()).isNumeric()) continue;
                DataNumericElement dataNumericElement = (DataNumericElement)teXObject;
                if (this.dataValueSuffix != null && !((String)(object4 = datumType == DatumType.INTEGER ? "" + dataNumericElement.intValue() : "" + dataNumericElement.doubleValue())).equals(string6)) {
                    printWriter.println(",");
                    printWriter.format("  %s%s = {%s}", string5, this.dataValueSuffix, object4);
                }
                if (datumType != DatumType.CURRENCY || this.dataCurrencySuffix == null || (object4 = dataNumericElement.getCurrencySymbol()) == null) continue;
                printWriter.println(",");
                printWriter.format("  %s%s = {%s}", string5, this.dataCurrencySuffix, object4.toString(this.parser));
            }
            if (object3 != null) {
                ((Vector)object3).remove(string3);
                if (((Vector)object3).size() > 0) {
                    printWriter.format(",%n  %s = {", this.dependencyField);
                    for (int i = 0; i < ((Vector)object3).size(); ++i) {
                        if (i > 0) {
                            printWriter.print(",");
                        }
                        printWriter.print((String)((Vector)object3).get(i));
                    }
                    printWriter.print("}");
                }
            }
            if (this.databaseField != null) {
                printWriter.format(",%n  %s = {%s}", this.databaseField, dataBase.getName());
            }
            printWriter.println();
            printWriter.println("}");
        }
    }

    @Override
    protected void initInterpreter() {
        super.initInterpreter();
        this.interpreterParser.putControlSequence(true, new AtGobble("glsadd"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("acronymfont"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textrm"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("texttt"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textsf"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textbf"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textmd"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textit"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textsl"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("emph"));
        this.interpreterParser.putControlSequence(true, new AtFirstOfOne("textsuperscript"));
        this.interpreterParser.putControlSequence(true, new AtGobble("DTLgidxParen"));
        this.interpreterParser.putControlSequence(true, new AtGobble("DTLgidxIgnore"));
        this.interpreterParser.putControlSequence(true, new AtNumberOfNumber("DTLgidxName", 2, 2));
        this.interpreterParser.putControlSequence(true, new DataGidxAtInvert("DTLgidxPlace"));
        this.interpreterParser.putControlSequence(true, new DataGidxAtInvert("DTLgidxSubject"));
        this.interpreterParser.putControlSequence(true, new AtNumberOfNumber("DTLgidxOffice", 2, 2));
        this.interpreterParser.putControlSequence(true, new DataGidxAtBothOfTwo("DTLgidxParticle"));
        this.interpreterParser.putControlSequence(true, new AtGobble("__datagidx_punc:n"));
    }

    protected void writeGidxPreamble(PrintWriter printWriter) throws IOException {
        printWriter.format("@%s{\"", this.applyFieldCase("preamble"));
        printWriter.println("\\providecommand{\\dtltexorsort}[2]{#1}");
        printWriter.println("\\providecommand{\\DTLgidxName}[2]{\\dtltexorsort{#1 #2}{#2\\datatoolpersoncomma #1}}");
        printWriter.println("\\providecommand{\\DTLgidxOffice}[2]{\\dtltexorsort{#2 (#1)}{#2\\datatoolpersoncomma #1}}");
        printWriter.println("\\providecommand{\\DTLgidxPlace}[2]{\\dtltexorsort{#2}{#2\\datatoolplacecomma #1}}");
        printWriter.println("\\providecommand{\\DTLgidxSubject}[2]{\\dtltexorsort{#2}{#2\\datatoolsubjectcomm #1}}");
        printWriter.println("\\providecommand{\\DTLgidxRank}[2]{\\dtltexorsort{#1~#2}{#2.}}");
        printWriter.println("\\providecommand{\\DTLgidxParticle}[2]{\\dtltexorsort{#1~#2}{#2.}}");
        printWriter.println("\\providecommand{\\DTLgidxParen}[1]{\\dtltexorsort{ (#1)}{}}");
        printWriter.println("\\providecommand{\\DTLgidxIgnore}[1]{\\dtltexorsort{#1}{}}");
        printWriter.println("\\providecommand{\\DTLgidxSaint}[1]{\\dtltexorsort{#1}{Saint}}");
        printWriter.println("\\providecommand{\\DTLgidxMac}[1]{\\dtltexorsort{#1}{Mac}}");
        printWriter.println("\\providecommand{\\DTLgidxNameNum}[1]{\\dtltexorsort{\\csuse{@Roman}{#1}}{\\csuse{two@digits}{#1}}}");
        printWriter.println("\"}");
    }

    protected void writeEntries(String string, Vector<GidxData> vector, PrintWriter printWriter) throws IOException, Bib2GlsException {
        String string2;
        this.message(this.getMessage("datatool2bib.datagidx", string));
        if (this.autoLabelPrefix == null) {
            string2 = this.processLabel(string);
            this.autoLabelIdx = 0;
        } else {
            string2 = this.autoLabelPrefix;
        }
        Object object = "description";
        Object object2 = "short";
        Object object3 = "long";
        Object object4 = "name";
        Object object5 = "text";
        Object object6 = "plural";
        if (this.keyToFieldMap != null) {
            for (Object object7 : this.keyToFieldMap.keySet()) {
                String object8 = ((String)this.keyToFieldMap.get(object7)).toLowerCase();
                if (object8.equals("description")) {
                    object = object7;
                    continue;
                }
                if (object8.equals("short")) {
                    object2 = object7;
                    continue;
                }
                if (object8.equals("long")) {
                    object3 = object7;
                    continue;
                }
                if (object8.equals("name")) {
                    object4 = object7;
                    continue;
                }
                if (object8.equals("text")) {
                    object5 = object7;
                    continue;
                }
                if (!object8.equals("plural")) continue;
                object6 = object7;
            }
        }
        Object object9 = null;
        if (this.dependencyField != null) {
            object9 = new Vector();
        }
        for (GidxData gidxData : vector) {
            String string3;
            String string4;
            if (object9 != null) {
                ((Vector)object9).clear();
            }
            if ((string4 = this.getMappedLabel(string3 = gidxData.getLabel())) == null) {
                this.error(this.getMessage("common.no_label_mapping", string3));
                string4 = this.processLabel(string3);
                if (string4 == null || string4.isEmpty()) {
                    this.verboseMessage("datatool2bib.using.autolabel", string3);
                    string4 = string2 + ++this.autoLabelIdx;
                }
            }
            KeyValList keyValList = gidxData.getFields();
            printWriter.println();
            String string5 = gidxData.getEntryType();
            if (string5.equals("abbreviation")) {
                if (this.stripAcronymText) {
                    keyValList.remove(object5);
                    keyValList.remove(object6);
                }
                if (this.stripAcronymName) {
                    keyValList.remove(object4);
                }
            } else if (this.isIndexConversionOn() && string5.equals("entry") && keyValList.get(object) == null) {
                string5 = "index";
            }
            printWriter.format("@%s{%s", this.applyFieldCase(string5), string4);
            int n = 0;
            TeXObject teXObject = (TeXObject)keyValList.get(object4);
            TeXObject teXObject2 = (TeXObject)keyValList.get(object5);
            if (teXObject2 != null && teXObject != null && teXObject2.equals(teXObject)) {
                keyValList.remove(object5);
            }
            for (String string6 : keyValList.keySet()) {
                Object object7;
                String string7;
                TeXObject teXObject3 = (TeXObject)keyValList.get(string6);
                if (teXObject3 == null) continue;
                teXObject3 = this.processValue(teXObject3, (Vector<String>)object9);
                String string8 = this.getFieldName(string6);
                if (string8 == null || string8.equalsIgnoreCase("label")) continue;
                String string9 = teXObject3.toString(this.parser);
                if (string8.equalsIgnoreCase("name") && (string5.equals("index") && string9.equals(string4) || string5.equals("abbreviation") && string9.equals(((TeXObject)keyValList.get(object2)).toString(this.parser)))) continue;
                ++n;
                if (string8.equalsIgnoreCase("parent")) {
                    string7 = string9;
                    object7 = this.getMappedLabel(string7);
                    if (object7 == null) {
                        this.error(this.getMessage("common.unknown.parent", string7));
                        string9 = this.processLabel(string7);
                        if (string9.isEmpty()) continue;
                        this.verboseMessage("common.unknown.parent.sub", string7, string9);
                    } else {
                        string9 = object7;
                    }
                } else if (string8.equalsIgnoreCase("see") || string8.equalsIgnoreCase("seealso") || string8.equalsIgnoreCase("alias")) {
                    string9 = string9.trim();
                    string7 = "";
                    if (string9.startsWith("[")) {
                        if (this.parser.isStack(teXObject3)) {
                            object7 = ((TeXObjectList)teXObject3).popArg(this.parser, 91, 93);
                            if (object7 != null) {
                                string7 = "[" + object7.toString(this.parser) + "]";
                                string9 = teXObject3.toString(this.parser);
                            }
                        } else {
                            int n2 = string9.indexOf(93);
                            if (n2 > 0) {
                                string7 = string9.substring(0, n2);
                                string9 = string9.substring(n2 + 1);
                            }
                        }
                    }
                    object7 = string9.split(" *, *");
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string7);
                    for (Object object8 : object7) {
                        String string10 = this.getMappedLabel((String)object8);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(',');
                        }
                        if (string10 == null) {
                            Object object10 = this.processLabel((String)object8);
                            if (((String)object10).isEmpty()) {
                                object10 = object8;
                            }
                            if (((String)object8).equals(object10)) {
                                this.warningMessage("common.unknown.xrlabel", object8);
                            } else {
                                this.warningMessage("common.unknown.xrlabel.sub", object8, object10);
                            }
                            stringBuilder.append((String)object10);
                            continue;
                        }
                        stringBuilder.append(string10);
                    }
                    string9 = stringBuilder.toString();
                }
                printWriter.println(",");
                printWriter.format("  %s = {%s}", string8, string9);
            }
            if (object9 != null) {
                ((Vector)object9).remove(string4);
                if (((Vector)object9).size() > 0) {
                    printWriter.format(",%n  %s = {", this.dependencyField);
                    for (int i = 0; i < ((Vector)object9).size(); ++i) {
                        if (i > 0) {
                            printWriter.print(",");
                        }
                        printWriter.print((String)((Vector)object9).get(i));
                    }
                    printWriter.print("}");
                    ++n;
                }
            }
            if (this.databaseField != null) {
                printWriter.format(",%n  %s = {%s}", this.databaseField, string);
                ++n;
            }
            if (n > 0) {
                printWriter.println();
            }
            printWriter.println("}");
        }
    }

    public void addGidxDatabase(String string) {
        ControlSequence controlSequence;
        Vector<GidxData> vector;
        if (this.gidxdata == null) {
            this.gidxdata = new HashMap();
        }
        if ((vector = this.gidxdata.get(string)) == null) {
            vector = new Vector();
            this.gidxdata.put(string, vector);
        }
        if ((controlSequence = this.parser.getControlSequence(DATAGIDX_DEFAULT_DATABASE)) == null || controlSequence.isEmpty()) {
            this.parser.putControlSequence(true, new TextualContentCommand(DATAGIDX_DEFAULT_DATABASE, string));
        }
    }

    public GidxData getGidxData(String string, Vector<GidxData> vector) {
        for (GidxData gidxData : vector) {
            if (!gidxData.getLabel().equals(string)) continue;
            return gidxData;
        }
        return null;
    }

    public void addTerm(String string, GidxData gidxData) throws IOException {
        String string2;
        String string3;
        Vector<GidxData> vector;
        if (this.gidxdata == null) {
            this.gidxdata = new HashMap();
        }
        if ((vector = this.gidxdata.get(string)) == null) {
            vector = new Vector();
            this.gidxdata.put(string, vector);
        }
        if (this.autoLabelPrefix == null) {
            string3 = this.processLabel(string);
            this.autoLabelIdx = 0;
        } else {
            string3 = this.autoLabelPrefix;
        }
        String string4 = gidxData.getLabel();
        String string5 = this.processLabel(string4);
        boolean bl = false;
        if (string5.isEmpty()) {
            this.verboseMessage("datatool2bib.using.fallback", string4, this.fallbackLabelColumn);
            string5 = gidxData.getFieldString(this.fallbackLabelColumn, this.parser);
            bl = false;
            if (string5 != null) {
                this.verboseMessage("datatool2bib.fallback_value", string5);
                string5 = this.processLabel(string5);
            }
            if (string5 == null || string5.isEmpty()) {
                this.verboseMessage("datatool2bib.using.autolabel", string4);
                string5 = string3 + ++this.autoLabelIdx;
            }
        }
        if ((string2 = this.getOriginalLabel(string5)) != null) {
            this.warningMessage("common.label_clash", string5);
            if (string5.equals(string4)) {
                String string6 = null;
                GidxData gidxData2 = this.getGidxData(string2, vector);
                if (gidxData2 != null) {
                    this.removeLabelMapping(string2);
                    string6 = gidxData2.getFieldString(this.fallbackLabelColumn, this.parser);
                    if (string6 != null && this.isMappedLabel(string6 = this.processLabel(string6))) {
                        string6 = null;
                    }
                    if (string6 == null || string6.isEmpty()) {
                        string6 = string3 + ++this.autoLabelIdx;
                        this.verboseMessage("datatool2bib.using.autolabel", string2);
                    }
                    this.verboseMessage("datatool2bib.label.changed", string2, string6);
                    this.addLabelMapping(string2, string6);
                } else {
                    string5 = null;
                }
            } else {
                string5 = null;
            }
            if (string5 == null) {
                if (!bl && (string5 = gidxData.getFieldString(this.fallbackLabelColumn, this.parser)) != null && this.isMappedLabel(string5 = this.processLabel(string5))) {
                    string5 = null;
                }
                if (string5 == null || string5.isEmpty()) {
                    this.verboseMessage("datatool2bib.using.autolabel", string4);
                    string5 = string3 + ++this.autoLabelIdx;
                }
            }
        }
        if (!string5.equals(string4)) {
            this.verboseMessage("datatool2bib.label.changed", string4, string5);
        }
        this.addLabelMapping(string4, string5);
        vector.add(gidxData);
    }

    protected TeXObject processValue(TeXObject teXObject, Vector<String> vector) {
        if (this.parser.isStack(teXObject) && (this.stripGlsAdd || this.stripAcronymFont || this.stripCaseChange || this.adjustGls)) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            TeXObjectList teXObjectList2 = this.listener.createStack();
            try {
                this.processTermValue(teXObjectList, teXObjectList2, vector);
            }
            catch (TeXSyntaxException teXSyntaxException) {
                this.warning(teXSyntaxException.getMessage(this));
                teXObjectList2.addAll(teXObjectList);
            }
            catch (IOException iOException) {
                this.warning(iOException.getMessage());
                teXObjectList2.addAll(teXObjectList);
            }
            return teXObjectList2;
        }
        return teXObject;
    }

    protected void processTermValue(TeXObjectList teXObjectList, TeXObjectList teXObjectList2, Vector<String> vector) throws IOException {
        while (!teXObjectList.isEmpty()) {
            Object object;
            Object object2;
            TeXObject teXObject = teXObjectList.pop();
            if (this.stripGlsAdd && TeXParserUtils.isControlSequence(teXObject, "glsadd")) {
                int n;
                object2 = TeXParserUtils.popLabelString(this.parser, teXObjectList).trim();
                if (vector == null) continue;
                if (((String)object2).startsWith("[") && (n = ((String)object2).indexOf(93)) > 0) {
                    object2 = ((String)object2).substring(n + 1);
                }
                if ((object = this.getMappedLabel((String)object2)) == null) {
                    object = this.processLabel((String)object2);
                    if (((String)object).isEmpty()) {
                        object = object2;
                    }
                    if (((String)object).equals(object2)) {
                        this.error(this.getMessage("common.unknown.reflabel", (String)object2));
                    } else {
                        this.error(this.getMessage("common.unknown.reflabel.sub", object2, object));
                    }
                }
                if (vector.contains(object)) continue;
                vector.add((String)object);
                continue;
            }
            if (this.stripAcronymFont && TeXParserUtils.isControlSequence(teXObject, "acronymfont")) {
                teXObject = teXObjectList.popArg(this.parser);
                teXObjectList.push(teXObject, true);
                continue;
            }
            if (this.stripCaseChange && this.isCaseChanger(teXObject)) {
                teXObject = teXObjectList.popArg(this.parser);
                teXObjectList.push(teXObject, true);
                continue;
            }
            if (this.adjustGls && TeXParserUtils.isControlSequence(teXObject, "gls", "Gls", "glsnl", "Glsnl", "glspl", "Glspl", "glsplnl", "Glsplnl", "glssym", "Glssym", "glsadd", "glslink", "glsdispentry", "Glsdispentry")) {
                String string;
                String string2;
                object2 = ((ControlSequence)teXObject).getName();
                object = teXObjectList.popArg(this.parser);
                String string3 = null;
                if (this.parser.isStack(object)) {
                    string3 = TeXParserUtils.popOptLabelString(this.parser, (TeXObjectList)object);
                }
                if ((string2 = this.getMappedLabel(string = this.parser.expandToString((TeXObject)object, null))) == null) {
                    string2 = this.processLabel(string);
                    if (string2.isEmpty()) {
                        string2 = string;
                    }
                    if (string2.equals(string)) {
                        this.error(this.getMessage("common.unknown.reflabel", string));
                    } else {
                        this.error(this.getMessage("common.unknown.reflabel.sub", string, string2));
                    }
                }
                boolean bl = false;
                if (((String)object2).equals("glsdispentry")) {
                    object2 = "glsxtrusefield";
                } else if (((String)object2).equals("Glsdispentry")) {
                    object2 = "Glsxtrusefield";
                } else if (((String)object2).equals("glssym")) {
                    object2 = "glssymbol";
                } else if (((String)object2).equals("Glssym")) {
                    object2 = "Glssymbol";
                } else if (((String)object2).endsWith("nl")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
                    bl = true;
                }
                teXObjectList2.add(new TeXCsRef((String)object2));
                if (bl) {
                    teXObjectList2.add(this.parser.getListener().getOther(42));
                }
                if (string3 != null && !string3.isEmpty()) {
                    teXObjectList2.add(this.parser.getListener().getOther(91));
                    teXObjectList2.addAll(this.parser.getListener().createString("format"));
                    teXObjectList2.add(this.parser.getListener().getOther(61));
                    teXObjectList2.addAll(this.parser.getListener().createString(string3));
                    teXObjectList2.add(this.parser.getListener().getOther(93));
                }
                teXObjectList2.add(this.parser.getListener().createGroup(string2));
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                object2 = ((TeXObjectList)teXObject).createList();
                teXObjectList2.add((TeXObject)object2);
                this.processTermValue((TeXObjectList)teXObject, (TeXObjectList)object2, vector);
                continue;
            }
            teXObjectList2.add(teXObject);
        }
    }

    protected void stripCaseChangers(TeXObjectList teXObjectList, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject = teXObjectList.pop();
            if (this.isCaseChanger(teXObject)) {
                teXObjectList.push(teXObjectList.popArg(teXParser), true);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
                teXObjectList2.add(teXObjectList3);
                this.stripCaseChangers((TeXObjectList)teXObject, teXParser, teXObjectList3);
                continue;
            }
            teXObjectList2.add(teXObject);
        }
    }

    public boolean isStripCaseChangeOn() {
        return this.stripCaseChange;
    }

    public boolean isDetectSymbolsOn() {
        return this.detectSymbols;
    }

    public boolean isNumber(String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance(this.numericLocale == null ? Locale.getDefault() : this.numericLocale);
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.numberFormat.parse(string, parsePosition);
        return parsePosition.getIndex() == string.length();
    }

    @Override
    protected void syntaxInfo() {
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.info", NAME));
    }

    @Override
    protected void ioHelp() {
        super.ioHelp();
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.split", "--[no-]split"));
    }

    @Override
    protected void filterHelp() {
        super.filterHelp();
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.skip-datagidx", "--[no-]skip-datagidx"));
    }

    @Override
    protected void adjustHelp() {
        super.adjustHelp();
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.label", "--label", "-L", this.labelColumn));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.fallback-label", "--fallback-label", "-F", this.fallbackLabelColumn));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.auto-label", "--[no-]auto-label", "-a"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.auto-label-prefix", "--auto-label-prefix"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.adjust-gls", "--[no-]adjust-gls"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.database-field", "--[no-]database-field"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.dependency-field", "--[no-]dependency-field", "strip-glsadd"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.detect-symbols", "--[no-]detect-symbols"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip-glsadd", "--[no-]strip-glsadd"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip-acronym-font", "--[no-]strip-acronym-font"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip-acronym-text", "--[no-]strip-acronym-text"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip-acronym-name", "--[no-]strip-acronym-name"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip-case-change", "--[no-]strip-case-change"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.strip", "--[no-]strip"));
    }

    @Override
    protected void otherHelp() {
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.other"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.setup", "--setup"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.read", "--[no-]read", "-r"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.save-datum", "--[no-]save-datum", "--save-value '-value' --save-currency '-currency'"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.save-value", "--[no-]save-value"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.save-currency", "--[no-]save-currency"));
        this.printSyntaxItem(this.getMessage("datatool2bib.syntax.numeric-locale", "--numeric-locale"));
    }

    @Override
    protected int argCount(String string) {
        if (string.equals("--label") || string.equals("-L") || string.equals("--fallback-label") || string.equals("-F") || string.equals("--read") || string.equals("-r") || string.equals("--setup") || string.equals("--auto-label-prefix") || string.equals("--save-value") || string.equals("--save-currency") || string.equals("--dependency-field") || string.equals("--database-field") || string.equals("--numeric-locale")) {
            return 1;
        }
        return super.argCount(string);
    }

    @Override
    protected boolean parseArg(ArrayDeque<String> arrayDeque, String string, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        if (this.isArg(arrayDeque, string, "-L", "--label", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.labelColumn = bibGlsArgValueArray[0].toString();
        } else if (this.isArg(arrayDeque, string, "-F", "--fallback-label", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.fallbackLabelColumn = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--auto-label") || string.equals("-a")) {
            this.autoLabel = true;
        } else if (string.equals("--no-auto-label")) {
            this.autoLabel = false;
            this.autoLabelPrefix = null;
        } else if (this.isArg(arrayDeque, string, "--auto-label-prefix", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.autoLabel = true;
            this.autoLabelPrefix = bibGlsArgValueArray[0].toString().trim();
            if (this.autoLabelPrefix.isEmpty()) {
                this.autoLabelPrefix = null;
            }
        } else if (this.isArg(arrayDeque, string, "-r", "--read", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.readOpts = bibGlsArgValueArray[0].toString().trim();
            if (this.readOpts.isEmpty()) {
                this.readOpts = null;
            }
        } else if (string.equals("--no-read")) {
            this.readOpts = null;
        } else if (this.isArg(arrayDeque, string, "--setup", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.setup = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--save-datum")) {
            this.dataValueSuffix = "-value";
            this.dataCurrencySuffix = "-currency";
        } else if (string.equals("--no-save-datum")) {
            this.dataValueSuffix = null;
            this.dataCurrencySuffix = null;
        } else if (this.isArg(arrayDeque, string, "--save-value", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.dataValueSuffix = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--no-save-value")) {
            this.dataValueSuffix = null;
        } else if (this.isArg(arrayDeque, string, "--save-currency", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.dataCurrencySuffix = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--no-save-currency")) {
            this.dataCurrencySuffix = null;
        } else if (this.isArg(arrayDeque, string, "--database-field", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.databaseField = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--no-database-field")) {
            this.databaseField = null;
        } else if (this.isArg(arrayDeque, string, "--dependency-field", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.dependencyField = bibGlsArgValueArray[0].toString();
        } else if (string.equals("--no-dependency-field")) {
            this.dependencyField = null;
        } else if (string.equals("--split")) {
            this.split = true;
        } else if (string.equals("--no-split")) {
            this.split = false;
        } else if (string.equals("--adjust-gls")) {
            this.adjustGls = true;
        } else if (string.equals("--no-adjust-gls")) {
            this.adjustGls = false;
        } else if (string.equals("--strip")) {
            this.stripGlsAdd = true;
            this.stripAcronymFont = true;
            this.stripAcronymText = true;
            this.stripAcronymName = true;
            this.stripCaseChange = true;
        } else if (string.equals("--no-strip")) {
            this.stripGlsAdd = false;
            this.stripAcronymFont = false;
            this.stripAcronymText = false;
            this.stripAcronymName = false;
            this.stripCaseChange = false;
        } else if (string.equals("--strip-glsadd")) {
            this.stripGlsAdd = true;
        } else if (string.equals("--no-strip-glsadd")) {
            this.stripGlsAdd = false;
        } else if (string.equals("--strip-acronym-font")) {
            this.stripAcronymFont = true;
        } else if (string.equals("--no-strip-acronym-font")) {
            this.stripAcronymFont = false;
        } else if (string.equals("--strip-acronym-text")) {
            this.stripAcronymText = true;
        } else if (string.equals("--no-strip-acronym-text")) {
            this.stripAcronymText = false;
        } else if (string.equals("--strip-acronym-name")) {
            this.stripAcronymName = true;
        } else if (string.equals("--no-strip-acronym-name")) {
            this.stripAcronymName = false;
        } else if (string.equals("--strip-case-change")) {
            this.stripCaseChange = true;
        } else if (string.equals("--no-strip-case-change")) {
            this.stripCaseChange = false;
        } else if (string.equals("--skip-datagidx")) {
            this.skipDataGidx = true;
        } else if (string.equals("--no-skip-datagidx")) {
            this.skipDataGidx = false;
        } else if (string.equals("--detect-symbols")) {
            this.detectSymbols = true;
        } else if (string.equals("--no-detect-symbols")) {
            this.detectSymbols = false;
        } else if (this.isArg(arrayDeque, string, "--numeric-locale", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.numericLocale = Locale.forLanguageTag(bibGlsArgValueArray[0].toString());
        } else {
            return super.parseArg(arrayDeque, string, bibGlsArgValueArray);
        }
        return true;
    }

    @Override
    public String getApplicationName() {
        return NAME;
    }

    @Override
    public String getCopyrightStartYear() {
        return "2024";
    }

    public static void main(String[] stringArray) {
        DataTool2Bib dataTool2Bib = new DataTool2Bib();
        dataTool2Bib.run(stringArray);
    }
}

