---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              opérateurs, grands opérateurs, bornes d'une intégrale, somme, 
              intégrale
---

# Comment positionner les limites des grands opérateurs ?

Quand une personne écrit à la main des intégrales (∫), des sommes (Σ) 
ou autres "grands opérateurs", elle place généralement leurs bornes 
au-dessous et au-dessus du symbole de l'opérateur. 


## Avec les mises en indice et exposant

Dans (La)TeX, la mise en indices et en exposant appliquée aux opérateurs 
`\int` ou `\sum` donne un premier résultat.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici une première somme $\sum_{k=1}^{n} x^k$ et
voici une seconde somme :
\[  \sum_{k=1}^{n} k x^k  \] 
\end{document}
```

Cependant, le rendu n'est pas toujours celui dont vous pouvez avoir l'habitude
à la main, en particulier pour la première des deux sommes 
de l'exemple ci-dessus. 

Il y a une raison à ce placement : quand une somme ou un intégrale apparaît
dans du texte courant (en mode `\textstyle`, donc 
[non mise en exergue hors du paragraphe en cours](/4_domaines_specialises/mathematiques/styles/a_quoi_sert_displaystyle)), 
le fait de placer les bornes de cette manière pourrait rendre l'interlignage
irrégulier, et donc le texte difficile à lire. Il est donc courant 
(dans ce mode `\textstyle`) de placer les bornes comme cela se ferait 
pour les indices et les exposants des variables, décalées vers la droite.


## Avec les commandes de base

### `\limits` et `\nolimits`

La méthode ci-dessus n'est pas toujours très satisfaisante, c'est pourquoi 
il existe une primitive `\limits` qui placera les bornes juste au-dessous 
et au-dessus du symbole (tant pis pour l'interlignage...).

À l'inverse, vous pouvez souhaiter modifier la disposition des bornes 
lorsque vous êtes en mode `\displaystyle`. Pour cela, il existe une primitive
`\nolimits` qui placera les bornes comme elles le seraient en mode 
`\textstyle`.

L'exemple suivant illustre ces deux cas.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici de nouveau notre première somme 
$ \sum\limits_{k=1}^{n} x^k $, 
suivie de notre deuxième somme modifiée :
\[  \sum\nolimits_{k=1}^{n} k x^k  \]
\end{document}
```

Notez que la commande `\int` a déjà un `\nolimits` intégré dans sa définition.
Il existe un exemple dans le 
[TeX​book](/1_generalites/documentation/livres/documents_sur_tex)
montrant à quel point `\int\limits` donne un rendu étrange.


### Les commandes de style mathématique

Vous pouvez aussi manipuler le 
[style mathématique](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques) 
avec les commandes `\textstyle` et `\displaystyle`. Cela permet, 
comme le montre l'exemple suivant, d'obtenir le placement des bornes :
- comme s'il y avait un `\limits` dans une formule composée en ligne 
  avec la commande `\textstyle` ;
- comme s'il y avait un `\nolimits` dans une formule en mode hors-ligne 
  avec la commande `\displaystyle`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici, encore, notre première somme 
$ \displaystyle\sum_{k=1}^{n} x^k $,
une nouvelle fois suivie par notre deuxième somme remaniée :
\[  \sum\nolimits_{k=1}^{n} k x^k  \]
\end{document}
```

L'une ou l'autre de ces formes peut avoir des effets autres que 
sur le grand opérateur en question, mais certains préfèrent ces façons
de faire.

Enfin, n'oubliez pas que si vous définissez votre propre opérateur (comme 
illustré à la question 
"[](/4_domaines_specialises/mathematiques/structures/operateurs/definir_un_nouvel_operateur)"), 
les fonctions de l'extension <ctanpkg:mathtools> (que vous devriez utiliser)
vous permettront de choisir dans la définition comment les bornes 
seront affichées.


:::{sources}
- [Sub- and superscript positioning for operators](faquk:FAQ-limits)
:::