{$IFDEF WINDOWS}
{$N-,B-,V-,W-,G+}
{$ELSE}
{$N-,E-,B-,V-,F+,O+}
{$ENDIF}

Unit BibInOut;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, Wbibgui, wbibdisp, wbibslct, wbibinit, wbibabv1, wbibabv2,
  wbibeden, wbibdlg, WinTypes, WinProcs, wbiblist, wbibpatt, wbibesrt,
  wHugeMem,
{$ELSE}
  bibwindo, Dos, bibCrt, Objects, spawno, BibMouse, bibdisp, bibsedit,
  bibedit, bibdialg, bibselct, bibedent, biblist, bibedsrt,
{$ENDIF}
  bibstrg, streams, bibstrm, bibvars, bibfile, bibutil, bib8bit, bibtext,
  bibreadB, bibwritO, bibreach, bibfilch, bibSrtPt, bibwild,
  bibprint, bibPchec, bibsave, rc_strng, bibflch2, bibcache, lfnunit;

procedure DealWithAdd(Entry: EntryRecPtr; Pattern: PatRecPtr;
                      selected: SelectionType);
procedure DealWithImport(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         selected: SelectionType);
procedure DealWithExport(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         selected: SelectionType
{$IFDEF WINDOWS}
                         ; ExportRec: PExportRec
{$ENDIF}
                         );

implementation


procedure DealWithAdd(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       selected: SelectionType);
begin
  AbortFlag:=false;
  if (CurrentBibFile=0) or (BibName^='') then Exit;
  if BibReadOnly then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
  else begin
    if (((not EditOnlyStrings) and CurrentSortMode^.SortingOn) or
       (EditOnlyStrings and (CurrentSortMode^.StringNameSort<>StrSortOff))) 
        or (selected[1]>0) then
    begin
      DeSuspend;
      if BibFileChange(pattern,Entry,Entry^.name,Ac_Add,false,'',0,2,
                       selected[1],Nil) then
      begin
        if not BibFileExists then BibFileExists:=LFNFileExist(bibname^);
        if EditOnlyStrings   then LoadStringAbbrevs(StrAbbrevsList,Entry);
      end;
    end;
  end;
end;                       { DealWithAdd }

procedure DealWithImport(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         selected: SelectionType);
var
  ok,accept,AskAgain: boolean;
  InpFile: text;
  xstart: byte;
  ImpFile,Dir,Name,Ext: Pstring;
  i: integer;

procedure TidyUp;
begin
  LFNDispose(InpFile);
  AllocStrings(false,@ImpFile,@Dir,@Name,@Ext);
end;

begin
  Failure:=false; AbortFlag:=false;
  if (CurrentBibFile=0) or (BibName^='') then Exit;
  if selected[1]=CImp_Format then
  begin
    if selected[2]<>0 then ImportFormat:=selected[2];
    Exit;
  end;
  Failure:=true;
  AllocStrings(true,@ImpFile,@Dir,@Name,@Ext);
  LFNNew(InpFile,true);
  if BibReadOnly then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
  else if (EditOnlyStrings) and (ImportFormat<>BibTeXFormat) then
    ErrorMessageRC(Str_TibInStrMode,'')
  else begin
    if (((not EditOnlyStrings) and CurrentSortMode^.SortingOn) or
       (EditOnlyStrings and (CurrentSortMode^.StringNameSort<>StrSortOff))) 
        or (selected[1]>0) then
    begin
      if MacroCommand then
      begin
        ChrDel(InputStr^,' ');
        ImpFile^:=InputStr^;
        i:=Pos(',',ImpFile^); if i>0 then ImpFile^:=Copy(ImpFile^,1,i-1);
        if (not CurrentSortMode^.SortingOn) and (Selected[1]=CIns_Num) then
        begin
          if i=0 then ImpFile^:=''
          else Delete(InputStr^,1,i);
        end;
{$IFDEF WINDOWS}
      end else ImpFile^:=InputStr^;
{$ELSE}
      end else ImpFile^:='*';
{$ENDIF}
      AskAgain:=false;
      if ImpFile^<>'' then
      repeat
        ok:=true;
        if ImpFile^=File_Clipboard then accept:=true
        else FileChoose(Impfile^,DefExtension[ImportFormat]^,TexInputList,
                   AnyFile and (not (Directory or SysFile)),
{$IFDEF WINDOWS}
                   false
{$ELSE}
                   (not MacroCommand)
{$ENDIF}
                   or AskAgain,
                   true,false,Nil,'Import File:','',accept);
        AskAgain:=false;
        if (not accept) or (ImpFile^='') then
        begin
          TidyUp; Exit;
        end;
        if ImpFile^=File_Clipboard then
        begin
          accept:=true; ok:=true;
        end else if accept and (Impfile^<>'') then
        begin
          ok:=true;
          LFNFSplit(LFNFexpand(ImpFile^),Dir,Name,Ext);
          if Ext^='' then Ext^:=DefExtension[ImportFormat]^;
          ImpFile^:=Dir^+Name^+Ext^; CanonicalFname(ImpFile^);
          if not LFNFileExist(ImpFile^) then
          begin
            if not MacroCommand then ErrorMessageRC(str_FileNonExistent,ImpFile^);
            ok:=false; AskAgain:=true;
          end else if StrCmpI(ImpFile^,bibname^,1,1,255)=0 then
          begin
            if not MacroCommand then ErrorMessageRC(str_ImportEqualBib,'');
            ok:=false; AskAgain:=true;
          end else
          begin
            LFNAssign(InpFile,ImpFile^);
            if LFNReset(InpFile,0)<>0 then
            begin
              if not MacroCommand then ErrorMessageRC(Str_CantReadFile,Impfile^);
              ok:=false; AskAgain:=true;
            end;
            LFNClose(InpFile);
          end;
        end;
      until MacroCommand or ok or (ImpFile^='');
      if ok and (ImpFile^<>'') then
      begin
        DeSuspend;
        if BibFileChange(pattern,Entry,Entry^.name,Ac_Import,false,ImpFile^,
                         0,2,selected[1],Nil) then
        begin
          if not BibFileExists then BibFileExists:=LFNFileExist(bibname^);
          if EditOnlyStrings   then LoadStringAbbrevs(StrAbbrevsList,Entry);
          Failure:=false;
        end;
      end;
    end;
  end;
  TidyUp;
end;                           { DealWithImport }

procedure DealWithExport(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         selected: SelectionType
{$IFDEF WINDOWS}
          ; ExportRec: PExportRec
{$ENDIF}
                         );
Var
  LastPos,valcode,nspec: Integer;
  first,last,i,j,size,oreal,oentry,DumpSize: longint;
  specified: SpecArr;
  SpecFieldList: ListArrPtr;
  tmp: string;
  fname,OrderName: string;
  xstart,OldVerbosity,PrStatus: byte;
  ok,NameOnly,AllFields,WriteOut,Hok,ToClipboard,ClipOpen: Boolean;
  nonspace,newline,LastWhite,accept,DumpOK: boolean;
  AltPress: char;
  ODumpFields: FieldArr;
  DDriveFree: LongInt;
  dump: text;
  Bdump: file;
  obeginning,begtemp,InsNumber: longint;
  ndumped,N: Word;
  SortPattern: PatRecPtr;
  NullDumpFields: ^FieldArr;
{$IFDEF WINDOWS}
  OutStrm: PHugeMemStream;
{$ELSE}
  OutStrm: PStream;
{$ENDIF}

procedure Wrt(S: string);
begin
  if OutStrm=Nil then write(dump,S)
  else if S<>'' then OutStrm^.write(S[1],length(S));
end;

procedure WrtLine(S: string; Unix: boolean);
var
  EOL: string[2];
begin
  if OutStrm=Nil then WriteLine(dump,S,Unix)
  else begin
    if S<>'' then OutStrm^.write(S[1],length(S));
    if Unix then EOL:=#10 else EOL:=#13#10;
    OutStrm^.write(EOL[1],length(EOL));
  end;
end;                { WrtLine }

procedure ExportEntry(var dump: text; Entry: EntryRecPtr;
                      var fields: FieldArr; ExportFormat: byte;
                      Unix: boolean);
begin
  if ExportFormat in [CommaDelimited,TibFormat,ReferFormat] then
    DumpEntry(dump,OutStrm,Entry,fields,ExportFormat,Unix)
  else if ExportFormat<>BibTeXFormat then
    PrintEntry(dump,OutStrm,Entry,fields,ExportFormat,Unix);
end;

procedure DumpAll(FirstEnt,LastEnt: longint; OnlyTagged: boolean);
var
  i: integer;
  leave,ok: boolean;
  tmp: string[20];
  first: word;
begin                               { DumpAll }
  if not (NameOnly or WriteOut) then Exit;
  TimeOutOn:=false;
  first:=0;
  ResetBib(Entry);
  leave:=false;
  repeat
    i:=Entry^.entrynum;
    repeat
      GetEntry(Entry,Nil,Entry^.entrynum+1,true,Pattern,ok);
      inc(i);
      if Entry^.entrynum<i then ok:=false;
    until (not ok) or (not OnlyTagged) or IsTagged(Entry^.realnum,Tags);
    if ok and (entry^.entrynum>=FirstEnt) and
       ((LastEnt<=0) or (entry^.entrynum<=LastEnt)) then
    begin
      if first=0 then first:=entry^.entrynum
      else if first=entry^.entrynum then leave:=true;
      if not leave then
      begin
        if NameOnly then WrtLine(entry^.name,UnixDump)
        else if WriteOut then
          ExportEntry(dump,entry,Dumpfields,ExportFormat,UnixDump);
        inc(ndumped);
        if WriteOut then
          WaitingMessage('Exported '+num2str(ndumped)+'...');
      end;
    end;
  until (not ok) or leave or ((LastEnt>0) and (entry^.entrynum>=LastEnt));
end;                     { DumpAll }

procedure DumpFromFile(var OrderName: string);
var
  i,choice,first,nspec : integer;
  oreal,oentry: word;
  index : byte;
  leave,ok,Bjunk,accept : boolean;
  ifld,tfld : byte;
  inpFile: Text;
  ii: LongInt;
  Ename,tmp: string;
  ch: char;
begin                               { DumpFromFile }
  TimeOutOn:=false;
  if not (WriteOut or NameOnly) then Exit;
  if nameonly then
  begin
    if AskIfRC(Str_ExpLabelsOnly,'','','Abort','Continue') then Exit;
  end;
  
  ResetFile(InpFile);
  ResetBib(Entry);
  repeat
    ReadLine(InpFile,Ename,true);
    i:=Pos(CommaSeparator,Ename);
    if i>0 then Ename[0]:=Chr(i-1);
    if (ename<>'') and (Ename[1]='"') then Delete(Ename,1,1);
    if (Ename<>'') and (Ename[length(ename)]='"') then
      Delete(Ename,length(ename),1);
    ok:=false;
    ReachLabel(Entry,Pattern,ename,true,false,true,ok);
    if ok then
    begin
     if NameOnly then WrtLine(entry^.name,UnixDump)
     else if WriteOut then
       ExportEntry(dump,entry,Dumpfields,ExportFormat,UnixDump);
     inc(ndumped);
     if WriteOut then
       WaitingMessage('Exported '+num2str(ndumped)+'...');
    end;
  until eof(InpFile);
  close(InpFile);
end;                     { DumpFromFile }

procedure GetOrderFile(var OrderName: string; var ok: boolean);
var
  i: integer;
  accept: boolean;
  InpFile: text;
begin
  TimeOutOn:=false;
  OrderName:=''; ok:=false;
  LFNNew(InpFile,true);
  repeat
    FileChoose(OrderName,'',TexInputList,
               AnyFile and (not (Directory or SysFile)),
               true,true,false,Nil,'Order File:','',accept);
    if (not accept) or (OrderName='') then
    begin
      ok:=false; LFNDispose(InpFile); exit;
    end;
    ok:=true;
    OrderName:=LFNFexpand(OrderName); CanonicalFname(OrderName);
    LFNAssign(InpFile,OrderName);
    if LFNReset(InpFile,0)<>0 then
    begin
      ErrorMessageRC(Str_CantOpenFile,OrderName);
      ok:=false;
    end;
    if ok and (StrCmpI(OrderName,dumpname^,1,1,255)=0) then
    begin
      ErrorMessageRC(Str_OrderEqualExp,'');
      ok:=false;
    end;
    if ok and Linked then
    begin
      for i:=1 to BibInRing do
        if StrCmpI(OrderName,BibFiles^[BibRing[i]].name,1,1,255)=0 then
        begin
          ErrorMessageRC(Str_OrderEqual1Bib,'');
          ok:=false;
        end;
    end;
    if ok and (not Linked) and (StrCmpI(OrderName,bibname^,1,1,255)=0) then
    begin
      ErrorMessageRC(Str_OrderEqualBib,'');
      ok:=false;
    end;
    LFNClose(InpFile);
  until ok and (OrderName<>'');
  LFNDispose(InpFile);
  if OrderName='' then ok:=false;
end;                                    { GetOrderFile }

{$IFNDEF WINDOWS}
procedure GetRange(var first,last: longint; var ok: boolean);
var
  i: integer;
  tmp: string[20];
begin
  ok:=false;
  i:=(ScrWidth-40) div 2;
  MakeWindow(5,i,3,40,DialogNorm,DialogNorm,2,RNorm,shadow,0);
  tmp:='1'; AltPress:=#0;
  ReadEdit(' From: ',tmp,6,i+1,5,13,[#0..#255]-['0'..'9'],'',accept,
           AltPress,true);
  if accept and (tmp<>'') then
  begin
    Val(tmp,first,valcode);
    tmp:=''; AltPress:=#0;
    ReadEdit(' To: ',tmp,6,i+20,5,11,[#0..#255]-['0'..'9'],'',accept,
             AltPress,false);
    if accept and (tmp<>'') then Val(tmp,last,valcode)
    else last:=0;
    if ((last=0) and (first>0)) or (last>=first) then ok:=true;
  end;
  RemoveWindow;
end;                                { GetRange }
{$ENDIF}

procedure TidyUp;
begin
  WaitingOff;
  Verbosity:=OldVerbosity;
{$IFDEF WINDOWS}
  if OutStrm<>Nil then Dispose(OutStrm,Done);
{$ENDIF}
end;

begin                                            { DealWithExport }
  OutStrm:=Nil;
  Failure:=true; AbortFlag:=false; ToClipboard:=false; ClipOpen:=false;
  if (CurrentBibFile=0) or (BibName^='') then Exit;
  if (selected[1]=0) then Exit;
  SortPattern:=Nil; OrderName:='';
  oreal:=entry^.realnum; oentry:=entry^.entrynum;
  obeginning:=Entry^.beginning;
  OldVerbosity:=Verbosity; Verbosity:=0;
  first:=1; last:=0;
  Failure:=false;
{$IFDEF WINDOWS}
  if ExportRec<>Nil then with ExportRec^ do
  begin
    if      ExpAll     then selected[1]:=CExp_All
    else if ExpTagged  then selected[1]:=CExp_Tagged
    else if ExpNum     then selected[1]:=CExp_Range
    else if ExpCurrent then selected[1]:=CExp_Current
    else if ExpOrder   then selected[1]:=CExp_Ofile
    else begin
      messagebeep(0); Exit;
    end;
    if      AtEnd      then selected[2]:=CIns_EOF
    else if AtFirst    then selected[2]:=CIns_FirstEntry
    else if AtNum      then selected[2]:=CIns_Num
    else if AtBefore   then selected[2]:=CIns_EntryList
    else                    selected[2]:=CIns_Sorted;
    ToClipboard:=ExportToClipboard;
    if ToClipboard     then selected[2]:=CIns_FirstEntry;
  end;
{$ENDIF}
  if selected[1] in [CExp_Current,CExp_All,CExp_Range,CExp_Tagged,CExp_Ofile] then
  begin
    Failure:=true;
    if not BibFileExists then Exit;
    if EditOnlyStrings and (ExportFormat in [TibFormat,ReferFormat]) then
    begin
      if not MacroCommand then ErrorMessageRC(Str_TibInStrMode,'');
      Exit;
    end;
    DeSuspend; TimeOutOn:=false; Verbosity:=0;
    ndumped:=0;
    if (not ToClipboard) and (dumpname^='') then
    begin
      NewDump(true,bibname^);
      if dumpname^='' then Exit;
    end;
    if not ToClipboard then DumpFileExists:=LFNFileExist(dumpname^);
    DumpOk:=true;
    if selected[1]=CExp_All then
    begin
      if EditOnlyStrings then
        ok:=MacroCommand or YesNoRC(Str_QExportAllStrings,DumpName^)
      else ok:=MacroCommand or YesNoRC(Str_QExportAllEntries,DumpName^);
    end else if selected[1]=CExp_Range then
    begin
{$IFDEF WINDOWS}
      if ExportRec<>Nil then
      begin
        first:=ExportRec^.ExpFrom; last:=ExportRec^.ExpTo; ok:=true;
      end;
{$ELSE}
      GetRange(first,last,ok);
{$ENDIF}
    end else if selected[1]=Cexp_Ofile then
      GetOrderFile(OrderName,ok)
    else ok:=true;
    if not ok then Exit;
    
    if (ExportFormat=BibTeXFormat) or (ExportFormat=CommaDelimited) then
    begin
      if DumpLabelsOnly then NameOnly:=true
      else begin
        NameOnly:=not DumpUndecFields; AllFields:=DumpUndecFields;
        for i:=1 to OrigFieldLast do
          if DumpFields[i] then NameOnly:=false
          else AllFields:=false;
        for i:=OrigFieldLast+1 to maxfield do DumpFields[i]:=DumpUndecFields;
      end;
      WriteOut:=NameOnly or (ExportFormat<>BibTeXFormat)
                or DumpToPrinter;
    end else
    begin
      NameOnly:=false; WriteOut:=true;
    end;
{$IFDEF WINDOWS}
    if ToClipboard and (ExportFormat<>BibTeXFormat) then
    begin
      New(OutStrm,Init($1000)); 
    end;
{$ENDIF}
    if not ToClipboard then LFNNew(dump,true);
    if WriteOut and not ToClipboard then
    begin
      LFNAssign(dump,DumpName^);
{$IFNDEF WINDOWS}
      if DumpToPrinter then
      begin
        tmp:=DumpName^; StrUpr(tmp);
        repeat
          PrStatus:=PrinterStatus(DumpName^);
          if PrStatus=NoConnect then
          begin
            ErrorMessage(' Can''t find a printer on '+tmp+'! '); Exit;
          end else if (PrStatus=offline) or (PrStatus=OffLine2) then
          begin
            if not AskIf(' '+tmp+' is offline. ','','Try again','Cancel')
              then
            begin
              LFNDispose(dump); Exit;
            end;
          end else if (PrStatus=PaperOut) or (PrStatus=PaperOut2) then
          begin
            if not AskIf(' '+tmp+' is out of paper. ','','Try again','Cancel')
              then
            begin
              LFNDispose(dump); Exit;
            end;
          end else if PrStatus=HookedButOff then
          begin
            if not AskIf(' '+tmp+' is switched off. ','','Try again','Cancel')
              then
            begin
              LFNDispose(dump); Exit;
            end;
          end;
        until PrStatus=PrnReady;
        LFNReset(Dump,0);
      end else
{$ENDIF}
      if not ToClipboard and DumpFileExists then
      begin
        if ExportFormat in [TibFormat,ReferFormat,FirstUserFormat..LastFileFormat]
               then { Make sure of leading newline } 
        begin
          LFNClose(bib);
          LFNNew(bdump,false);
          LFNAssign(bdump,DumpName^);
          LFNReset(bdump,1);
          NonSpace:=false; LastWhite:=true; newline:=true;
          repeat
            BlockRead(Bdump,BibBuf^,FileBufSize,N);
            for i:=1 to N do
            begin
              if BibBuf^[i]=#10 then
              begin
                LastWhite:=not NonSpace; NonSpace:=false;
              end else if not (BibBuf^[i] in [#9,#13,' ']) then
                NonSpace:=true;
              NewLine:=BibBuf^[i] in [#10,#13];
            end;
          until N<FileBufSize;
          LFNDispose(Bdump);
          Append(dump);               { A point? should work! }
          if not NewLine then
          begin
            WriteLine(dump,'',UnixDump); LastWhite:=not NonSpace;
          end;
          if (not LastWhite) then Writeline(dump,'',UnixDump);
          SetTextBuf(bib,bibbuf^,FileBufSize);
        end else Append(dump);
      end else LFNRewrite(dump,0);
    end;
                    { Dump entries to dump file }
                    
    if NameOnly or WriteOut then
    begin
      WaitingMessage('Exporting...');
                                  { Write header in User formats}
      if (not DumpFileExists) and (not ToClipboard) and 
        (ExportFormat in [FirstUserFormat..LastFileFormat]) then
      begin
        tmp:=entry^.entrytype; entry^.entrytype:='_header';
        New(NullDumpFields);
        for i:=0 to maxfield+1 do NullDumpFields^[i]:=false;
        ExportEntry(dump,Entry,NullDumpfields^,ExportFormat,false);
        dispose(NullDumpFields);
        entry^.entrytype:=tmp;
      end;
      if selected[1]=CExp_Current then         { Export current }
      begin
        if NameOnly then
        begin
          WrtLine(entry^.name,UnixDump);
          size:=length(entry^.name)+2;
        end else if WriteOut then
          ExportEntry(dump,Entry,Dumpfields,ExportFormat,false);
      end else if selected[1]=CExp_All then    { Export All }
        DumpAll(1,0,false)
      else if selected[1]=CExp_Range then      { Export Range }
        DumpAll(first,last,false)
      else if selected[1]=CExp_Tagged then     { Export tagged }
        DumpAll(1,0,true)
      else if selected[1]=CExp_Ofile then      { Export from file }
      begin
        DumpFromFile(OrderName);
      end;
      if not ToClipboard then LFNClose(dump);
{$IFDEF WINDOWS}
      if ToClipboard and (OutStrm<>Nil) {and (OutStrm^.GetSize>4)} then
      begin
        OutStrm^.seek(OutStrm^.GetSize);
        tmp:=#0; OutStrm^.write(tmp[1],1);
        OutStrm^.ReallyTruncate:=true; OutStrm^.Truncate;
        OutStrm^.Owner:=false;
        OpenClipboard(HMainW); EmptyClipboard;
        SetClipboardData(cf_text,OutStrm^.Handle);
        CloseClipboard;
      end;
      WaitingOff;
      Failure:=false;
{$ENDIF}
    end else                             { BibTeX Export }
    begin
      if ToClipboard then ok:=true
      else if not DumpFileExists then
      begin
        ok:=(LFNAssign(dump,dumpname^)=0) and (LFNRewrite(dump,1)=0);
        LFNClose(dump);
        if LFNErase(dump)<>0 then ok:=false;
        if not ok then
        begin
          if not MacroCommand then ErrorMessageRC(Str_CantOpenExpFile,'');
          ndumped:=0;
        end;
      end;
      if ok then
      begin
        EntryCache^.on:=false;
        if selected[1]=CExp_Range then
          OrderName:=num2str(first)+' '+num2str(last);
{$IFDEF WINDOWS}
        if ToClipboard then OrderName:=File_Clipboard+OrderName;
        if (ExportRec<>Nil) and (selected[2]=CIns_Num) then
        begin
          InsNumber:=ExportRec^.InsertNum;
          BibFileChange(Pattern,Entry,Entry^.name,Ac_Export,false,OrderName,
                        selected[1],3,selected[2],@InsNumber);
        end else
{$ENDIF}
          BibFileChange(Pattern,Entry,Entry^.name,Ac_Export,false,OrderName,
                        selected[1],3,selected[2],Nil);
        if not ToClipboard then
        begin
          DumpFirstTime:=false;
          DumpFileExists:=LFNFileExist(DumpName^);
        end;
        Failure:=false;
        EntryCache^.on:=true;
      end;
    end;
    if not ToClipboard then LFNDispose(dump);
    TidyUp;
    ReachEntry(Entry,oreal,oentry,Obeginning,false);
  end else if selected[1]=CExp_Fields then   { New export fields }
  begin
    if selected[2]=CExpFields_Full then                 { All }
    begin
      for i:=1 to maxfield do DumpFields[i]:=true;
      DumpUndecFields:=true;
    end else if selected[2]=CExpFields_Labels then          { Labels only }
    begin
      for i:=1 to maxfield do DumpFields[i]:=false;
      DumpUndecFields:=false;
    end else if selected[2]=CExpFields_Specified then   { Specify fields }
    begin
{$IFDEF WINDOWS}
      UpdateExpFields;
{$ELSE}
      nspec:=0;
      for i:=1 to OrigFieldLast do if Dumpfields[i] then
      begin
        inc(nspec);
        specified[nspec]:=i;
      end;

      GetMem(SpecFieldList,(OrigFieldLast+2)*sizeof(ListArrRec));
      for i:=1 to OrigFieldlast do SpecFieldList^[i]:=TypeField^[i];
      SpecFieldList^[OrigFieldLast+1]:='_undeclared';
      if DumpUndecFields then
      begin
        inc(nspec); Specified[Nspec]:=OrigFieldLast+1;
      end;
      FieldChoose(SpecFieldList^,origfieldlast+1,3,15,specified,nspec,
                                         false,false,1,0,true,true);
      FreeMem(SpecFieldList,(OrigFieldLast+2)*sizeof(ListArrRec));
      
      for i:=1 to maxfield do
      begin
        Odumpfields[i]:=DumpFields[i];
        DumpFields[i]:=false;
      end;
      DumpUndecFields:=false;
      for i:=1 to nspec do
        if Specified[i]=OrigFieldLast+1 then DumpUndecFields:=true
        else Dumpfields[specified[i]]:=true;
      for i:=OrigFieldLast+1 to MaxField do
        DumpFields[i]:=DumpUndecFields;
{$ENDIF}
    end else if (selected[2]>=CExpFields_User) and
                (selected[2]<CExpFields_User+DmenuNum) then
    begin
      for i:=1 to maxfield do DumpFields[i]:=false;
      for i:=1 to DmenuChoice[selected[2]-CExpFields_User+1,0] do
          Dumpfields[DmenuChoice[selected[2]-CExpFields_User+1,i]]:=true;
      DumpUndecFields:=false;
    end;
  end else if selected[1]=CExp_Format then    { Toggle export file format }
  begin
    if selected[2]<>0 then ExportFormat:=selected[2];
    DumpName^:=DumpFileList^[ExportFormat];
    NewDump(false,bibname^);
  end else if selected[1]=CExp_New then        { New export file }
    NewDump(true,bibname^)
  else if (selected[1]=CExp_Clear) and (DumpName^<>'') and not DumpToPrinter and
             (MacroCommand or
               askif(' Clear file '+DumpName^ +'? ','','Clear','Cancel')) then
  begin                          { Clear dump file }
    LFNNew(dump,true); LFNAssign(dump,dumpname^);
    LFNErase(dump); LFNDispose(dump);
    New(SortPattern);
    RecallBufferStack(SortPattern^,SortPattPosDef);
    PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
    Dispose(SortPattern); SortPattern:=Nil;
    ExportSortMode^:=ConfigSortMode^;
    ExportSortMode^.SortingOn:=SortNewFiles;
    DumpFileExists:=false; DumpFirstTime:=true;
  end;
end;                                      { DealWithExport }



end.
