/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LongEdgeSplitter
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Edge splitting", 1.0f);
        if (layeredGraph.getLayers().size() <= 2) {
            monitor.done();
            return;
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer nextLayer = layerIter.next();
        while (layerIter.hasNext()) {
            Layer layer = nextLayer;
            nextLayer = layerIter.next();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        LPort targetPort = edge.getTarget();
                        Layer targetLayer = targetPort.getNode().getLayer();
                        if (targetLayer == layer || targetLayer == nextLayer) continue;
                        assert (layerIter.hasNext());
                        LongEdgeSplitter.splitEdge(edge, this.createDummyNode(layeredGraph, nextLayer, edge));
                    }
                }
            }
        }
        monitor.done();
    }

    private LNode createDummyNode(LGraph layeredGraph, Layer targetLayer, LEdge edgeToSplit) {
        LNode dummyNode = new LNode(layeredGraph);
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, edgeToSplit);
        dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        dummyNode.setLayer(targetLayer);
        return dummyNode;
    }

    public static LEdge splitEdge(LEdge edge, LNode dummyNode) {
        LPort oldEdgeTarget = edge.getTarget();
        double thickness = edge.getProperty(LayeredOptions.EDGE_THICKNESS);
        if (thickness < 0.0) {
            thickness = 0.0;
            edge.setProperty(LayeredOptions.EDGE_THICKNESS, (Object)thickness);
        }
        dummyNode.getSize().y = thickness;
        double portPos = Math.floor(thickness / 2.0);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        dummyInput.getPosition().y = portPos;
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        dummyOutput.getPosition().y = portPos;
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(oldEdgeTarget);
        LongEdgeSplitter.setDummyNodeProperties(dummyNode, edge, dummyEdge);
        LongEdgeSplitter.moveHeadLabels(edge, dummyEdge);
        return dummyEdge;
    }

    private static void setDummyNodeProperties(LNode dummyNode, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        LNode outEdgeTargetNode = outEdge.getTarget().getNode();
        if (inEdgeSourceNode.getType() == LNode.NodeType.LONG_EDGE) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES));
        } else if (inEdgeSourceNode.getType() == LNode.NodeType.LABEL) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, (Object)true);
        } else if (outEdgeTargetNode.getType() == LNode.NodeType.LABEL) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, outEdgeTargetNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, outEdgeTargetNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, (Object)true);
        } else {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdge.getSource());
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, outEdge.getTarget());
        }
    }

    private static void moveHeadLabels(LEdge oldEdge, LEdge newEdge) {
        ListIterator<LLabel> labelIterator = oldEdge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            EdgeLabelPlacement labelPlacement = label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT);
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            labelIterator.remove();
            newEdge.getLabels().add(label);
            if (label.hasProperty(InternalProperties.END_LABEL_EDGE)) continue;
            label.setProperty(InternalProperties.END_LABEL_EDGE, oldEdge);
        }
    }
}

