/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security.authentication.oauth;

import java.util.Arrays;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.SecurityCredentials;
import net.sourceforge.plantuml.security.authentication.basicauth.BasicAuthAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.oauth.AbstractOAuth2AccessAuthorizeManager;

public class OAuth2ClientAccessAuthorizeManager
extends AbstractOAuth2AccessAuthorizeManager {
    private final BasicAuthAuthorizeManager basicAuthManager = new BasicAuthAuthorizeManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityAuthentication create(SecurityCredentials credentials) {
        String grantType = credentials.getPropertyStr("grantType");
        String requestScope = credentials.getPropertyStr("scope");
        String accessTokenUri = credentials.getPropertyStr("accessTokenUri");
        String tokenType = credentials.getPropertyStr("tokenType");
        String identifier = credentials.getPropertyStr("credentials.identifier");
        char[] secret = credentials.getPropertyChars("credentials.secret");
        try {
            SecurityAuthentication basicAuth;
            SURL tokenService = SURL.create(accessTokenUri);
            StringBuilder content = new StringBuilder().append("grant_type=").append(this.urlEncode(grantType));
            if (StringUtils.isNotEmpty(requestScope)) {
                content.append("&scope=").append(this.urlEncode(requestScope));
            }
            if (identifier != null) {
                basicAuth = this.basicAuthManager.create(SecurityCredentials.basicAuth(identifier, secret));
                content.append("&client_id").append(this.urlEncode(credentials.getIdentifier())).append("&client_secret").append(this.urlEncode(new String(credentials.getSecret())));
            } else {
                basicAuth = this.basicAuthManager.create(SecurityCredentials.basicAuth(credentials.getIdentifier(), credentials.getSecret()));
            }
            SecurityAuthentication securityAuthentication = this.requestAndCreateAuthFromResponse(credentials.getProxy(), grantType, tokenType, tokenService, content.toString(), basicAuth);
            return securityAuthentication;
        }
        finally {
            if (secret != null && secret.length > 0) {
                Arrays.fill(secret, '*');
            }
        }
    }
}

