/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;

class TextBlockMarged
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;

    TextBlockMarged(TextBlock textBlock, double top, double right, double bottom, double left) {
        this.textBlock = textBlock;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    TextBlockMarged(TextBlock textBlock, ClockwiseTopRightBottomLeft margins) {
        this.textBlock = textBlock;
        this.top = margins.getTop();
        this.right = margins.getRight();
        this.bottom = margins.getBottom();
        this.left = margins.getLeft();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return dim.delta(this.left + this.right, this.top + this.bottom);
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        if (dim.getWidth() > 0.0) {
            ug.draw(UEmpty.create(dim));
            UTranslate translate = new UTranslate(this.left, this.top);
            this.textBlock.drawU(ug.apply(translate));
        }
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        XRectangle2D parent = this.textBlock.getInnerPosition(member, stringBounder);
        if (parent == null) {
            return null;
        }
        UTranslate translate = new UTranslate(this.left, this.top);
        return translate.apply(parent);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder).translateY(this.top);
    }
}

