/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPositionAndErrorsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.model.DiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.TransformableToWarning;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/KotlinConstraintSystemDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/model/TransformableToWarning;", "error", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "report", "", "reporter", "Lorg/jetbrains/kotlin/resolve/calls/model/DiagnosticReporter;", "transformToWarning", "resolution"})
public final class KotlinConstraintSystemDiagnostic
extends KotlinCallDiagnostic
implements TransformableToWarning<KotlinConstraintSystemDiagnostic> {
    @NotNull
    private final ConstraintSystemError error;

    public KotlinConstraintSystemDiagnostic(@NotNull ConstraintSystemError error) {
        Intrinsics.checkNotNullParameter(error, "error");
        super(error.getApplicability());
        this.error = error;
    }

    @NotNull
    public final ConstraintSystemError getError() {
        return this.error;
    }

    @Override
    public void report(@NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        reporter.constraintError(this.error);
    }

    @Override
    @Nullable
    public KotlinConstraintSystemDiagnostic transformToWarning() {
        return this.error instanceof NewConstraintError ? new KotlinConstraintSystemDiagnostic(ConstraintPositionAndErrorsKt.transformToWarning((NewConstraintError)this.error)) : null;
    }
}

