/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;

public class Label
extends Operand {
    public static final Label UNRESCUED_REGION_LABEL = new Label("UNRESCUED_REGION", 0);
    private static final Label GLOBAL_ENSURE_BLOCK_LABEL = new Label("_GLOBAL_ENSURE_BLOCK_", 0);
    public final String prefix;
    public final int id;
    private int targetPC = -1;

    public static Label getGlobalEnsureBlockLabel() {
        return GLOBAL_ENSURE_BLOCK_LABEL.clone();
    }

    public Label(String prefix, int id2) {
        this.prefix = prefix;
        this.id = id2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.LABEL;
    }

    public String toString() {
        return this.prefix + "_" + this.id + ":" + this.targetPC;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public int hashCode() {
        return 11 * (77 + System.identityHashCode(this.prefix)) + this.id;
    }

    public boolean equals(Object o) {
        return o instanceof Label && this.id == ((Label)o).id && this.prefix.equals(((Label)o).prefix);
    }

    public boolean isGlobalEnsureBlockLabel() {
        return this.equals(GLOBAL_ENSURE_BLOCK_LABEL);
    }

    public Label clone() {
        Label newL = new Label(this.prefix, this.id);
        newL.setTargetPC(this.getTargetPC());
        return newL;
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return ii.getRenamedLabel(this);
    }

    public void setTargetPC(int i2) {
        this.targetPC = i2;
    }

    public int getTargetPC() {
        return this.targetPC;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.prefix);
        e.encode(this.id);
    }

    public static Label decode(IRReaderDecoder d) {
        String prefix = d.decodeString();
        int id2 = d.decodeInt();
        if ("_GLOBAL_ENSURE_BLOCK".equals(prefix)) {
            return new Label("_GLOBAL_ENSURE_BLOCK", 0);
        }
        String fullLabel = prefix + "_" + id2;
        if (d.getVars().containsKey(fullLabel)) {
            return (Label)d.getVars().get(fullLabel);
        }
        Label newLabel = new Label(prefix, id2);
        d.getVars().put(fullLabel, newLabel);
        return newLabel;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Label(this);
    }
}

