/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jruby.ParseResult;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class RootNode
extends Node
implements ParseResult {
    private final transient DynamicScope scope;
    private final StaticScope staticScope;
    private final Node bodyNode;
    private final String file;
    private final int coverageMode;

    public RootNode(int line, DynamicScope scope, Node bodyNode, String file2) {
        this(line, scope, bodyNode, file2, 0);
    }

    public RootNode(int line, DynamicScope scope, Node bodyNode, String file2, int coverageMode) {
        super(line, bodyNode.containsVariableAssignment());
        this.scope = scope;
        this.staticScope = scope.getStaticScope();
        this.bodyNode = bodyNode;
        this.file = file2;
        this.coverageMode = coverageMode;
        this.staticScope.setFile(file2);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    @Override
    public DynamicScope getDynamicScope() {
        return this.scope;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getCoverageMode() {
        return this.coverageMode;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }

    @Override
    public boolean executesOnce() {
        return true;
    }

    @Override
    public Object getAST() {
        return this;
    }

    @Override
    public Encoding getEncoding() {
        return null;
    }
}

