/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabeledComponent
extends JPanel {
    JPanel rightPanel;
    String labelStr;
    String valueLabelStr;
    String compoundStr;
    JLabel label;
    JComponent comp;

    public LabeledComponent(String string, JComponent jComponent) {
        this(string, 0, jComponent);
    }

    public LabeledComponent(String string, int n, JComponent jComponent) {
        super(new BorderLayout(6, 6));
        this.labelStr = string;
        this.label = new JLabel(string, 4);
        this.comp = jComponent;
        this.label.setLabelFor(jComponent);
        if (n > 0) {
            this.label.setDisplayedMnemonic(n);
        }
        this.add((Component)this.label, "West");
        this.add((Component)jComponent, "Center");
    }

    public void setLabel(String string) {
        this.labelStr = string;
        this.updateLabel();
    }

    public void setValueLabel(String string) {
        this.valueLabelStr = string;
        this.updateLabel();
    }

    private void updateLabel() {
        String string = this.labelStr;
        this.label.setText(string);
        this.compoundStr = string;
        JComponent jComponent = (JComponent)this.getParent();
        LabeledComponent.layout(jComponent);
    }

    public static void layout(Container container) {
        LabeledComponent labeledComponent;
        int n = 0;
        for (Component component : container.getComponents()) {
            if (!(component instanceof LabeledComponent)) continue;
            labeledComponent = (LabeledComponent)component;
            labeledComponent.label.setPreferredSize(null);
            int n2 = labeledComponent.label.getPreferredSize().width;
            if (n2 <= n) continue;
            n = n2;
        }
        for (Component component : container.getComponents()) {
            if (!(component instanceof LabeledComponent)) continue;
            labeledComponent = (LabeledComponent)component;
            JLabel jLabel = labeledComponent.label;
            int n3 = jLabel.getPreferredSize().height;
            jLabel.setPreferredSize(new Dimension(n, n3));
            jLabel.setHorizontalAlignment(4);
        }
    }
}

