/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class Buffer
implements Readable {
    protected final byte[] workBuf = new byte[8];

    protected Buffer() {
    }

    public abstract int rpos();

    public abstract void rpos(int var1);

    public abstract int wpos();

    public abstract void wpos(int var1);

    public abstract int capacity();

    public abstract byte[] array();

    public abstract byte[] getBytesConsumed();

    public abstract byte[] getBytesConsumed(int var1);

    public byte rawByte(int pos) {
        byte[] data = this.array();
        return data[pos];
    }

    public long rawUInt(int pos) {
        byte[] data = this.array();
        return BufferUtils.getUInt(data, pos, 4);
    }

    public abstract void compact();

    public byte[] getCompactData() {
        int l = this.available();
        if (l > 0) {
            byte[] b = new byte[l];
            System.arraycopy(this.array(), this.rpos(), b, 0, l);
            return b;
        }
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public Buffer clear() {
        return this.clear(true);
    }

    public abstract Buffer clear(boolean var1);

    public boolean isValidMessageStructure(Class<?> ... fieldTypes) {
        return this.isValidMessageStructure(GenericUtils.isEmpty(fieldTypes) ? Collections.emptyList() : Arrays.asList(fieldTypes));
    }

    public boolean isValidMessageStructure(Collection<Class<?>> fieldTypes) {
        if (GenericUtils.isEmpty(fieldTypes)) {
            return true;
        }
        int remainLen = this.available();
        int readOffset = 0;
        for (Class<?> ft : fieldTypes) {
            if (ft == Boolean.TYPE || ft == Boolean.class || ft == Byte.TYPE || ft == Byte.class) {
                if (remainLen < 1) {
                    return false;
                }
                --remainLen;
                ++readOffset;
                continue;
            }
            if (ft == Short.TYPE || ft == Short.class) {
                if (remainLen < 2) {
                    return false;
                }
                remainLen -= 2;
                readOffset += 2;
                continue;
            }
            if (ft == Integer.TYPE || ft == Integer.class) {
                if (remainLen < 4) {
                    return false;
                }
                remainLen -= 4;
                readOffset += 4;
                continue;
            }
            if (ft == Long.TYPE || ft == Long.class) {
                if (remainLen < 8) {
                    return false;
                }
                remainLen -= 8;
                readOffset += 8;
                continue;
            }
            if (ft != byte[].class && ft != String.class) continue;
            if (remainLen < 4) {
                return false;
            }
            this.copyRawBytes(readOffset, this.workBuf, 0, 4);
            readOffset += 4;
            long length = BufferUtils.getUInt(this.workBuf, 0, 4);
            if (length > (long)(remainLen -= 4)) {
                return false;
            }
            remainLen -= (int)length;
            readOffset += (int)length;
        }
        return true;
    }

    protected abstract void copyRawBytes(int var1, byte[] var2, int var3, int var4);

    public String toHex() {
        return BufferUtils.toHex(this.array(), this.rpos(), this.available());
    }

    public void dumpHex(SimplifiedLog logger, String prefix, PropertyResolver resolver) {
        this.dumpHex(logger, BufferUtils.DEFAULT_HEXDUMP_LEVEL, prefix, resolver);
    }

    public void dumpHex(SimplifiedLog logger, Level level, String prefix, PropertyResolver resolver) {
        int cmd;
        byte[] data = this.array();
        int rpos = this.rpos();
        int length = this.available();
        if (length > 0 && Buffer.isSensitiveData(cmd = data[rpos] & 0xFF)) {
            return;
        }
        BufferUtils.dumpHex(logger, level, prefix, resolver, ' ', data, rpos, length);
    }

    private static boolean isSensitiveData(int cmd) {
        switch (cmd) {
            case 50: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    public int getUByte() {
        return this.getByte() & 0xFF;
    }

    public byte getByte() {
        this.ensureAvailable(1);
        this.getRawBytes(this.workBuf, 0, 1);
        return this.workBuf[0];
    }

    public short getShort() {
        this.ensureAvailable(2);
        this.getRawBytes(this.workBuf, 0, 2);
        short v = (short)(this.workBuf[0] << 8 & 0xFF00);
        v = (short)(v | (short)(this.workBuf[1] & 0xFF));
        return v;
    }

    public int getUShort() {
        return this.getShort() & 0xFFFF;
    }

    public int getInt() {
        return (int)this.getUInt();
    }

    public long getUInt() {
        this.ensureAvailable(4);
        this.getRawBytes(this.workBuf, 0, 4);
        return BufferUtils.getUInt(this.workBuf, 0, 4);
    }

    public long getLong() {
        this.ensureAvailable(8);
        this.getRawBytes(this.workBuf, 0, 8);
        long l = (long)this.workBuf[0] << 56 & 0xFF00000000000000L;
        l |= (long)this.workBuf[1] << 48 & 0xFF000000000000L;
        l |= (long)this.workBuf[2] << 40 & 0xFF0000000000L;
        l |= (long)this.workBuf[3] << 32 & 0xFF00000000L;
        l |= (long)this.workBuf[4] << 24 & 0xFF000000L;
        l |= (long)this.workBuf[5] << 16 & 0xFF0000L;
        l |= (long)this.workBuf[6] << 8 & 0xFF00L;
        return l |= (long)this.workBuf[7] & 0xFFL;
    }

    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    public String getString() {
        return this.getString(StandardCharsets.UTF_8);
    }

    public List<String> getNameList() {
        return this.getNameList(StandardCharsets.UTF_8);
    }

    public List<String> getNameList(Charset charset) {
        return this.getNameList(charset, ',');
    }

    public List<String> getNameList(char separator) {
        return this.getNameList(StandardCharsets.UTF_8, separator);
    }

    public List<String> getNameList(Charset charset, char separator) {
        String list = this.getString(charset);
        String[] values = GenericUtils.split(list, separator);
        return GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values);
    }

    public List<OpenSshCertificate.CertificateOption> getCertificateOptions() {
        return this.getCertificateOptions(StandardCharsets.UTF_8);
    }

    public List<OpenSshCertificate.CertificateOption> getCertificateOptions(Charset charset) {
        ArrayList<OpenSshCertificate.CertificateOption> list = new ArrayList<OpenSshCertificate.CertificateOption>();
        if (this.available() > 0) {
            ByteArrayBuffer optionBuffer = new ByteArrayBuffer(this.getBytes());
            while (optionBuffer.available() > 0) {
                String name = ((Buffer)optionBuffer).getString(charset);
                String data = null;
                ByteArrayBuffer dataBuffer = new ByteArrayBuffer(optionBuffer.getBytes());
                if (dataBuffer.available() > 0) {
                    data = GenericUtils.trimToEmpty(((Buffer)dataBuffer).getString(charset));
                    data = data.length() > 0 ? data : null;
                }
                list.add(new OpenSshCertificate.CertificateOption(name, data));
            }
        }
        return list;
    }

    public Collection<String> getStringList(boolean usePrependedLength) {
        return this.getStringList(usePrependedLength, StandardCharsets.UTF_8);
    }

    public Collection<String> getStringList(boolean usePrependedLength, Charset charset) {
        if (usePrependedLength) {
            int count = this.getInt();
            return this.getStringList(count, charset);
        }
        return this.getAvailableStrings(charset);
    }

    public Collection<String> getAvailableStrings() {
        return this.getAvailableStrings(StandardCharsets.UTF_8);
    }

    public Collection<String> getAvailableStrings(Charset charset) {
        LinkedList<String> list = new LinkedList<String>();
        while (this.available() > 0) {
            String s = this.getString(charset);
            list.add(s);
        }
        return list;
    }

    public List<String> getStringList(int count) {
        return this.getStringList(count, StandardCharsets.UTF_8);
    }

    public List<String> getStringList(int count, Charset charset) {
        if (count < 0 || count > 32768) {
            throw new IndexOutOfBoundsException("Illogical string list length: " + count);
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(count);
        for (int index = 1; index <= count; ++index) {
            String s = this.getString(charset);
            list.add(s);
        }
        return list;
    }

    public abstract String getString(Charset var1);

    public BigInteger getMPInt() {
        return new BigInteger(this.getMPIntAsBytes());
    }

    public byte[] getMPIntAsBytes() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        int reqLen = this.getInt();
        int len = this.ensureAvailable(reqLen);
        byte[] b = new byte[len];
        this.getRawBytes(b);
        return b;
    }

    public void getRawBytes(byte[] buf) {
        this.getRawBytes(buf, 0, buf.length);
    }

    public PublicKey getPublicKey() throws SshException {
        return this.getPublicKey(BufferPublicKeyParser.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey(BufferPublicKeyParser<? extends PublicKey> parser) throws SshException {
        int ow = this.wpos();
        int len = this.ensureAvailable(this.getInt());
        int afterKey = this.rpos() + len;
        this.wpos(afterKey);
        try {
            PublicKey publicKey = this.getRawPublicKey(parser);
            return publicKey;
        }
        finally {
            this.wpos(ow);
            this.rpos(afterKey);
        }
    }

    public PublicKey getRawPublicKey() throws SshException {
        return this.getRawPublicKey(BufferPublicKeyParser.DEFAULT);
    }

    public PublicKey getRawPublicKey(BufferPublicKeyParser<? extends PublicKey> parser) throws SshException {
        Objects.requireNonNull(parser, "No key data parser");
        try {
            String keyType = this.getString();
            if (!parser.isKeyTypeSupported(keyType)) {
                throw new NoSuchAlgorithmException("Key type=" + keyType + ") not supported by parser=" + parser);
            }
            return parser.getRawPublicKey(keyType, this);
        }
        catch (GeneralSecurityException e) {
            throw new SshException(e);
        }
    }

    public KeyPair getKeyPair() throws SshException {
        try {
            PrivateKey prv;
            PublicKey pub;
            String keyAlg = this.getString();
            if ("ssh-rsa".equals(keyAlg)) {
                BigInteger e = this.getMPInt();
                BigInteger n = this.getMPInt();
                BigInteger d = this.getMPInt();
                BigInteger qInv = this.getMPInt();
                BigInteger q = this.getMPInt();
                BigInteger p = this.getMPInt();
                BigInteger dP = d.remainder(p.subtract(BigInteger.valueOf(1L)));
                BigInteger dQ = d.remainder(q.subtract(BigInteger.valueOf(1L)));
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                pub = keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
                prv = keyFactory.generatePrivate(new RSAPrivateCrtKeySpec(n, e, d, p, q, dP, dQ, qInv));
            } else if ("ssh-dss".equals(keyAlg)) {
                BigInteger p = this.getMPInt();
                BigInteger q = this.getMPInt();
                BigInteger g = this.getMPInt();
                BigInteger y = this.getMPInt();
                BigInteger x = this.getMPInt();
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
                pub = keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
                prv = keyFactory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g));
            } else {
                if ("ssh-ed25519".equals(keyAlg)) {
                    return SecurityUtils.extractEDDSAKeyPair(this, keyAlg);
                }
                ECCurves curve = ECCurves.fromKeyType(keyAlg);
                if (curve == null) {
                    throw new NoSuchAlgorithmException("Unsupported key pair algorithm: " + keyAlg);
                }
                String curveName = curve.getName();
                ECParameterSpec params = curve.getParameters();
                return this.extractEC(curveName, params);
            }
            return new KeyPair(pub, prv);
        }
        catch (GeneralSecurityException e) {
            throw new SshException(e);
        }
    }

    protected KeyPair extractEC(String expectedCurveName, ECParameterSpec spec) throws GeneralSecurityException {
        ECPoint group;
        String curveName = this.getString();
        if (!expectedCurveName.equals(curveName)) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ") mismatched curve name: " + curveName);
        }
        byte[] groupBytes = this.getBytes();
        BigInteger exponent = this.getMPInt();
        if (spec == null) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ") missing parameters for curve");
        }
        try {
            group = ECCurves.octetStringToEcPoint(groupBytes);
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("extractEC(" + expectedCurveName + ") failed (" + e.getClass().getSimpleName() + ") to decode EC group for curve: " + e.getMessage(), e);
        }
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        PublicKey pubKey = keyFactory.generatePublic(new ECPublicKeySpec(group, spec));
        PrivateKey privKey = keyFactory.generatePrivate(new ECPrivateKeySpec(exponent, spec));
        return new KeyPair(pubKey, privKey);
    }

    public int ensureAvailable(int reqLen) throws BufferException {
        if (reqLen < 0) {
            throw new BufferException("Bad item length: " + reqLen);
        }
        int availLen = this.available();
        if (availLen < reqLen) {
            throw new BufferException("Underflow: requested=" + reqLen + ", available=" + availLen);
        }
        return reqLen;
    }

    public void putByte(byte b) {
        this.ensureCapacity(1);
        this.workBuf[0] = b;
        this.putRawBytes(this.workBuf, 0, 1);
    }

    public void putOptionalBufferedData(Object buffer) {
        if (buffer == null) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            this.putBufferedData(buffer);
        }
    }

    public void putBufferedData(Object buffer) {
        Objects.requireNonNull(buffer, "No buffered data to encode");
        if (buffer instanceof byte[]) {
            this.putBytes((byte[])buffer);
        } else if (buffer instanceof Readable) {
            this.putBuffer((Readable)buffer);
        } else if (buffer instanceof ByteBuffer) {
            this.putBuffer((ByteBuffer)buffer);
        } else {
            throw new IllegalArgumentException("No buffered overload found for " + (buffer == null ? null : buffer.getClass().getName()));
        }
    }

    public void putBuffer(Readable buffer) {
        this.putBuffer(buffer, true);
    }

    public abstract int putBuffer(Readable var1, boolean var2);

    public abstract void putBuffer(ByteBuffer var1);

    public void putShort(int i) {
        this.ensureCapacity(2);
        this.workBuf[0] = (byte)(i >> 8);
        this.workBuf[1] = (byte)i;
        this.putRawBytes(this.workBuf, 0, 2);
    }

    public void putInt(long i) {
        BufferUtils.validateInt32Value(i, "Invalid INT32 value: %d");
        this.ensureCapacity(4);
        BufferUtils.putUInt(i, this.workBuf, 0, 4);
        this.putRawBytes(this.workBuf, 0, 4);
    }

    public void putUInt(long i) {
        BufferUtils.validateUint32Value(i, "Invalid UINT32 value: %d");
        this.ensureCapacity(4);
        BufferUtils.putUInt(i, this.workBuf, 0, 4);
        this.putRawBytes(this.workBuf, 0, 4);
    }

    public void putLong(long i) {
        this.ensureCapacity(8);
        this.workBuf[0] = (byte)(i >> 56);
        this.workBuf[1] = (byte)(i >> 48);
        this.workBuf[2] = (byte)(i >> 40);
        this.workBuf[3] = (byte)(i >> 32);
        this.workBuf[4] = (byte)(i >> 24);
        this.workBuf[5] = (byte)(i >> 16);
        this.workBuf[6] = (byte)(i >> 8);
        this.workBuf[7] = (byte)i;
        this.putRawBytes(this.workBuf, 0, 8);
    }

    public void putBoolean(boolean b) {
        this.putByte(b ? (byte)1 : 0);
    }

    public void putAndWipeBytes(byte[] b) {
        this.putAndWipeBytes(b, 0, NumberUtils.length(b));
    }

    public void putAndWipeBytes(byte[] b, int off, int len) {
        this.putBytes(b, off, len);
        int pos = off;
        for (int index = 0; index < len; ++index) {
            b[pos] = 0;
            ++pos;
        }
    }

    public void putBytes(byte[] b) {
        this.putBytes(b, 0, NumberUtils.length(b));
    }

    public void putBytes(byte[] b, int off, int len) {
        this.putUInt(len);
        this.putRawBytes(b, off, len);
    }

    public void putStringList(Collection<?> objects, boolean prependLength) {
        this.putStringList(objects, StandardCharsets.UTF_8, prependLength);
    }

    public void putStringList(Collection<?> objects, Charset charset, boolean prependLength) {
        int numObjects = GenericUtils.size(objects);
        if (prependLength) {
            this.putUInt(numObjects);
        }
        if (numObjects <= 0) {
            return;
        }
        for (Object o : objects) {
            String s = Objects.toString(o, null);
            this.putString(s, charset);
        }
    }

    public void putCertificateOptions(List<OpenSshCertificate.CertificateOption> options) {
        this.putCertificateOptions(options, StandardCharsets.UTF_8);
    }

    public void putCertificateOptions(List<OpenSshCertificate.CertificateOption> options, Charset charset) {
        int numObjects = GenericUtils.size(options);
        if (numObjects <= 0) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
            return;
        }
        ByteArrayBuffer optionBuffer = new ByteArrayBuffer();
        for (OpenSshCertificate.CertificateOption option : options) {
            optionBuffer.putString(option.getName(), charset);
            if (GenericUtils.isEmpty(option.getData())) {
                optionBuffer.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
                continue;
            }
            ByteArrayBuffer dataBuffer = new ByteArrayBuffer();
            dataBuffer.putString(option.getData(), charset);
            optionBuffer.putBytes(dataBuffer.getCompactData());
        }
        this.putBytes(optionBuffer.getCompactData());
    }

    public void putNameList(Collection<String> names) {
        this.putNameList(names, StandardCharsets.UTF_8);
    }

    public void putNameList(Collection<String> names, Charset charset) {
        this.putNameList(names, charset, ',');
    }

    public void putNameList(Collection<String> names, char separator) {
        this.putNameList(names, StandardCharsets.UTF_8, separator);
    }

    public void putNameList(Collection<String> names, Charset charset, char separator) {
        String list = GenericUtils.join(names, separator);
        this.putString(list, charset);
    }

    public void putString(String string) {
        this.putString(string, StandardCharsets.UTF_8);
    }

    public void putString(String string, Charset charset) {
        if (GenericUtils.isEmpty(string)) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            byte[] bytes = string.getBytes(charset);
            this.putBytes(bytes);
        }
    }

    public void putAndWipeChars(char[] chars) {
        this.putAndWipeChars(chars, 0, GenericUtils.length(chars));
    }

    public void putAndWipeChars(char[] chars, int offset, int len) {
        this.putAndWipeChars(chars, offset, len, StandardCharsets.UTF_8);
    }

    public void putAndWipeChars(char[] chars, Charset charset) {
        this.putAndWipeChars(chars, 0, GenericUtils.length(chars), charset);
    }

    public void putAndWipeChars(char[] chars, int offset, int len, Charset charset) {
        this.putChars(chars, offset, len, charset);
        int pos = offset;
        int index = 0;
        while (index < len) {
            chars[pos] = '\u0000';
            ++index;
            ++pos;
        }
    }

    public void putChars(char[] chars) {
        this.putChars(chars, 0, GenericUtils.length(chars));
    }

    public void putChars(char[] chars, int offset, int len) {
        this.putChars(chars, offset, len, StandardCharsets.UTF_8);
    }

    public void putChars(char[] chars, Charset charset) {
        this.putChars(chars, 0, GenericUtils.length(chars), charset);
    }

    public void putChars(char[] chars, int offset, int len, Charset charset) {
        if (len <= 0) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            CharBuffer charBuf = CharBuffer.wrap(chars, offset, len);
            ByteBuffer byteBuf = charset.encode(charBuf);
            this.putBuffer(byteBuf);
        }
    }

    public void putMPInt(BigInteger bigint) {
        this.putMPInt(bigint.toByteArray());
    }

    public void putMPInt(byte[] mpInt) {
        if ((mpInt[0] & 0x80) != 0) {
            this.putUInt(mpInt.length + 1);
            this.putByte((byte)0);
        } else {
            this.putUInt(mpInt.length);
        }
        this.putRawBytes(mpInt);
    }

    public void putRawBytes(byte[] d) {
        this.putRawBytes(d, 0, d.length);
    }

    public abstract void putRawBytes(byte[] var1, int var2, int var3);

    public void putPublicKey(PublicKey key) {
        int ow = this.wpos();
        this.putUInt(0L);
        int ow1 = this.wpos();
        this.putRawPublicKey(key);
        int ow2 = this.wpos();
        this.wpos(ow);
        this.putUInt(ow2 - ow1);
        this.wpos(ow2);
    }

    public void putRawPublicKey(PublicKey key) {
        this.putString(KeyUtils.getKeyType(key));
        this.putRawPublicKeyBytes(key);
    }

    public void putRawPublicKeyBytes(PublicKey key) {
        Objects.requireNonNull(key, "No key");
        if (key instanceof UnsupportedSshPublicKey) {
            this.putRawBytes(((UnsupportedSshPublicKey)key).getKeyData());
        } else if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)key;
            this.putMPInt(rsaPub.getPublicExponent());
            this.putMPInt(rsaPub.getModulus());
        } else if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)key;
            DSAParams dsaParams = dsaPub.getParams();
            this.putMPInt(dsaParams.getP());
            this.putMPInt(dsaParams.getQ());
            this.putMPInt(dsaParams.getG());
            this.putMPInt(dsaPub.getY());
        } else if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECParameterSpec ecParams = ecKey.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecParams);
            if (curve == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            byte[] ecPoint = ECCurves.encodeECPoint(ecKey.getW(), ecParams);
            this.putString(curve.getName());
            this.putBytes(ecPoint);
        } else if ("EdDSA".equals(key.getAlgorithm()) || "Ed25519".equals(key.getAlgorithm())) {
            SecurityUtils.putRawEDDSAPublicKey(this, key);
        } else if (key instanceof SecurityKeyPublicKey) {
            this.putRawPublicKeyBytes((PublicKey)((SecurityKeyPublicKey)key).getDelegatePublicKey());
            this.putString(((SecurityKeyPublicKey)key).getAppName());
        } else if (key instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key;
            this.putBytes(cert.getNonce());
            this.putRawPublicKeyBytes(cert.getCertPubKey());
            this.putLong(cert.getSerial());
            this.putUInt(cert.getType().getCode());
            this.putString(cert.getId());
            ByteArrayBuffer tmpBuffer = new ByteArrayBuffer();
            tmpBuffer.putStringList(cert.getPrincipals(), false);
            this.putBytes(tmpBuffer.getCompactData());
            this.putLong(cert.getValidAfter());
            this.putLong(cert.getValidBefore());
            this.putCertificateOptions(cert.getCriticalOptions());
            this.putCertificateOptions(cert.getExtensions());
            this.putString(cert.getReserved());
            tmpBuffer = new ByteArrayBuffer();
            tmpBuffer.putRawPublicKey(cert.getCaPubKey());
            this.putBytes(tmpBuffer.getCompactData());
            if (cert.getSignature() != null) {
                this.putBytes(cert.getSignature());
            }
        } else {
            throw new BufferException("Unsupported raw public key algorithm: " + key.getAlgorithm());
        }
    }

    public void putKeyPair(KeyPair kp) {
        PublicKey pubKey = kp.getPublic();
        PrivateKey prvKey = kp.getPrivate();
        if (prvKey instanceof RSAPrivateCrtKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)pubKey;
            RSAPrivateCrtKey rsaPrv = (RSAPrivateCrtKey)prvKey;
            this.putString("ssh-rsa");
            this.putMPInt(rsaPub.getPublicExponent());
            this.putMPInt(rsaPub.getModulus());
            this.putMPInt(rsaPrv.getPrivateExponent());
            this.putMPInt(rsaPrv.getCrtCoefficient());
            this.putMPInt(rsaPrv.getPrimeQ());
            this.putMPInt(rsaPrv.getPrimeP());
        } else if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)pubKey;
            DSAParams dsaParams = dsaPub.getParams();
            DSAPrivateKey dsaPrv = (DSAPrivateKey)prvKey;
            this.putString("ssh-dss");
            this.putMPInt(dsaParams.getP());
            this.putMPInt(dsaParams.getQ());
            this.putMPInt(dsaParams.getG());
            this.putMPInt(dsaPub.getY());
            this.putMPInt(dsaPrv.getX());
        } else if (pubKey instanceof ECPublicKey) {
            ECPublicKey ecPub = (ECPublicKey)pubKey;
            ECPrivateKey ecPriv = (ECPrivateKey)prvKey;
            ECParameterSpec ecParams = ecPub.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecParams);
            if (curve == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            byte[] ecPoint = ECCurves.encodeECPoint(ecPub.getW(), ecParams);
            this.putString(curve.getKeyType());
            this.putString(curve.getName());
            this.putBytes(ecPoint);
            this.putMPInt(ecPriv.getS());
        } else if ("EdDSA".equals(pubKey.getAlgorithm())) {
            SecurityUtils.putEDDSAKeyPair(this, pubKey, prvKey);
        } else {
            throw new BufferException("Unsupported key pair algorithm: " + pubKey.getAlgorithm());
        }
    }

    public Buffer ensureCapacity(int capacity) {
        return this.ensureCapacity(capacity, BufferUtils.DEFAULT_BUFFER_GROWTH_FACTOR);
    }

    public abstract Buffer ensureCapacity(int var1, IntUnaryOperator var2);

    protected abstract int size();

    public String toString() {
        return this.getClass().getSimpleName() + "[rpos=" + this.rpos() + ", wpos=" + this.wpos() + ", size=" + this.size() + "]";
    }
}

