/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.collect.ImmutableList;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.SystemClassLoaderSpec;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.ClientOwnedClassLoaderSpec;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultPayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPayloadClassLoaderRegistry.class);
    private final PayloadClassLoaderFactory classLoaderFactory;
    private final ClassLoaderCache cache;
    private final ClassLoaderToDetailsTransformer detailsToClassLoader = new ClassLoaderToDetailsTransformer();
    private final DetailsToClassLoaderTransformer classLoaderToDetails = new DetailsToClassLoaderTransformer();

    public DefaultPayloadClassLoaderRegistry(ClassLoaderCache cache, PayloadClassLoaderFactory payloadClassLoaderFactory) {
        this.cache = cache;
        this.classLoaderFactory = payloadClassLoaderFactory;
    }

    @Override
    public SerializeMap newSerializeSession() {
        return new SerializeMap(){
            final Map<ClassLoader, Short> classLoaderIds = new HashMap<ClassLoader, Short>();
            final Map<Short, ClassLoaderDetails> classLoaderDetails = new HashMap<Short, ClassLoaderDetails>();

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                Short id = this.classLoaderIds.get(classLoader);
                if (id != null) {
                    return id;
                }
                if (this.classLoaderIds.size() == Short.MAX_VALUE) {
                    throw new UnsupportedOperationException();
                }
                ClassLoaderDetails details = DefaultPayloadClassLoaderRegistry.this.getDetails(classLoader);
                id = (short)(this.classLoaderIds.size() + 1);
                this.classLoaderIds.put(classLoader, id);
                this.classLoaderDetails.put(id, details);
                return id;
            }

            @Override
            public void collectClassLoaderDefinitions(Map<Short, ClassLoaderDetails> details) {
                details.putAll(this.classLoaderDetails);
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        return new DeserializeMap(){

            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                ClassLoader classLoader = DefaultPayloadClassLoaderRegistry.this.getClassLoader(classLoaderDetails);
                return Class.forName(className, false, classLoader);
            }
        };
    }

    private ClassLoader getClassLoader(ClassLoaderDetails details) {
        ClassLoader classLoader = this.cache.getClassLoader(details, this.detailsToClassLoader);
        if (details.spec instanceof ClientOwnedClassLoaderSpec) {
            ClientOwnedClassLoaderSpec spec = (ClientOwnedClassLoaderSpec)details.spec;
            VisitableURLClassLoader urlClassLoader = (VisitableURLClassLoader)classLoader;
            try {
                Set<URI> currentClassPath = DefaultPayloadClassLoaderRegistry.uris(urlClassLoader);
                for (URI uri : spec.getClasspath()) {
                    if (currentClassPath.contains(uri)) continue;
                    urlClassLoader.addURL(uri.toURL());
                }
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return classLoader;
    }

    private static Set<URI> uris(VisitableURLClassLoader classLoader) throws URISyntaxException {
        URL[] urls = classLoader.getURLs();
        HashSet<URI> uris = new HashSet<URI>(urls.length);
        for (URL url : urls) {
            uris.add(url.toURI());
        }
        return uris;
    }

    private ClassLoaderDetails getDetails(ClassLoader classLoader) {
        return this.cache.getDetails(classLoader, this.classLoaderToDetails);
    }

    private class ClassLoaderToDetailsTransformer
    implements ClassLoaderCache.Transformer<ClassLoader, ClassLoaderDetails> {
        private ClassLoaderToDetailsTransformer() {
        }

        @Override
        public ClassLoader transform(ClassLoaderDetails details) {
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            for (ClassLoaderDetails parentDetails : details.parents) {
                parents.add(DefaultPayloadClassLoaderRegistry.this.getClassLoader(parentDetails));
            }
            if (parents.isEmpty()) {
                parents.add(DefaultPayloadClassLoaderRegistry.this.classLoaderFactory.getClassLoaderFor(SystemClassLoaderSpec.INSTANCE, (List<? extends ClassLoader>)ImmutableList.of()));
            }
            LOGGER.info("Creating ClassLoader {} from {} and {}.", new Object[]{details.uuid, details.spec, parents});
            return DefaultPayloadClassLoaderRegistry.this.classLoaderFactory.getClassLoaderFor(details.spec, parents);
        }
    }

    private class DetailsToClassLoaderTransformer
    implements ClassLoaderCache.Transformer<ClassLoaderDetails, ClassLoader> {
        private DetailsToClassLoaderTransformer() {
        }

        @Override
        public ClassLoaderDetails transform(ClassLoader classLoader) {
            ClassLoaderSpecVisitor visitor = new ClassLoaderSpecVisitor(classLoader);
            visitor.visit(classLoader);
            if (visitor.spec == null) {
                visitor.spec = visitor.classPath == null ? SystemClassLoaderSpec.INSTANCE : new VisitableURLClassLoader.Spec("unknown-loader", CollectionUtils.toList((Object[])visitor.classPath));
            }
            UUID uuid = UUID.randomUUID();
            ClassLoaderDetails details = new ClassLoaderDetails(uuid, visitor.spec);
            for (ClassLoader parent : visitor.parents) {
                details.parents.add(DefaultPayloadClassLoaderRegistry.this.getDetails(parent));
            }
            return details;
        }
    }

    private static class ClassLoaderSpecVisitor
    extends ClassLoaderVisitor {
        final ClassLoader classLoader;
        final List<ClassLoader> parents = new ArrayList<ClassLoader>();
        ClassLoaderSpec spec;
        URL[] classPath;

        public ClassLoaderSpecVisitor(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void visit(ClassLoader candidate) {
            if (candidate == this.classLoader) {
                super.visit(candidate);
            } else {
                this.parents.add(candidate);
            }
        }

        public void visitClassPath(URL[] classPath) {
            this.classPath = classPath;
        }

        public void visitSpec(ClassLoaderSpec spec) {
            this.spec = spec;
        }
    }
}

