/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.HasAnnotationMetadata;

public abstract class AbstractHasAnnotationMetadata
implements HasAnnotationMetadata {
    protected final Method method;
    protected final TypeToken<?> declaredType;
    protected final ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory;
    protected final ImmutableMap<Class<? extends Annotation>, Annotation> annotationsByType;

    public AbstractHasAnnotationMetadata(Method method, ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory) {
        this.method = method;
        method.setAccessible(true);
        this.declaredType = TypeToken.of((Type)method.getGenericReturnType());
        this.annotationsByCategory = annotationsByCategory;
        this.annotationsByType = AbstractHasAnnotationMetadata.collectAnnotationsByType(annotationsByCategory);
    }

    private static ImmutableMap<Class<? extends Annotation>, Annotation> collectAnnotationsByType(ImmutableMap<AnnotationCategory, Annotation> annotations) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)annotations.size());
        for (Annotation value : annotations.values()) {
            builder.put(value.annotationType(), (Object)value);
        }
        return builder.build();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationsByType.containsKey(annotationType);
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return Optional.ofNullable((Annotation)Cast.uncheckedCast((Object)this.annotationsByType.get(annotationType)));
    }

    @Override
    public ImmutableMap<AnnotationCategory, Annotation> getAnnotationsByCategory() {
        return this.annotationsByCategory;
    }

    @Override
    public TypeToken<?> getDeclaredReturnType() {
        return this.declaredType;
    }
}

