﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qbusiness/QBusinessRequest.h>
#include <aws/qbusiness/QBusiness_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QBusiness {
namespace Model {

/**
 */
class GetDataAccessorRequest : public QBusinessRequest {
 public:
  AWS_QBUSINESS_API GetDataAccessorRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetDataAccessor"; }

  AWS_QBUSINESS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the Amazon Q Business application.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  GetDataAccessorRequest& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the data accessor to retrieve.</p>
   */
  inline const Aws::String& GetDataAccessorId() const { return m_dataAccessorId; }
  inline bool DataAccessorIdHasBeenSet() const { return m_dataAccessorIdHasBeenSet; }
  template <typename DataAccessorIdT = Aws::String>
  void SetDataAccessorId(DataAccessorIdT&& value) {
    m_dataAccessorIdHasBeenSet = true;
    m_dataAccessorId = std::forward<DataAccessorIdT>(value);
  }
  template <typename DataAccessorIdT = Aws::String>
  GetDataAccessorRequest& WithDataAccessorId(DataAccessorIdT&& value) {
    SetDataAccessorId(std::forward<DataAccessorIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_dataAccessorId;
  bool m_applicationIdHasBeenSet = false;
  bool m_dataAccessorIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
