﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackagev2/Mediapackagev2_EXPORTS.h>
#include <aws/mediapackagev2/model/ConflictExceptionType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace mediapackagev2 {
namespace Model {

/**
 * <p>Updating or deleting this resource can cause an inconsistent
 * state.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ConflictException">AWS
 * API Reference</a></p>
 */
class ConflictException {
 public:
  AWS_MEDIAPACKAGEV2_API ConflictException() = default;
  AWS_MEDIAPACKAGEV2_API ConflictException(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEV2_API ConflictException& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  ConflictException& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of ConflictException.</p>
   */
  inline ConflictExceptionType GetConflictExceptionType() const { return m_conflictExceptionType; }
  inline bool ConflictExceptionTypeHasBeenSet() const { return m_conflictExceptionTypeHasBeenSet; }
  inline void SetConflictExceptionType(ConflictExceptionType value) {
    m_conflictExceptionTypeHasBeenSet = true;
    m_conflictExceptionType = value;
  }
  inline ConflictException& WithConflictExceptionType(ConflictExceptionType value) {
    SetConflictExceptionType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_message;

  ConflictExceptionType m_conflictExceptionType{ConflictExceptionType::NOT_SET};
  bool m_messageHasBeenSet = false;
  bool m_conflictExceptionTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace mediapackagev2
}  // namespace Aws
