﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/macie2/Macie2_EXPORTS.h>

namespace Aws {
namespace Macie2 {
namespace Model {
enum class FindingActionType { NOT_SET, AWS_API_CALL };

namespace FindingActionTypeMapper {
AWS_MACIE2_API FindingActionType GetFindingActionTypeForName(const Aws::String& name);

AWS_MACIE2_API Aws::String GetNameForFindingActionType(FindingActionType value);
}  // namespace FindingActionTypeMapper
}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
