﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindingsResult.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>An object that contains information on the status of all Malware Protection
 * data source for an organization.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/OrganizationMalwareProtectionConfigurationResult">AWS
 * API Reference</a></p>
 */
class OrganizationMalwareProtectionConfigurationResult {
 public:
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfigurationResult() = default;
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API OrganizationMalwareProtectionConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Describes the configuration for scanning EC2 instances with findings for an
   * organization.</p>
   */
  inline const OrganizationScanEc2InstanceWithFindingsResult& GetScanEc2InstanceWithFindings() const {
    return m_scanEc2InstanceWithFindings;
  }
  inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }
  template <typename ScanEc2InstanceWithFindingsT = OrganizationScanEc2InstanceWithFindingsResult>
  void SetScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    m_scanEc2InstanceWithFindingsHasBeenSet = true;
    m_scanEc2InstanceWithFindings = std::forward<ScanEc2InstanceWithFindingsT>(value);
  }
  template <typename ScanEc2InstanceWithFindingsT = OrganizationScanEc2InstanceWithFindingsResult>
  OrganizationMalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    SetScanEc2InstanceWithFindings(std::forward<ScanEc2InstanceWithFindingsT>(value));
    return *this;
  }
  ///@}
 private:
  OrganizationScanEc2InstanceWithFindingsResult m_scanEc2InstanceWithFindings;
  bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
