﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class MalwareProtectionScanStatus { NOT_SET, RUNNING, COMPLETED, COMPLETED_WITH_ISSUES, FAILED, SKIPPED };

namespace MalwareProtectionScanStatusMapper {
AWS_GUARDDUTY_API MalwareProtectionScanStatus GetMalwareProtectionScanStatusForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForMalwareProtectionScanStatus(MalwareProtectionScanStatus value);
}  // namespace MalwareProtectionScanStatusMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
