﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/entityresolution/EntityResolution_EXPORTS.h>
#include <aws/entityresolution/model/IncrementalRunConfig.h>
#include <aws/entityresolution/model/InputSource.h>
#include <aws/entityresolution/model/OutputSource.h>
#include <aws/entityresolution/model/ResolutionTechniques.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EntityResolution {
namespace Model {
class GetMatchingWorkflowResult {
 public:
  AWS_ENTITYRESOLUTION_API GetMatchingWorkflowResult() = default;
  AWS_ENTITYRESOLUTION_API GetMatchingWorkflowResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ENTITYRESOLUTION_API GetMatchingWorkflowResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the workflow.</p>
   */
  inline const Aws::String& GetWorkflowName() const { return m_workflowName; }
  template <typename WorkflowNameT = Aws::String>
  void SetWorkflowName(WorkflowNameT&& value) {
    m_workflowNameHasBeenSet = true;
    m_workflowName = std::forward<WorkflowNameT>(value);
  }
  template <typename WorkflowNameT = Aws::String>
  GetMatchingWorkflowResult& WithWorkflowName(WorkflowNameT&& value) {
    SetWorkflowName(std::forward<WorkflowNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN (Amazon Resource Name) that Entity Resolution generated for the
   * <code>MatchingWorkflow</code>.</p>
   */
  inline const Aws::String& GetWorkflowArn() const { return m_workflowArn; }
  template <typename WorkflowArnT = Aws::String>
  void SetWorkflowArn(WorkflowArnT&& value) {
    m_workflowArnHasBeenSet = true;
    m_workflowArn = std::forward<WorkflowArnT>(value);
  }
  template <typename WorkflowArnT = Aws::String>
  GetMatchingWorkflowResult& WithWorkflowArn(WorkflowArnT&& value) {
    SetWorkflowArn(std::forward<WorkflowArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the workflow.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetMatchingWorkflowResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>InputSource</code> objects, which have the fields
   * <code>InputSourceARN</code> and <code>SchemaName</code>.</p>
   */
  inline const Aws::Vector<InputSource>& GetInputSourceConfig() const { return m_inputSourceConfig; }
  template <typename InputSourceConfigT = Aws::Vector<InputSource>>
  void SetInputSourceConfig(InputSourceConfigT&& value) {
    m_inputSourceConfigHasBeenSet = true;
    m_inputSourceConfig = std::forward<InputSourceConfigT>(value);
  }
  template <typename InputSourceConfigT = Aws::Vector<InputSource>>
  GetMatchingWorkflowResult& WithInputSourceConfig(InputSourceConfigT&& value) {
    SetInputSourceConfig(std::forward<InputSourceConfigT>(value));
    return *this;
  }
  template <typename InputSourceConfigT = InputSource>
  GetMatchingWorkflowResult& AddInputSourceConfig(InputSourceConfigT&& value) {
    m_inputSourceConfigHasBeenSet = true;
    m_inputSourceConfig.emplace_back(std::forward<InputSourceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>OutputSource</code> objects, each of which contains fields
   * <code>outputS3Path</code>, <code>applyNormalization</code>, <code>KMSArn</code>,
   * and <code>output</code>.</p>
   */
  inline const Aws::Vector<OutputSource>& GetOutputSourceConfig() const { return m_outputSourceConfig; }
  template <typename OutputSourceConfigT = Aws::Vector<OutputSource>>
  void SetOutputSourceConfig(OutputSourceConfigT&& value) {
    m_outputSourceConfigHasBeenSet = true;
    m_outputSourceConfig = std::forward<OutputSourceConfigT>(value);
  }
  template <typename OutputSourceConfigT = Aws::Vector<OutputSource>>
  GetMatchingWorkflowResult& WithOutputSourceConfig(OutputSourceConfigT&& value) {
    SetOutputSourceConfig(std::forward<OutputSourceConfigT>(value));
    return *this;
  }
  template <typename OutputSourceConfigT = OutputSource>
  GetMatchingWorkflowResult& AddOutputSourceConfig(OutputSourceConfigT&& value) {
    m_outputSourceConfigHasBeenSet = true;
    m_outputSourceConfig.emplace_back(std::forward<OutputSourceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An object which defines the <code>resolutionType</code> and the
   * <code>ruleBasedProperties</code>.</p>
   */
  inline const ResolutionTechniques& GetResolutionTechniques() const { return m_resolutionTechniques; }
  template <typename ResolutionTechniquesT = ResolutionTechniques>
  void SetResolutionTechniques(ResolutionTechniquesT&& value) {
    m_resolutionTechniquesHasBeenSet = true;
    m_resolutionTechniques = std::forward<ResolutionTechniquesT>(value);
  }
  template <typename ResolutionTechniquesT = ResolutionTechniques>
  GetMatchingWorkflowResult& WithResolutionTechniques(ResolutionTechniquesT&& value) {
    SetResolutionTechniques(std::forward<ResolutionTechniquesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when the workflow was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  GetMatchingWorkflowResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when the workflow was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  GetMatchingWorkflowResult& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An object which defines an incremental run type and has only
   * <code>incrementalRunType</code> as a field.</p>
   */
  inline const IncrementalRunConfig& GetIncrementalRunConfig() const { return m_incrementalRunConfig; }
  template <typename IncrementalRunConfigT = IncrementalRunConfig>
  void SetIncrementalRunConfig(IncrementalRunConfigT&& value) {
    m_incrementalRunConfigHasBeenSet = true;
    m_incrementalRunConfig = std::forward<IncrementalRunConfigT>(value);
  }
  template <typename IncrementalRunConfigT = IncrementalRunConfig>
  GetMatchingWorkflowResult& WithIncrementalRunConfig(IncrementalRunConfigT&& value) {
    SetIncrementalRunConfig(std::forward<IncrementalRunConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
   * this role to access Amazon Web Services resources on your behalf.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  GetMatchingWorkflowResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags used to organize, track, or control access for this resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetMatchingWorkflowResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetMatchingWorkflowResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMatchingWorkflowResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workflowName;

  Aws::String m_workflowArn;

  Aws::String m_description;

  Aws::Vector<InputSource> m_inputSourceConfig;

  Aws::Vector<OutputSource> m_outputSourceConfig;

  ResolutionTechniques m_resolutionTechniques;

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_updatedAt{};

  IncrementalRunConfig m_incrementalRunConfig;

  Aws::String m_roleArn;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_requestId;
  bool m_workflowNameHasBeenSet = false;
  bool m_workflowArnHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_inputSourceConfigHasBeenSet = false;
  bool m_outputSourceConfigHasBeenSet = false;
  bool m_resolutionTechniquesHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_updatedAtHasBeenSet = false;
  bool m_incrementalRunConfigHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EntityResolution
}  // namespace Aws
