﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {
class CreateStudioResult {
 public:
  AWS_EMR_API CreateStudioResult() = default;
  AWS_EMR_API CreateStudioResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EMR_API CreateStudioResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the Amazon EMR Studio.</p>
   */
  inline const Aws::String& GetStudioId() const { return m_studioId; }
  template <typename StudioIdT = Aws::String>
  void SetStudioId(StudioIdT&& value) {
    m_studioIdHasBeenSet = true;
    m_studioId = std::forward<StudioIdT>(value);
  }
  template <typename StudioIdT = Aws::String>
  CreateStudioResult& WithStudioId(StudioIdT&& value) {
    SetStudioId(std::forward<StudioIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique Studio access URL.</p>
   */
  inline const Aws::String& GetUrl() const { return m_url; }
  template <typename UrlT = Aws::String>
  void SetUrl(UrlT&& value) {
    m_urlHasBeenSet = true;
    m_url = std::forward<UrlT>(value);
  }
  template <typename UrlT = Aws::String>
  CreateStudioResult& WithUrl(UrlT&& value) {
    SetUrl(std::forward<UrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateStudioResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_studioId;

  Aws::String m_url;

  Aws::String m_requestId;
  bool m_studioIdHasBeenSet = false;
  bool m_urlHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
