/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.pbe;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.RC532Engine;
import org.bouncycastle.crypto.engines.RC564Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.crypto.params.RC5Parameters;
import org.cryptacular.CryptUtil;
import org.cryptacular.pbe.AbstractEncryptionScheme;
import org.cryptacular.pbe.PBES2Algorithm;
import org.cryptacular.spec.DigestSpec;

public class PBES2EncryptionScheme
extends AbstractEncryptionScheme {
    private static final Map<ASN1ObjectIdentifier, DigestSpec> HMAC_ID_TO_DIGEST_SPEC_MAP = new HashMap<ASN1ObjectIdentifier, DigestSpec>();
    private int keyLength;

    public PBES2EncryptionScheme(PBES2Parameters params, char[] password) {
        DigestSpec digestSpec;
        CryptUtil.assertNotNullArg(params, "Parameters cannot be null");
        PBKDF2Params kdfParams = PBKDF2Params.getInstance((Object)params.getKeyDerivationFunc().getParameters());
        byte[] salt = kdfParams.getSalt();
        int iterations = kdfParams.getIterationCount().intValue();
        if (kdfParams.getKeyLength() != null) {
            this.keyLength = kdfParams.getKeyLength().intValue() * 8;
        }
        if ((digestSpec = HMAC_ID_TO_DIGEST_SPEC_MAP.get(kdfParams.getPrf().getAlgorithm())) == null) {
            throw new IllegalArgumentException("Unsupported PBKDF2 PRF HMAC algorithm");
        }
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(digestSpec.newInstance());
        generator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])password), salt, iterations);
        this.initCipher(generator, params.getEncryptionScheme());
    }

    private void initCipher(PKCS5S2ParametersGenerator generator, EncryptionScheme scheme) {
        PBES2Algorithm alg = PBES2Algorithm.fromOid(scheme.getAlgorithm().getId());
        if (this.keyLength == 0) {
            this.keyLength = alg.getKeySize();
        }
        byte[] iv = null;
        CipherParameters cipherParameters = generator.generateDerivedParameters(this.keyLength);
        switch (alg) {
            case RC2: {
                this.setCipher(alg.getCipherSpec().newInstance());
                ASN1Sequence rc2Params = ASN1Sequence.getInstance((Object)scheme.getParameters());
                if (rc2Params.size() <= 1) break;
                cipherParameters = new RC2Parameters(((KeyParameter)cipherParameters).getKey(), ASN1Integer.getInstance((Object)rc2Params.getObjectAt(0)).getValue().intValue());
                iv = ASN1OctetString.getInstance((Object)rc2Params.getObjectAt(0)).getOctets();
                break;
            }
            case RC5: {
                ASN1Sequence rc5Params = ASN1Sequence.getInstance((Object)scheme.getParameters());
                int rounds = ASN1Integer.getInstance((Object)rc5Params.getObjectAt(1)).getValue().intValue();
                int blockSize = ASN1Integer.getInstance((Object)rc5Params.getObjectAt(2)).getValue().intValue();
                if (blockSize == 64) {
                    this.setCipher((BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)new RC564Engine()), (BlockCipherPadding)new PKCS7Padding()));
                } else if (blockSize == 32) {
                    this.setCipher((BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)new RC532Engine()), (BlockCipherPadding)new PKCS7Padding()));
                } else {
                    throw new IllegalArgumentException("Invalid RC5 block size: " + blockSize);
                }
                cipherParameters = new RC5Parameters(((KeyParameter)cipherParameters).getKey(), rounds);
                if (rc5Params.size() <= 3) break;
                iv = ASN1OctetString.getInstance((Object)rc5Params.getObjectAt(3)).getOctets();
                break;
            }
            default: {
                this.setCipher(alg.getCipherSpec().newInstance());
                iv = ASN1OctetString.getInstance((Object)scheme.getParameters()).getOctets();
            }
        }
        if (iv != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, iv);
        }
        this.setCipherParameters(cipherParameters);
    }

    static {
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(PKCSObjectIdentifiers.id_hmacWithSHA1, new DigestSpec("SHA1"));
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(PKCSObjectIdentifiers.id_hmacWithSHA256, new DigestSpec("SHA256"));
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(PKCSObjectIdentifiers.id_hmacWithSHA512, new DigestSpec("SHA512"));
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, new DigestSpec("SHA3", 256));
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, new DigestSpec("SHA3", 384));
        HMAC_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, new DigestSpec("SHA3", 512));
    }
}

