/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.cryptacular.CryptUtil;
import org.cryptacular.util.NonceUtil;

public final class SecretKeyGenerator {
    private static final int MAX_KEY_LENGTH = CryptUtil.parseInt(System.getProperty("org.cryptacular.generator.maxSecretKeyLength", "1024"), i -> i > 0, 1024);

    private SecretKeyGenerator() {
    }

    public static SecretKey generate(BlockCipher cipher) {
        CryptUtil.assertNotNullArg(cipher, "Block cipher cannot be null");
        return SecretKeyGenerator.generate(cipher.getBlockSize() * 8, cipher);
    }

    public static SecretKey generate(int bitLength, BlockCipher cipher) {
        if (bitLength < 1 || bitLength > MAX_KEY_LENGTH) {
            throw new IllegalArgumentException("Bit length must be greater than 0 and cannot exceed " + MAX_KEY_LENGTH);
        }
        CryptUtil.assertNotNullArg(cipher, "Block cipher cannot be null");
        byte[] nonce = NonceUtil.randomNonce((bitLength + 7) / 8);
        return SecretKeyGenerator.generate(bitLength, cipher, (SecureRandom)new SP800SecureRandomBuilder().buildHash((Digest)new SHA256Digest(), nonce, false));
    }

    public static SecretKey generate(int bitLength, BlockCipher cipher, SecureRandom random) {
        if (bitLength < 1 || bitLength > MAX_KEY_LENGTH) {
            throw new IllegalArgumentException("Bit length must be greater than 0 and less than " + MAX_KEY_LENGTH);
        }
        CryptUtil.assertNotNullArg(cipher, "Block cipher cannot be null");
        CryptUtil.assertNotNullArg(random, "Secure random cannot be null");
        byte[] key = new byte[(bitLength + 7) / 8];
        random.nextBytes(key);
        return new SecretKeySpec(key, cipher.getAlgorithmName());
    }
}

