/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ldaptive.servlets.Dsmlv1ServletSearchExecutor;
import org.ldaptive.servlets.ServletSearchExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchServlet
extends HttpServlet {
    private static final String SEARCH_EXECUTOR_CLASS = "searchExecutorClass";
    private static final long serialVersionUID = 3437252581014900696L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServletSearchExecutor searchExecutor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String searchExecutorClass = config.getInitParameter(SEARCH_EXECUTOR_CLASS);
        if (searchExecutorClass != null) {
            try {
                this.logger.debug("Creating search executor: {}", (Object)searchExecutorClass);
                this.searchExecutor = (ServletSearchExecutor)Class.forName(searchExecutorClass).newInstance();
            }
            catch (Exception e) {
                this.logger.error("Error instantiating {}", (Object)searchExecutorClass, (Object)e);
                throw new IllegalStateException(e);
            }
        } else {
            this.searchExecutor = new Dsmlv1ServletSearchExecutor();
        }
        this.searchExecutor.initialize(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("search={} for attributes={}", (Object)request.getParameter("query"), (Object)Arrays.toString(request.getParameterValues("attrs")));
        try {
            this.searchExecutor.search(request, response);
        }
        catch (Exception e) {
            this.logger.error("Error performing search", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        try {
            this.searchExecutor.close();
        }
        finally {
            super.destroy();
        }
    }
}

