/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.HTMLMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml1.binding.encoding.impl.BaseSAML1MessageEncoder;
import org.slf4j.Logger;

public class HTTPPostEncoder
extends BaseSAML1MessageEncoder
implements HTMLMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml1-post-binding.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostEncoder.class);
    @NonnullAfterInit
    private VelocityEngine velocityEngine;
    @NonnullAfterInit
    private String velocityTemplateId;
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;

    public HTTPPostEncoder() {
        this.setVelocityTemplateId(DEFAULT_TEMPLATE_ID);
    }

    @Override
    @Nonnull
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(@Nullable VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = newVelocityEngine;
    }

    @NonnullAfterInit
    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(@Nullable String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = newVelocityTemplateId;
    }

    @Override
    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    @Override
    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = strategy;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine must be supplied");
        }
        if (this.velocityTemplateId == null) {
            throw new ComponentInitializationException("Velocity template id must be supplied");
        }
    }

    @Override
    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (outboundMessage == null || !(outboundMessage instanceof SAMLObject)) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(messageContext).toString();
        this.postEncode(messageContext, endpointURL);
    }

    protected void postEncode(@Nonnull MessageContext messageContext, @Nonnull String endpointURL) throws MessageEncodingException {
        this.log.debug("Invoking velocity template to create POST body");
        try {
            VelocityContext context = new VelocityContext();
            XMLObject message = (XMLObject)messageContext.getMessage();
            assert (message != null);
            String encodedEndpointURL = HTMLEncoder.encodeForHTMLAttribute(endpointURL);
            this.log.debug("Encoding action url of '{}' with encoded value '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
            context.put("action", (Object)encodedEndpointURL);
            context.put("binding", (Object)this.getBindingURI());
            if (this.cspDigester != null) {
                this.log.trace("Adding CSP digester to context");
                context.put("cspDigester", (Object)this.cspDigester);
            }
            if (this.cspNonceGenerator != null) {
                this.log.trace("Adding CSP nonce generator to context");
                context.put("cspNonce", (Object)this.cspNonceGenerator);
            }
            this.log.debug("Marshalling and Base64 encoding SAML message");
            String messageXML = SerializeSupport.nodeToString(this.marshallMessage(message));
            String encodedMessage = Base64Support.encode(messageXML.getBytes("UTF-8"), false);
            context.put("SAMLResponse", (Object)encodedMessage);
            String relayState = SAMLBindingSupport.getRelayState(messageContext);
            if (relayState != null) {
                String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute(relayState);
                this.log.debug("Setting TARGET parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
                context.put("TARGET", (Object)encodedRelayState);
            }
            HttpServletResponse response = this.getHttpServletResponse();
            assert (response != null);
            context.put("response", (Object)response);
            HttpServletSupport.addNoCacheHeaders(response);
            HttpServletSupport.setUTF8Encoding(response);
            HttpServletSupport.setContentType(response, "text/html");
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");){
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
            throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
        }
        catch (EncodingException e) {
            this.log.error("Unable to base64 encode SAML message: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode SAML message", e);
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error creating output document", e);
        }
    }
}

