/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.monitor.profile;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.monitor.profile.MetricName;

public final class QueryProfile {
    private final Summary summary;
    private final Map<String, Phase> phases;
    private final PlanNode plan;

    public QueryProfile(double totalTimeMillis, Map<MetricName, Double> phases) {
        this(totalTimeMillis, phases, null);
    }

    public QueryProfile(double totalTimeMillis, Map<MetricName, Double> phases, PlanNode plan) {
        this.summary = new Summary(totalTimeMillis);
        this.phases = this.buildPhases(phases);
        this.plan = plan;
    }

    private Map<String, Phase> buildPhases(Map<MetricName, Double> phases) {
        Objects.requireNonNull(phases, "phases");
        LinkedHashMap<String, Phase> ordered = new LinkedHashMap<String, Phase>(MetricName.values().length);
        for (MetricName metricName : MetricName.values()) {
            Double value = phases.getOrDefault((Object)metricName, 0.0);
            ordered.put(metricName.name().toLowerCase(Locale.ROOT), new Phase(value));
        }
        return ordered;
    }

    @Generated
    public Summary getSummary() {
        return this.summary;
    }

    @Generated
    public Map<String, Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public PlanNode getPlan() {
        return this.plan;
    }

    public static final class PlanNode {
        private final String node;
        @SerializedName(value="time_ms")
        private final double timeMillis;
        private final long rows;
        private final List<PlanNode> children;

        public PlanNode(String node, double timeMillis, long rows, List<PlanNode> children) {
            this.node = node;
            this.timeMillis = timeMillis;
            this.rows = rows;
            this.children = children;
        }

        @Generated
        public String getNode() {
            return this.node;
        }

        @Generated
        public double getTimeMillis() {
            return this.timeMillis;
        }

        @Generated
        public long getRows() {
            return this.rows;
        }

        @Generated
        public List<PlanNode> getChildren() {
            return this.children;
        }
    }

    public static final class Summary {
        @SerializedName(value="total_time_ms")
        private final double totalTimeMillis;

        private Summary(double totalTimeMillis) {
            this.totalTimeMillis = totalTimeMillis;
        }

        @Generated
        public double getTotalTimeMillis() {
            return this.totalTimeMillis;
        }
    }

    public static final class Phase {
        @SerializedName(value="time_ms")
        private final double timeMillis;

        private Phase(double timeMillis) {
            this.timeMillis = timeMillis;
        }

        @Generated
        public double getTimeMillis() {
            return this.timeMillis;
        }
    }
}

