/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class Project
extends UnresolvedPlan {
    private List<UnresolvedExpression> projectList;
    private final List<Argument> argExprList;
    private UnresolvedPlan child;

    public Project(List<UnresolvedExpression> projectList) {
        this.projectList = projectList;
        this.argExprList = Collections.emptyList();
    }

    public Project(List<UnresolvedExpression> projectList, List<Argument> argExprList) {
        this.projectList = projectList;
        this.argExprList = argExprList;
    }

    public boolean hasArgument() {
        return !this.argExprList.isEmpty();
    }

    public boolean isExcluded() {
        if (this.hasArgument()) {
            Argument argument = this.argExprList.get(0);
            return (Boolean)argument.getValue().getValue();
        }
        return false;
    }

    @Override
    public Project attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitProject(this, context);
    }

    @Override
    @Generated
    public String toString() {
        return "Project(projectList=" + String.valueOf(this.getProjectList()) + ", argExprList=" + String.valueOf(this.getArgExprList()) + ", child=" + String.valueOf(this.getChild()) + ")";
    }

    @Generated
    public List<UnresolvedExpression> getProjectList() {
        return this.projectList;
    }

    @Generated
    public List<Argument> getArgExprList() {
        return this.argExprList;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedExpression> this$projectList = this.getProjectList();
        List<UnresolvedExpression> other$projectList = other.getProjectList();
        if (this$projectList == null ? other$projectList != null : !((Object)this$projectList).equals(other$projectList)) {
            return false;
        }
        List<Argument> this$argExprList = this.getArgExprList();
        List<Argument> other$argExprList = other.getArgExprList();
        if (this$argExprList == null ? other$argExprList != null : !((Object)this$argExprList).equals(other$argExprList)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedExpression> $projectList = this.getProjectList();
        result = result * 59 + ($projectList == null ? 43 : ((Object)$projectList).hashCode());
        List<Argument> $argExprList = this.getArgExprList();
        result = result * 59 + ($argExprList == null ? 43 : ((Object)$argExprList).hashCode());
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }

    @Generated
    public void setProjectList(List<UnresolvedExpression> projectList) {
        this.projectList = projectList;
    }
}

