/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.framework.commands;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.framework.ui.commands.FrameworkCommandChooser;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommand;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class FrameworkCommandSupport {
    private static final Logger LOGGER = Logger.getLogger(FrameworkCommandSupport.class.getName());
    private static final Map<PhpModule, Map<String, List<FrameworkCommand>>> COMMANDS_CACHE = new WeakHashMap<PhpModule, Map<String, List<FrameworkCommand>>>();
    private static final RequestProcessor RP = new RequestProcessor(FrameworkCommandSupport.class);
    protected final PhpModule phpModule;
    private PluginListener pluginListener;

    protected FrameworkCommandSupport(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public abstract String getFrameworkName();

    public abstract void runCommand(CommandDescriptor var1, Runnable var2);

    protected abstract String getOptionsPath();

    protected abstract File getPluginsDirectory();

    protected abstract List<FrameworkCommand> getFrameworkCommandsInternal();

    public final PhpModule getPhpModule() {
        return this.phpModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<FrameworkCommand> getFrameworkCommands() {
        List<FrameworkCommand> frameworkCommands = null;
        Map<PhpModule, Map<String, List<FrameworkCommand>>> map = COMMANDS_CACHE;
        synchronized (map) {
            Map<String, List<FrameworkCommand>> moduleCommands = COMMANDS_CACHE.get(this.phpModule);
            if (moduleCommands != null) {
                frameworkCommands = moduleCommands.get(this.getFrameworkName());
            }
        }
        return frameworkCommands;
    }

    public final void openPanel() {
        FrameworkCommandChooser.open(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshFrameworkCommands() {
        Object object;
        List<FrameworkCommand> freshCommands = this.getFrameworkCommandsInternal();
        File plugins = this.getPluginsDirectory();
        if (plugins != null) {
            assert (!plugins.isFile()) : "Plugins is expected to be a directory: " + plugins;
            object = this;
            synchronized (object) {
                if (this.pluginListener == null) {
                    this.pluginListener = new PluginListener();
                    FileUtil.addFileChangeListener((FileChangeListener)this.pluginListener, (File)plugins);
                }
            }
        }
        object = COMMANDS_CACHE;
        synchronized (object) {
            Map<String, List<FrameworkCommand>> moduleCommands = COMMANDS_CACHE.get(this.phpModule);
            if (moduleCommands == null) {
                moduleCommands = new HashMap<String, List<FrameworkCommand>>();
            }
            moduleCommands.put(this.getFrameworkName(), freshCommands);
            COMMANDS_CACHE.put(this.phpModule, moduleCommands);
        }
    }

    public final void refreshFrameworkCommandsLater(final Runnable post) {
        RP.execute(new Runnable(){
            final /* synthetic */ FrameworkCommandSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.refreshFrameworkCommands();
                if (post != null) {
                    post.run();
                }
            }
        });
    }

    private class PluginListener
    implements FileChangeListener {
        private PluginListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.changed();
        }

        public void fileDataCreated(FileEvent fe) {
            this.changed();
        }

        public void fileDeleted(FileEvent fe) {
            this.changed();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed() {
            Map map = COMMANDS_CACHE;
            synchronized (map) {
                COMMANDS_CACHE.remove(FrameworkCommandSupport.this.getPhpModule());
            }
        }
    }

    public static final class CommandDescriptor {
        private final FrameworkCommand task;
        private final String[] params;
        private final boolean debug;

        public CommandDescriptor(FrameworkCommand task, String params, boolean debug) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Parameters.notNull((CharSequence)"params", (Object)params);
            this.task = task;
            this.params = Utilities.parseParameters((String)params.trim());
            this.debug = debug;
        }

        public FrameworkCommand getFrameworkCommand() {
            return this.task;
        }

        public String[] getCommandParams() {
            return (String[])this.params.clone();
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

