/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

abstract class ImporterWizardPanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    protected final ChangeSupport cs = new ChangeSupport((Object)this);
    private boolean valid;
    private String errorMessage;
    static final String WORKSPACE_LOCATION_STEP = ProjectImporterWizard.getMessage("CTL_WorkspaceLocationStep");
    static final String PROJECT_SELECTION_STEP = ProjectImporterWizard.getMessage("CTL_ProjectSelectionStep");
    static final String PROJECTS_SELECTION_STEP = ProjectImporterWizard.getMessage("CTL_ProjectsSelectionStep");

    ImporterWizardPanel() {
    }

    void initPanel(JComponent comp, int wizardNumber) {
        comp.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        comp.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        comp.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        comp.putClientProperty("WizardPanel_contentSelectedIndex", wizardNumber);
        comp.putClientProperty("WizardPanel_contentData", new String[]{WORKSPACE_LOCATION_STEP, PROJECTS_SELECTION_STEP});
        comp.setPreferredSize(new Dimension(500, 380));
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    protected void setErrorMessage(String newError) {
        this.setErrorMessage(newError, newError == null);
    }

    protected void setErrorMessage(String newError, boolean valid) {
        boolean changed;
        boolean bl = changed = this.errorMessage == null && newError != null || this.errorMessage != null && !this.errorMessage.equals(newError);
        if (changed) {
            this.errorMessage = newError;
        }
        this.setValid(valid, changed);
    }

    protected void setValid(boolean valid, boolean forceFiring) {
        boolean changed;
        boolean bl = changed = this.valid != valid;
        if (changed) {
            this.valid = valid;
        }
        if (changed || forceFiring) {
            this.cs.fireChange();
        }
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void storeSettings(WizardDescriptor settings) {
    }

    public void readSettings(WizardDescriptor settings) {
    }
}

