/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.Command;
import org.netbeans.api.lsp.Range;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.EndpointSelectorPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.lsp.CodeActionProvider;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MicronautDataEndpointGenerator
implements CodeActionProvider,
CommandProvider {
    private static final String SOURCE = "source";
    private static final Set<String> SUPPORTED_CODE_ACTION_KINDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("source")));
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";
    private static final String GENERATE_ENDPOINT = "nbls.micronaut.generate.endpoint";
    private static final String GENERATE_DATA_ENDPOINT = "nbls.micronaut.generate.data.endpoint";
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String REPOSITORIES = "repositories";
    private static final String ENDPOINTS = "endpoints";
    private static final String CONTROLLER_ID = "controllerId";
    private final Gson gson = new GsonBuilder().registerTypeAdapter(NotifyDescriptor.QuickPick.Item.class, (json, type, jdc) -> {
        String label = json.getAsJsonObject().get("label").getAsString();
        String description = json.getAsJsonObject().get("description").getAsString();
        return new NotifyDescriptor.QuickPick.Item(label, description);
    }).create();

    public Set<String> getSupportedCodeActionKinds() {
        return SUPPORTED_CODE_ACTION_KINDS;
    }

    public List<CodeAction> getCodeActions(Document doc, Range range, Lookup context) {
        try {
            CompilationController cc;
            List only = (List)context.lookup(List.class);
            if (only == null || !only.contains(SOURCE)) {
                return Collections.emptyList();
            }
            ResultIterator resultIterator = (ResultIterator)context.lookup(ResultIterator.class);
            CompilationController compilationController = cc = resultIterator != null && resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
            if (cc == null) {
                return Collections.emptyList();
            }
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            int offset = range.getStartOffset();
            TreePath path = cc.getTreeUtilities().pathFor(offset);
            path = cc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return Collections.emptyList();
            }
            TypeElement te = (TypeElement)cc.getTrees().getElement(path);
            if (te == null || !te.getKind().isClass()) {
                return Collections.emptyList();
            }
            AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
            if (controllerAnn == null) {
                return Collections.emptyList();
            }
            ArrayList endpoints = new ArrayList();
            AtomicReference controllerId = new AtomicReference();
            List<VariableElement> repositories = Utils.getRepositoriesFor((CompilationInfo)cc, te);
            if (repositories.isEmpty()) {
                Utils.collectMissingEndpoints((CompilationInfo)cc, te, (annName, cId) -> {
                    controllerId.set(cId);
                    int idx = annName.lastIndexOf(46);
                    String label = "/ -- " + (idx < 0 ? annName : annName.substring(idx + 1)).toUpperCase();
                    String methodName = Utils.getControllerEndpointMethodName(annName);
                    if (methodName != null) {
                        StringBuilder sb = new StringBuilder(methodName).append('(');
                        if ("io.micronaut.http.annotation.Put".equals(annName) || "io.micronaut.http.annotation.Post".equals(annName)) {
                            sb.append("String value");
                        }
                        sb.append(')');
                        endpoints.add(new NotifyDescriptor.QuickPick.Item(label, sb.toString()));
                    }
                });
                if (!endpoints.isEmpty()) {
                    endpoints.sort((item1, item2) -> item1.getDescription().compareTo(item2.getDescription()));
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(URI, cc.getFileObject().toURI().toString());
                    data.put(OFFSET, offset);
                    data.put(CONTROLLER_ID, controllerId.get());
                    data.put(ENDPOINTS, endpoints);
                    return Collections.singletonList(new CodeAction(Bundle.DN_GenerateEndpoint(), SOURCE, new Command(Bundle.DN_GenerateEndpoint(), "nbls.generate.code", Arrays.asList(GENERATE_ENDPOINT, data)), null));
                }
                return Collections.emptyList();
            }
            Utils.collectMissingDataEndpoints((CompilationInfo)cc, te, null, (repository, delegateMethod, cId, id) -> {
                controllerId.set(cId);
                ExecutableType delegateMethodType = (ExecutableType)cc.getTypes().asMemberOf((DeclaredType)repository.asType(), delegateMethod);
                String value = Utils.getControllerDataEndpointAnnotationValue(delegateMethod, delegateMethodType, id);
                String delegateMethodName = delegateMethod.getSimpleName().toString();
                String annotationTypeName = Utils.getControllerDataEndpointAnnotationTypeName(delegateMethodName);
                if (annotationTypeName != null) {
                    int idx = annotationTypeName.lastIndexOf(46);
                    String label = (value != null ? value : "/") + " -- " + (idx < 0 ? annotationTypeName.toUpperCase() : annotationTypeName.substring(idx + 1).toUpperCase());
                    String signature = MicronautDataEndpointGenerator.getMethodSignature((CompilationInfo)cc, delegateMethod, delegateMethodType, id);
                    endpoints.add(new NotifyDescriptor.QuickPick.Item(label, Utils.getControllerDataEndpointMethodName(delegateMethodName, id) + signature));
                }
            });
            if (!endpoints.isEmpty()) {
                endpoints.sort((item1, item2) -> item1.getDescription().compareTo(item2.getDescription()));
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(URI, cc.getFileObject().toURI().toString());
                data.put(OFFSET, offset);
                data.put(REPOSITORIES, repositories.stream().map(repository -> repository.getSimpleName().toString()).collect(Collectors.toList()));
                data.put(CONTROLLER_ID, controllerId.get());
                data.put(ENDPOINTS, endpoints);
                return Collections.singletonList(new CodeAction(Bundle.DN_GenerateDataEndpoint(), SOURCE, new Command(Bundle.DN_GenerateDataEndpoint(), "nbls.generate.code", Arrays.asList(GENERATE_DATA_ENDPOINT, data)), null));
            }
        }
        catch (IOException | ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    public Set<String> getCommands() {
        return Set.of(GENERATE_ENDPOINT, GENERATE_DATA_ENDPOINT);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        if (arguments.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        JsonObject data = (JsonObject)arguments.get(0);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        RequestProcessor.getDefault().post(() -> {
            try {
                JavaSource js;
                String uri = data.getAsJsonPrimitive(URI).getAsString();
                FileObject fo = URLMapper.findFileObject((URL)java.net.URI.create(uri).toURL());
                JavaSource javaSource = js = fo != null ? JavaSource.forFileObject((FileObject)fo) : null;
                if (js == null) {
                    throw new IOException("Cannot get JavaSource for: " + uri);
                }
                int offset = data.getAsJsonPrimitive(OFFSET).getAsInt();
                List<NotifyDescriptor.QuickPick.Item> items = Arrays.asList((NotifyDescriptor.QuickPick.Item[])this.gson.fromJson(data.get(ENDPOINTS), NotifyDescriptor.QuickPick.Item[].class));
                NotifyDescriptor.QuickPick pick = new NotifyDescriptor.QuickPick(Bundle.DN_GenerateDataEndpoint(), Bundle.DN_SelectEndpoints(), items, true);
                if (DialogDescriptor.OK_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)pick)) {
                    future.complete(null);
                } else {
                    List<NotifyDescriptor.QuickPick.Item> selected = pick.getItems().stream().filter(item -> item.isSelected()).collect(Collectors.toList());
                    if (selected.isEmpty()) {
                        future.complete(null);
                    } else if (GENERATE_DATA_ENDPOINT.equals(command)) {
                        List<String> repositoryNames = Arrays.asList((String[])this.gson.fromJson(data.get(REPOSITORIES), String[].class));
                        String controllerId = data.getAsJsonPrimitive(CONTROLLER_ID).getAsString();
                        future.complete(Utils.modify2Edit(js, MicronautDataEndpointGenerator.getTask(offset, repositoryNames, selected, controllerId)));
                    } else {
                        String controllerId = data.getAsJsonPrimitive(CONTROLLER_ID).getAsString();
                        future.complete(Utils.modify2Edit(js, MicronautDataEndpointGenerator.getTask(offset, selected, controllerId)));
                    }
                }
            }
            catch (IOException ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    private static String getMethodSignature(CompilationInfo info, ExecutableElement method, ExecutableType methodType, String id) {
        StringBuilder sb = new StringBuilder("(");
        Iterator<? extends VariableElement> it = method.getParameters().iterator();
        Iterator<? extends TypeMirror> tIt = methodType.getParameterTypes().iterator();
        while (it.hasNext() && tIt.hasNext()) {
            String paramName = it.next().getSimpleName().toString();
            sb.append(Utils.getTypeName(info, tIt.next(), false, !it.hasNext() && method.isVarArgs()));
            sb.append(' ').append(paramName);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    private static Task<WorkingCopy> getTask(int offset, List<NotifyDescriptor.QuickPick.Item> items, String controllerId) {
        return copy -> {
            copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePath tp = copy.getTreeUtilities().pathFor(offset);
            tp = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                ClassTree clazz = (ClassTree)tp.getLeaf();
                TypeElement te = (TypeElement)copy.getTrees().getElement(tp);
                if (te != null) {
                    HashSet<Element> toImport = new HashSet<Element>();
                    ArrayList<MethodTree> members = new ArrayList<MethodTree>();
                    for (NotifyDescriptor.QuickPick.Item item : items) {
                        String description = item.getDescription();
                        int idx = description.indexOf(40);
                        if (idx <= 0) continue;
                        members.add(Utils.createControllerEndpointMethod(copy, description.substring(0, idx), controllerId, toImport));
                    }
                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), toImport));
                    copy.rewrite((Tree)clazz, (Tree)GeneratorUtilities.get((WorkingCopy)copy).insertClassMembers(clazz, members, offset));
                }
            }
        };
    }

    private static Task<WorkingCopy> getTask(int offset, List<String> repositoryNames, List<NotifyDescriptor.QuickPick.Item> items, String controllerId) {
        return copy -> {
            copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePath tp = copy.getTreeUtilities().pathFor(offset);
            tp = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                ClassTree clazz = (ClassTree)tp.getLeaf();
                TypeElement te = (TypeElement)copy.getTrees().getElement(tp);
                if (te != null) {
                    List<VariableElement> fields = ElementFilter.fieldsIn(te.getEnclosedElements());
                    HashSet<Element> toImport = new HashSet<Element>();
                    ArrayList<MethodTree> members = new ArrayList<MethodTree>();
                    for (String repositoryName : repositoryNames) {
                        TypeMirror repositoryType;
                        VariableElement repository = fields.stream().filter(ve -> repositoryName.contentEquals(ve.getSimpleName())).findFirst().orElse(null);
                        if (repository == null || (repositoryType = repository.asType()).getKind() != TypeKind.DECLARED) continue;
                        TypeElement repositoryTypeElement = (TypeElement)((DeclaredType)repositoryType).asElement();
                        String id = null;
                        if (repositoryNames.size() > 1 && (id = '/' + repositoryTypeElement.getSimpleName().toString().toLowerCase()).endsWith("repository")) {
                            id = id.substring(0, id.length() - 10);
                        }
                        List<ExecutableElement> repositoryMethods = ElementFilter.methodsIn(copy.getElements().getAllMembers(repositoryTypeElement));
                        for (NotifyDescriptor.QuickPick.Item item : items) {
                            int idx = item.getDescription().indexOf(40);
                            String name = item.getDescription().substring(0, idx);
                            String signature = item.getDescription().substring(idx);
                            for (ExecutableElement method : repositoryMethods) {
                                if (!name.equals(Utils.getControllerDataEndpointMethodName(method.getSimpleName().toString(), id)) || !signature.equals(MicronautDataEndpointGenerator.getMethodSignature((CompilationInfo)copy, method, (ExecutableType)copy.getTypes().asMemberOf((DeclaredType)repositoryType, method), id))) continue;
                                members.add(Utils.createControllerDataEndpointMethod(copy, (DeclaredType)repositoryType, repository.getSimpleName().toString(), method, controllerId, id, toImport));
                            }
                        }
                    }
                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), toImport));
                    copy.rewrite((Tree)clazz, (Tree)GeneratorUtilities.get((WorkingCopy)copy).insertClassMembers(clazz, members, offset));
                }
            }
        };
    }

    private static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[]{new JButton(Bundle.LBL_GenerateButton()), new JButton(Bundle.LBL_CancelButton())};
        DialogDescriptor dd = new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
        dd.addPropertyChangeListener(arg_0 -> MicronautDataEndpointGenerator.lambda$createDialogDescriptor$0((JButton[])buttons, dd, arg_0));
        return dd;
    }

    private static /* synthetic */ void lambda$createDialogDescriptor$0(JButton[] buttons, DialogDescriptor dd, PropertyChangeEvent evt) {
        if ("valid".equals(evt.getPropertyName())) {
            buttons[0].setEnabled(dd.isValid());
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<1> ret = new ArrayList<1>();
            JTextComponent comp = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController cc = (CompilationController)context.lookup(CompilationController.class);
            if (comp == null || cc == null) {
                return ret;
            }
            TreePath path = (TreePath)context.lookup(TreePath.class);
            path = cc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return ret;
            }
            try {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            TypeElement te = (TypeElement)cc.getTrees().getElement(path);
            if (te == null || !te.getKind().isClass()) {
                return ret;
            }
            AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), MicronautDataEndpointGenerator.CONTROLLER_ANNOTATION_NAME);
            if (controllerAnn == null) {
                return Collections.emptyList();
            }
            List<VariableElement> repositories = Utils.getRepositoriesFor((CompilationInfo)cc, te);
            if (repositories.isEmpty()) {
                return Collections.emptyList();
            }
            final AtomicReference controllerId = new AtomicReference();
            final ArrayList endpoints = new ArrayList();
            Utils.collectMissingDataEndpoints((CompilationInfo)cc, te, null, (repository, delegateMethod, cId, id) -> {
                controllerId.set(cId);
                ExecutableType delegateMethodType = (ExecutableType)cc.getTypes().asMemberOf((DeclaredType)repository.asType(), delegateMethod);
                String value = Utils.getControllerDataEndpointAnnotationValue(delegateMethod, delegateMethodType, id);
                String delegateMethodName = delegateMethod.getSimpleName().toString();
                String annotationTypeName = Utils.getControllerDataEndpointAnnotationTypeName(delegateMethodName);
                if (annotationTypeName != null) {
                    int idx = annotationTypeName.lastIndexOf(46);
                    String label = (value != null ? value : "/") + " -- " + (idx < 0 ? annotationTypeName.toUpperCase() : annotationTypeName.substring(idx + 1).toUpperCase());
                    String signature = MicronautDataEndpointGenerator.getMethodSignature((CompilationInfo)cc, delegateMethod, delegateMethodType, id);
                    endpoints.add(new NotifyDescriptor.QuickPick.Item(label, Utils.getControllerDataEndpointMethodName(delegateMethodName, id) + signature));
                }
            });
            if (!endpoints.isEmpty()) {
                endpoints.sort((item1, item2) -> item1.getDescription().compareTo(item2.getDescription()));
                final int offset = comp.getCaretPosition();
                final FileObject fo = cc.getFileObject();
                final List repositoryNames = repositories.stream().map(repository -> repository.getSimpleName().toString()).collect(Collectors.toList());
                ret.add(new CodeGenerator(){
                    final /* synthetic */ Factory this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String getDisplayName() {
                        return Bundle.DN_DataEndpoint();
                    }

                    public void invoke() {
                        EndpointSelectorPanel panel = new EndpointSelectorPanel(endpoints);
                        DialogDescriptor dialogDescriptor = MicronautDataEndpointGenerator.createDialogDescriptor(panel, Bundle.LBL_GenerateDataEndpoint());
                        panel.addPropertyChangeListener(evt -> {
                            List<NotifyDescriptor.QuickPick.Item> selected = panel.getSelectedEndpoints();
                            dialogDescriptor.setValid(selected != null && !selected.isEmpty());
                        });
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                        if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                            return;
                        }
                        List<NotifyDescriptor.QuickPick.Item> selected = panel.getSelectedEndpoints();
                        if (selected.isEmpty()) {
                            return;
                        }
                        try {
                            JavaSource js = JavaSource.forFileObject((FileObject)fo);
                            if (js == null) {
                                throw new IOException("Cannot get JavaSource for: " + fo.toURL().toString());
                            }
                            js.runModificationTask(MicronautDataEndpointGenerator.getTask(offset, repositoryNames, selected, (String)controllerId.get())).commit();
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            return ret;
        }
    }
}

