/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.io.InputStream;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.JMSWizardPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.JmsPropertyPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelperHolder;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Util;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JMSWizard
implements WizardDescriptor.InstantiatingIterator,
WizardConstants {
    private static Project project;
    private WizardDescriptor.Panel[] panels;
    private transient String[] steps;
    private transient int index;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private static final String DATAFILE = "org/netbeans/modules/j2ee/sun/sunresources/beans/JMSWizard.xml";

    public static JMSWizard create() {
        return new JMSWizard();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new JMSWizardPanel(this.helper, this.wizardInfo), new JmsPropertyPanel(this.helper, this.wizardInfo)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(JMSWizard.class, (String)"Choose"), NbBundle.getMessage(JMSWizard.class, (String)"LBL_GeneralAttributes_JMS"), NbBundle.getMessage(JMSWizard.class, (String)"LBL_AddProperty")};
    }

    public Set instantiate() {
        try {
            ResourceUtils.saveJMSResourceDatatoXml(this.helper.getData(), Util.getBaseName(project));
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizardInfo = this.getWizardInfo();
        this.helper = new ResourceConfigHelperHolder().getJMSHelper();
        wiz.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(JMSWizard.class, (String)"Templates/SunResources/JMS_Resource"));
        this.index = 0;
        project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels();
        this.steps = this.createSteps();
        try {
            FileObject pkgLocation = project.getProjectDirectory();
            if (pkgLocation != null) {
                this.helper.getData().setTargetFileObject(pkgLocation);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", this.steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public Wizard getWizardInfo() {
        try {
            InputStream in = Wizard.class.getClassLoader().getResourceAsStream(DATAFILE);
            this.wizardInfo = Wizard.createGraph(in);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return this.wizardInfo;
    }

    public String name() {
        return NbBundle.getMessage(JMSWizard.class, (String)"Templates/SunResources/JMS_Resource");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public synchronized void nextPanel() {
        if (this.index + 1 == this.panels.length) {
            throw new NoSuchElementException();
        }
        if (this.index == 0) {
            ((JmsPropertyPanel)this.panels[1]).refreshFields();
        }
        ++this.index;
    }

    public synchronized void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public ResourceConfigHelper getResourceConfigHelper() {
        return this.helper;
    }

    public void setResourceConfigHelper(ResourceConfigHelper helper) {
        this.helper = helper;
    }
}

