/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options.ui.v2.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.actions.RunCalibrationAction;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.options.ui.v2.ProfilerOptionsContainer;
import org.netbeans.modules.profiler.options.ui.v2.ProfilerOptionsPanel;
import org.netbeans.modules.profiler.options.ui.v2.impl.Bundle;
import org.openide.awt.Mnemonics;

public final class GeneralOptionsPanel
extends ProfilerOptionsPanel {
    private JCheckBox noDataHintChoice;
    private JCheckBox profilerStatusChoice;
    private JSpinner portSpinner;
    private JButton resetDNSAButton;

    public GeneralOptionsPanel() {
        this.initUI();
    }

    @Override
    public String getDisplayName() {
        return Bundle.GeneralOptionsPanel_Name();
    }

    @Override
    public void storeTo(ProfilerIDESettings settings) {
        settings.setShowNoDataHint(this.noDataHintChoice.isSelected());
        settings.setLogProfilerStatus(this.profilerStatusChoice.isSelected());
        settings.setPortNo(((Integer)this.portSpinner.getValue()).intValue());
    }

    @Override
    public void loadFrom(ProfilerIDESettings settings) {
        this.noDataHintChoice.setSelected(settings.getShowNoDataHint());
        this.profilerStatusChoice.setSelected(settings.getLogProfilerStatus());
        this.portSpinner.setValue(settings.getPortNo());
        this.resetDNSAButton.setEnabled(true);
    }

    @Override
    public boolean equalsTo(ProfilerIDESettings settings) {
        if (this.noDataHintChoice.isSelected() != settings.getShowNoDataHint()) {
            return false;
        }
        if (this.profilerStatusChoice.isSelected() != settings.getLogProfilerStatus()) {
            return false;
        }
        return Objects.equals(this.portSpinner.getValue(), settings.getPortNo());
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        int htab = 8;
        int hgap = 10;
        int vgap = 5;
        ProfilerOptionsPanel.Separator dataTransferSeparator = new ProfilerOptionsPanel.Separator(Bundle.GeneralOptionsPanel_CatWindow());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, vgap * 2, 0);
        this.add((Component)dataTransferSeparator, c);
        this.noDataHintChoice = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.noDataHintChoice, (String)Bundle.GeneralOptionsPanel_NoDataHint());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)this.noDataHintChoice, c);
        this.profilerStatusChoice = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilerStatusChoice, (String)Bundle.GeneralOptionsPanel_ProfilerStatus());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(vgap, htab, vgap, 0);
        this.add((Component)this.profilerStatusChoice, c);
        ProfilerOptionsPanel.Separator profilingSeparator = new ProfilerOptionsPanel.Separator(Bundle.GeneralOptionsPanel_CatProfiling());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(vgap * 4, 0, vgap * 2, 0);
        this.add((Component)profilingSeparator, c);
        JLabel portLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)portLabel, (String)Bundle.GeneralOptionsPanel_ProfilingPort());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)portLabel, c);
        this.portSpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(5140, 1, 65535, 1));
        portLabel.setLabelFor(this.portSpinner);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.portSpinner, c);
        JLabel manageCalibrationLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)manageCalibrationLabel, (String)Bundle.GeneralOptionsPanel_ManageCalibration());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 3;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)manageCalibrationLabel, c);
        JButton manageCalibrationButton = new JButton(){

            @Override
            protected void fireActionPerformed(final ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        new RunCalibrationAction().actionPerformed(e);
                    }
                });
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)manageCalibrationButton, (String)Bundle.GeneralOptionsPanel_ManageButton());
        manageCalibrationLabel.setLabelFor(manageCalibrationButton);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)manageCalibrationButton, c);
        ProfilerOptionsPanel.Separator miscSeparator = new ProfilerOptionsPanel.Separator(Bundle.GeneralOptionsPanel_CatMiscellaneous());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(vgap * 4, 0, vgap * 2, 0);
        this.add((Component)miscSeparator, c);
        JLabel resetDNSALabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)resetDNSALabel, (String)Bundle.GeneralOptionsPanel_ResetDNSA());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)resetDNSALabel, c);
        this.resetDNSAButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                ProfilerIDESettings.getInstance().clearDoNotShowAgainMap();
                GeneralOptionsPanel.this.reloadAllPanels();
                this.setEnabled(false);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.resetDNSAButton, (String)Bundle.GeneralOptionsPanel_ResetButton());
        resetDNSALabel.setLabelFor(this.resetDNSAButton);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.resetDNSAButton, c);
        JPanel filler = UIUtils.createFillerPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)filler, c);
        Dimension dim1 = manageCalibrationButton.getPreferredSize();
        Dimension dim2 = this.resetDNSAButton.getPreferredSize();
        Dimension dim3 = this.portSpinner.getPreferredSize();
        int width = manageCalibrationButton.getPreferredSize().width;
        width = Math.max(dim1.width, dim2.width);
        dim1.width = width = Math.max(width, dim3.width);
        dim2.width = width;
        dim3.width = width;
        manageCalibrationButton.setPreferredSize(dim1);
        this.resetDNSAButton.setPreferredSize(dim2);
        this.portSpinner.setPreferredSize(dim3);
    }

    private void reloadAllPanels() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ProfilerOptionsContainer)) continue;
            ProfilerIDESettings settings = ProfilerIDESettings.getInstance();
            ((ProfilerOptionsContainer)parent).loadFrom(settings);
            return;
        }
    }
}

