/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.DocumentViewPanel;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.RuleNode;
import org.netbeans.modules.css.visual.actions.OpenLocationAction;
import org.netbeans.modules.css.visual.spi.Location;
import org.netbeans.modules.css.visual.spi.RuleHandle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class StyleSheetNode
extends AbstractNode {
    static final String ICON_BASE = "org/netbeans/modules/css/visual/resources/style_sheet_16.png";
    private final FileObject styleSheet;

    StyleSheetNode(DocumentViewModel model, FileObject stylesheet, Filter filter) {
        super((Children)new StyleSheetChildren(model, stylesheet, filter), StyleSheetNode.lookup(stylesheet));
        this.styleSheet = stylesheet;
        this.updateDisplayName();
        this.setIconBaseWithExtension(ICON_BASE);
    }

    private static Lookup lookup(FileObject stylesheet) {
        Project project = FileOwnerQuery.getOwner((FileObject)stylesheet);
        Location location = new Location(stylesheet);
        return project == null ? Lookups.fixed((Object[])new Object[]{location}) : Lookups.fixed((Object[])new Object[]{location, project});
    }

    private void updateDisplayName() {
        FileObject webRoot = ProjectWebRootQuery.getWebRoot((FileObject)this.styleSheet);
        String path = webRoot == null ? this.styleSheet.getNameExt() : FileUtil.getRelativePath((FileObject)webRoot, (FileObject)this.styleSheet);
        this.setDisplayName(path);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenLocationAction.class);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenLocationAction.class)};
    }

    static class StyleSheetChildren
    extends Children.Keys<RuleHandle>
    implements ChangeListener {
        private DocumentViewModel model;
        private final FileObject stylesheet;
        private final Project project;
        private final Filter filter;

        StyleSheetChildren(DocumentViewModel model, FileObject stylesheet, Filter filter) {
            this.model = model;
            this.stylesheet = stylesheet;
            this.filter = filter;
            this.project = FileOwnerQuery.getOwner((FileObject)stylesheet);
            filter.addPropertyChangeListener(this.createListener());
            this.refreshKeys();
        }

        void setModel(DocumentViewModel newModel) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addChangeListener(this);
            }
            this.refreshKeys();
        }

        private PropertyChangeListener createListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("pattern".equals(propertyName)) {
                        DocumentViewPanel.RP.post(new Runnable(){

                            @Override
                            public void run() {
                                this.refreshKeys();
                            }
                        });
                    }
                }
            };
        }

        private void refreshKeys() {
            final DocumentViewModel dvm = this.model;
            if (dvm == null) {
                this.setKeys(Collections.emptyList());
            } else {
                final AtomicReference result = new AtomicReference();
                try {
                    ParserManager.parse((String)"text/css", (UserTask)new UserTask(this){
                        final /* synthetic */ StyleSheetChildren this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(ResultIterator resultIterator) throws Exception {
                            ArrayList<RuleHandle> keys = new ArrayList<RuleHandle>();
                            List<RuleHandle> ruleHandles = dvm.getFilesToRulesMap().get(this.this$0.stylesheet);
                            if (ruleHandles != null) {
                                for (RuleHandle handle : ruleHandles) {
                                    if (!this.this$0.includeKey(handle)) continue;
                                    keys.add(handle);
                                }
                            }
                            result.set(keys);
                        }
                    });
                    this.setKeys((Collection)result.get());
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private boolean includeKey(RuleHandle rule) {
            boolean include = true;
            String pattern = this.filter.getPattern();
            if (pattern != null) {
                String selector = rule.getDisplayName();
                include = selector.indexOf(pattern) != -1;
            }
            return include;
        }

        protected Node[] createNodes(RuleHandle key) {
            return new Node[]{new RuleNode(key, this.project)};
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.refreshKeys();
        }
    }
}

