/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openide.util.Parameters;

public abstract class CachedHiDPIIcon
implements Icon {
    private static final double MAX_CACHE_SIZE = 10.0;
    private final int width;
    private final int height;
    private final Map<CachedImageKey, Image> cache = new LinkedHashMap<CachedImageKey, Image>(16, 0.75f, true);
    private double cacheSize = 0.0;

    protected CachedHiDPIIcon(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        if (height < 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    private synchronized Image getScaledImageCached(Component c, CachedImageKey key) {
        Image ret = this.cache.get(key);
        if (ret != null) {
            return ret;
        }
        double scale = key.getScale();
        int deviceWidth = (int)Math.ceil((double)this.getIconWidth() * scale);
        int deviceHeight = (int)Math.ceil((double)this.getIconHeight() * scale);
        Image img = this.createAndPaintImage(c, key.getColorModel(), deviceWidth, deviceHeight, scale);
        double imgSize = key.getSize();
        if (imgSize <= 10.0) {
            Iterator<CachedImageKey> iter = this.cache.keySet().iterator();
            while (this.cacheSize + imgSize > 10.0 && iter.hasNext()) {
                CachedImageKey removeKey = iter.next();
                iter.remove();
                this.cacheSize -= removeKey.getSize();
            }
            this.cache.put(key, img);
            this.cacheSize += imgSize;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component c, Graphics g0, int x, int y) {
        if (this.getIconWidth() == 0 || this.getIconHeight() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g0;
        CachedImageKey key = CachedImageKey.create(g);
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(x, y);
            Image scaledImage = this.getScaledImageCached(c, key);
            AffineTransform tx2 = g.getTransform();
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)tx2.getTranslateX(), (int)tx2.getTranslateY()));
            g.drawImage(scaledImage, 0, 0, null);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    protected abstract Image createAndPaintImage(Component var1, ColorModel var2, int var3, int var4, double var5);

    protected static final BufferedImage createBufferedImage(ColorModel colorModel, int deviceWidth, int deviceHeight) {
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(deviceWidth, deviceHeight), colorModel.isAlphaPremultiplied(), null);
    }

    private static final class CachedImageKey {
        private final ColorModel colorModel;
        private final double scale;

        private CachedImageKey(ColorModel colorModel, double scale) {
            Parameters.notNull((CharSequence)"colorModel", (Object)colorModel);
            if (scale <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.colorModel = colorModel;
            this.scale = scale;
        }

        public static CachedImageKey create(Graphics2D g) {
            AffineTransform tx = g.getTransform();
            int txType = tx.getType();
            double scale = txType == 2 || txType == 3 ? tx.getScaleX() : 1.0;
            GraphicsConfiguration gconf = g.getDeviceConfiguration();
            ColorModel colorModel = gconf.getColorModel(3);
            return new CachedImageKey(colorModel, scale);
        }

        public double getScale() {
            return this.scale;
        }

        public double getSize() {
            return Math.pow(this.getScale(), 2.0);
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public int hashCode() {
            return Objects.hash(this.colorModel, this.scale);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedImageKey)) {
                return false;
            }
            CachedImageKey other = (CachedImageKey)obj;
            return this.colorModel.equals(other.colorModel) && this.scale == other.scale;
        }

        public String toString() {
            return "CachedImageKey(" + String.valueOf(this.colorModel) + ", " + this.scale + ")";
        }
    }
}

