/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.hints.analyzer.ui.AnalyzerTopComponent;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;

public class Analyzer
implements Runnable {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final RequestProcessor RP = new RequestProcessor(Analyzer.class.getName(), 1, false, false);
    private final Lookup context;
    private final AtomicBoolean cancel;
    private final ProgressHandle handle;
    private final HintsSettings hintsSettings;

    public Analyzer(Lookup context, AtomicBoolean cancel, ProgressHandle handle, HintsSettings hintsSettings) {
        this.context = context;
        this.cancel = cancel;
        this.handle = handle;
        this.hintsSettings = hintsSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.handle.start();
        try {
            LinkedList<FileObject> toProcess = new LinkedList<FileObject>();
            LinkedList<Object> q = new LinkedList<Object>();
            q.addAll(Analyzer.toAnalyze(this.context));
            while (!q.isEmpty()) {
                FileObject f = (FileObject)q.poll();
                if (f.isData() && JAVA_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)f))) {
                    toProcess.add(f);
                }
                if (!f.isFolder()) continue;
                q.addAll(Arrays.asList(f.getChildren()));
            }
            final LinkedList eds = new LinkedList();
            if (!toProcess.isEmpty()) {
                this.handle.switchToDeterminate(toProcess.size());
                ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)((FileObject)toProcess.get(0)));
                JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, toProcess);
                final AtomicInteger f = new AtomicInteger();
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){
                        final /* synthetic */ Analyzer this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(CompilationController cc) throws Exception {
                            if (this.this$0.cancel.get()) {
                                return;
                            }
                            DataObject d = DataObject.find((FileObject)cc.getFileObject());
                            EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
                            try {
                                StyledDocument doc = ec.openDocument();
                            }
                            catch (UserQuestionException uqe) {
                                uqe.confirmed();
                                StyledDocument doc = ec.openDocument();
                            }
                            this.this$0.handle.progress(FileUtil.getFileDisplayName((FileObject)cc.getFileObject()));
                            if (cc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                                return;
                            }
                            this.this$0.handle.progress(f.incrementAndGet());
                            eds.addAll(new HintsInvoker(this.this$0.hintsSettings, new AtomicBoolean()).computeHints((CompilationInfo)cc));
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (!this.cancel.get()) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ Analyzer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        AnalyzerTopComponent win = AnalyzerTopComponent.findInstance();
                        win.open();
                        win.requestActive();
                        win.setData(this.this$0.context, this.this$0.hintsSettings, eds);
                    }
                });
            }
        }
        finally {
            this.handle.finish();
        }
    }

    public static void process(Lookup context, HintsSettings hintsSettings) {
        AtomicBoolean abCancel = new AtomicBoolean();
        class Cancel
        implements Cancellable {
            final /* synthetic */ AtomicBoolean val$abCancel;

            Cancel(AtomicBoolean atomicBoolean) {
                this.val$abCancel = atomicBoolean;
            }

            public boolean cancel() {
                this.val$abCancel.set(true);
                return true;
            }
        }
        ProgressHandle h = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Analyzer.class, (String)"LBL_AnalyzingJavadoc"), (Cancellable)new Cancel(abCancel));
        RP.post((Runnable)new Analyzer(context, abCancel, h, hintsSettings));
    }

    public static Lookup normalizeLookup(Lookup l) {
        if (!l.lookupAll(Project.class).isEmpty()) {
            return Lookups.fixed((Object[])l.lookupAll(Project.class).toArray(new Object[0]));
        }
        Collection<? extends FileObject> files = Analyzer.toAnalyze(l);
        if (!files.isEmpty()) {
            return Lookups.fixed((Object[])files.toArray(new Object[0]));
        }
        return null;
    }

    private static Collection<? extends FileObject> toAnalyze(Lookup l) {
        LinkedHashSet<FileObject> result = new LinkedHashSet<FileObject>();
        for (FileObject fo : l.lookupAll(FileObject.class)) {
            if (fo.getMIMEType().equals(JAVA_MIME_TYPE)) {
                result.add(fo);
            }
            if (!fo.isFolder() || !Analyzer.containsJavaFiles(fo)) continue;
            result.add(fo);
        }
        for (DataObject od : l.lookupAll(DataObject.class)) {
            FileObject primaryFile = od.getPrimaryFile();
            if (primaryFile.getMIMEType().equals(JAVA_MIME_TYPE)) {
                result.add(primaryFile);
            }
            if (!primaryFile.isFolder() || !Analyzer.containsJavaFiles(primaryFile)) continue;
            result.add(primaryFile);
        }
        for (Project p : l.lookupAll(Project.class)) {
            Sources s = ProjectUtils.getSources((Project)p);
            for (SourceGroup sg : s.getSourceGroups("java")) {
                result.add(sg.getRootFolder());
            }
        }
        return result;
    }

    private static boolean containsJavaFiles(FileObject folder) {
        if (Boolean.TRUE.equals(folder.getAttribute("isRemoteAndSlow"))) {
            return true;
        }
        int i = 0;
        FileObject[] children = folder.getChildren();
        if (i < children.length) {
            FileObject child = children[i];
            if (child.getMIMEType().equals(JAVA_MIME_TYPE)) {
                return true;
            }
            return Analyzer.containsJavaFiles(child);
        }
        return false;
    }
}

