/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.osgi.util.NLS;

public class ExtensionPointReader<T> {
    private static final String DEFAULT_ATTRIBUTE_ID_CLASS = "class";
    private static final String DEFAULT_ATTRIBUTE_ID_PRIORITY = "priority";
    private final PriorityComparator priorityComparator = new PriorityComparator();
    private String classAttributeId;
    private final Class<T> clazz;
    private final String elementId;
    private final String extensionId;
    private String filterAttributeId;
    private String filterAttributeValue;
    private final List<T> items;
    private final String pluginId;
    private String priorityAttributeId;

    public ExtensionPointReader(String pluginId, String extensionId, String elementId, Class<T> clazz) {
        this(pluginId, extensionId, elementId, clazz, null, null);
    }

    public ExtensionPointReader(String pluginId, String extensionId, String elementId, Class<T> clazz, String filterAttributeId, String filterAttributeValue) {
        Assert.isNotNull((Object)pluginId);
        Assert.isNotNull((Object)extensionId);
        Assert.isNotNull((Object)elementId);
        Assert.isNotNull(clazz);
        this.pluginId = pluginId;
        this.extensionId = extensionId;
        this.elementId = elementId;
        this.clazz = clazz;
        this.filterAttributeId = filterAttributeId;
        this.filterAttributeValue = filterAttributeValue;
        this.classAttributeId = DEFAULT_ATTRIBUTE_ID_CLASS;
        this.priorityAttributeId = DEFAULT_ATTRIBUTE_ID_PRIORITY;
        this.items = new ArrayList<T>();
    }

    public final String getClassAttributeId() {
        return this.classAttributeId;
    }

    public final String getElementId() {
        return this.elementId;
    }

    public T getItem() {
        return this.items.isEmpty() ? null : (T)this.items.get(0);
    }

    public List<T> getItems() {
        return new ArrayList<T>(this.items);
    }

    public final String getPluginId() {
        return this.pluginId;
    }

    public String getPriorityAttributeId() {
        return this.priorityAttributeId;
    }

    public IStatus read() {
        this.items.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus result = new MultiStatus(this.pluginId, 0, NLS.bind((String)"Extensions for {0}/{1} failed to load", (Object)this.pluginId, (Object)this.elementId), null);
        IExtensionPoint extensionPoint = registry.getExtensionPoint(String.valueOf(this.pluginId) + "." + this.extensionId);
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                Arrays.sort(elements, this.priorityComparator);
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    T item;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(this.elementId) && this.shouldRead(element) && (item = this.readElement(element, result)) != null) {
                        this.items.add(item);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.handleResult((IStatus)result);
        return result;
    }

    public final void setClassAttributeId(String classAttributeId) {
        this.classAttributeId = classAttributeId;
    }

    public void setFilterAttributeId(String filterAttributeId) {
        this.filterAttributeId = filterAttributeId;
    }

    public void setFilterAttributeValue(String filterAttributeValue) {
        this.filterAttributeValue = filterAttributeValue;
    }

    public void setPriorityAttributeId(String priorityAttributeId) {
        this.priorityAttributeId = priorityAttributeId;
    }

    protected void handleResult(IStatus result) {
        if (!result.isOK()) {
            StatusHandler.log(result);
        }
    }

    protected T readElement(IConfigurationElement element, MultiStatus result) {
        try {
            Object object = element.createExecutableExtension(this.getClassAttributeId());
            if (this.clazz.isInstance(object)) {
                return this.clazz.cast(object);
            }
            result.add((IStatus)new Status(4, this.pluginId, NLS.bind((String)"Class ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)this.getPluginId())));
        }
        catch (Throwable e) {
            result.add((IStatus)new Status(4, this.pluginId, NLS.bind((String)"Failed to load for extension contributed by {0}", (Object)this.getPluginId()), e));
        }
        return null;
    }

    protected boolean shouldRead(IConfigurationElement element) {
        return this.filterAttributeId == null || this.filterAttributeValue == null || this.filterAttributeValue.equals(element.getAttribute(this.filterAttributeId)) || this.filterAttributeValue.length() == 0 && element.getAttribute(this.filterAttributeId) == null;
    }

    private final class PriorityComparator
    implements Comparator<IConfigurationElement> {
        private PriorityComparator() {
        }

        @Override
        public int compare(IConfigurationElement arg0, IConfigurationElement arg1) {
            String priorityAttribute;
            double p0 = 0.0;
            double p1 = 0.0;
            try {
                priorityAttribute = arg0.getAttribute(ExtensionPointReader.this.getPriorityAttributeId());
                if (priorityAttribute != null) {
                    p0 = Double.parseDouble(priorityAttribute);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                priorityAttribute = arg1.getAttribute(ExtensionPointReader.this.getPriorityAttributeId());
                if (priorityAttribute != null) {
                    p1 = Double.parseDouble(priorityAttribute);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (p1 > p0) {
                return 1;
            }
            if (p1 < p0) {
                return -1;
            }
            return 0;
        }
    }
}

