/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.event.SelectEvent;
import org.primefaces.mobile.event.SwipeEvent;
import org.primefaces.model.LazyDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataList
extends UIData
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataList";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataListRenderer";
    public static final String DATALIST_CLASS = "ui-datalist ui-widget";
    public static final String CONTENT_CLASS = "ui-datalist-content ui-widget-content";
    public static final String LIST_CLASS = "ui-datalist-data";
    public static final String LIST_ITEM_CLASS = "ui-datalist-item";
    public static final String HEADER_CLASS = "ui-datalist-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datalist-footer ui-widget-header ui-corner-bottom";
    public static final String DATALIST_EMPTYMESSAGE_CLASS = "ui-datalist-empty-message";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("swipeleft", "swiperight", "tap", "taphold"));

    public DataList() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"unordered");
    }

    public void setType(String _type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)_type);
    }

    public String getItemType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.itemType), null);
    }

    public void setItemType(String _itemType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.itemType), (Object)_itemType);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getVarStatus() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.varStatus), null);
    }

    public void setVarStatus(String _varStatus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.varStatus), (Object)_varStatus);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
    }

    public String getItemStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.itemStyleClass), null);
    }

    public void setItemStyleClass(String _itemStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.itemStyleClass), (Object)_itemStyleClass);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getListTag() {
        String type = this.getType();
        if (type.equalsIgnoreCase("unordered")) {
            return "ul";
        }
        if (type.equalsIgnoreCase("ordered")) {
            return "ol";
        }
        if (type.equalsIgnoreCase("definition")) {
            return "dl";
        }
        if (type.equalsIgnoreCase("none")) {
            return null;
        }
        throw new FacesException("DataList '" + this.getClientId() + "' has invalid list type:'" + type + "'");
    }

    public boolean isDefinition() {
        return this.getType().equalsIgnoreCase("definition");
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), null, null, null);
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public boolean isRequestSource(FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return partialSource != null && this.getClientId(context).equals(partialSource);
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            if (eventName.equals("swipeleft") || eventName.equals("swiperight")) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
                String clientId = this.getClientId(context);
                int index = Integer.parseInt((String)params.get(clientId + "_item"));
                this.setRowIndex(index);
                SwipeEvent swipeEvent = new SwipeEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
                swipeEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.setRowIndex(-1);
                super.queueEvent((FacesEvent)swipeEvent);
            } else if (eventName.equals("tap") || eventName.equals("taphold")) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
                String clientId = this.getClientId(context);
                int index = Integer.parseInt((String)params.get(clientId + "_item"));
                this.setRowIndex(index);
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.setRowIndex(-1);
                super.queueEvent((FacesEvent)selectEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        type,
        itemType,
        style,
        styleClass,
        varStatus,
        emptyMessage,
        itemStyleClass;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

